/*
 * Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
 * See LICENSE in the project root for license information.
 */

/* global global, Office, self, window */
const g = getGlobal();
var mailboxItem;

Office.onReady(() => {
	// If needed, Office.js is ready to be called
	mailboxItem = Office.context.mailbox.item;
	
	console.log("mailboxItem Loaded!!!");
});

function getGlobal() {
  return typeof self !== "undefined"
    ? self
    : typeof window !== "undefined"
    ? window
    : typeof global !== "undefined"
    ? global
    : undefined;
}

async function onMessageAttachmentsChangedHandler(event) {
	console.log("OnMessageAttachmentsChanged event fired for the file: " + event.attachmentDetails.name);
	
	// Be sure to indicate when the add-in command function is complete
	event.completed();
}

// 1st parameter: FunctionName of LaunchEvent in the manifest; 2nd parameter: Its implementation in this .js file.
Office.actions.associate("onMessageAttachmentsChangedHandler", onMessageAttachmentsChangedHandler);
