'use strict';
jQuery(document).ready(function ($) {
    var woocommerce_multi_currency = {
        init: function () {
            this.design();
            this.checkPosition();
        },
        design: function () {
            var windowsize = jQuery(window).width();
            if (windowsize <= 768) {
                jQuery('.woocommerce-multi-currency.wmc-sidebar').on('click', function () {
                    jQuery(this).toggleClass('wmc-hover');
                    if (jQuery(this).hasClass('wmc-hover')) {
                        jQuery('html').css({'overflow': 'hidden'});
                    } else {
                        jQuery('html').css({'overflow': 'visible'});
                    }
                })
            } else {
                /*replace hover with mouseenter mouseleave in some cases to work correctly*/
                jQuery('.woocommerce-multi-currency.wmc-sidebar').on('mouseenter', function () {
                    let $this = jQuery(this);
                    $this.addClass('wmc-hover');
                });
                jQuery('.woocommerce-multi-currency.wmc-sidebar').on('mouseleave', function () {
                    let $this = jQuery(this);
                    $this.removeClass('wmc-hover');
                })
            }
        },
        checkPosition: function () {
            jQuery('.woocommerce-multi-currency .wmc-currency-wrapper').on('hover', function () {
                if (this.getBoundingClientRect().top / $(window).height() > 0.5) {
                    $('.woocommerce-multi-currency .wmc-sub-currency').addClass('wmc-show-up');
                } else {
                    $('.woocommerce-multi-currency .wmc-sub-currency').removeClass('wmc-show-up');
                }
            });
        }
    };

    woocommerce_multi_currency.init();

});
