﻿<?php
/*  PHP Paypal IPN Integration Class Demonstration File
 *  4.16.2005 - Micah Carrick, email@micahcarrick.com
 *
 *  This file demonstrates the usage of paypal.class.php, a class designed  
 *  to aid in the interfacing between your website, paypal, and the instant
 *  payment notification (IPN) interface.  This single file serves as 4 
 *  virtual pages depending on the "action" varialble passed in the URL. It's
 *  the processing page which processes form data being submitted to paypal, it
 *  is the page paypal returns a user to upon success, it's the page paypal
 *  returns a user to upon canceling an order, and finally, it's the page that
 *  handles the IPN request from Paypal.
 *
 *  I tried to comment this file, aswell as the acutall class file, as well as
 *  I possibly could.  Please email me with questions, comments, and suggestions.
 *  See the header of paypal.class.php for additional resources and information.
*/
// Setup class
require_once('paypal.test.class.php');  // include the class file
require('PaypalIPN.php');
$p = new paypal_class;             // initiate an instance of the class
$ipn = new PaypalIPN();
//$p->paypal_url = 'https://www.paypal.com/cgi-bin/webscr';   // testing paypal url
// setup a variable for this script (ie: 'http://www.micahcarrick.com/paypal.php')
$this_script = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];
// if there is not action variable, set the default action of 'process'
if (empty($_GET['action']))
	$_GET['action'] = 'process';
switch ($_GET['action']) {
	case 'process':      // Process and order...
		$precioDolar = 0;
		$nombreProducto = "";
		$suscripcion = $_GET['suscripcion'];
		if (isset($_GET['product'])) {
			$p->add_field('custom', $_GET['product']);
			if ($_GET['product'] == "1") { //Licencia Microsoft Office + Open Office + PDF
				$precioDolar = 55;
				$nombreProducto = "MetaClean for Microsoft Office + OpenOffice + PDF";
			} else if ($_GET['product'] == "2") { //Licencia Microsoft Office + Open Office
				$precioDolar = 36;
				$nombreProducto = "MetaClean for Microsoft Office + OpenOffice";
			} else if ($_GET['product'] == "3") { //Licencia Microsoft Office + PDF
				$precioDolar = 40;
				$nombreProducto = "MetaClean for Microsoft Office + PDF";
			} else if ($_GET['product'] == "4") { //Licencia Open Office + PDF
				$precioDolar = 36;
				$nombreProducto = "MetaClean for OpenOffice + PDF";
			} else if ($_GET['product'] == "5") { //Licencia Microsoft Office
				$precioDolar = 20;
				$nombreProducto = "MetaClean for Microsoft Office";
			} else if ($_GET['product'] == "6") { //Licencia Open Office
				$precioDolar = 16;
				$nombreProducto = "MetaClean for OpenOffice";
			} else if ($_GET['product'] == "7") { //Licencia PDF
				$precioDolar = 20;
				$nombreProducto = "MetaClean for PDF";
			} else if ($_GET['product'] == "9") { //OpenOffice + Multimedia
				$precioDolar = 47;
				$nombreProducto = "MetaClean for OpenOffice + Image, Audio and Video";
			} else if ($_GET['product'] == "10") { //PDF + Multimedia
				$precioDolar = 51;
				$nombreProducto = "MetaClean for PDF + Image, Audio and Video";
			} else if ($_GET['product'] == "11") { //Multimedia
				$precioDolar = 31;
				$nombreProducto = "MetaClean for Image, Audio and Video";
			} else if ($_GET['product'] == "12") { //Licencia FULL
				$precioDolar = 57;
				$nombreProducto = "MetaClean for Microsoft Office + PDF + OpenOffice + Image, Audio and Video";
			} else if ($_GET['product'] == "13") { //Licencia Microsoft Office + Open Office + Multimedia
				$precioDolar = 55;
				$nombreProducto = "MetaClean for Microsoft Office + OpenOffice + Image, Audio and Video";
			} else if ($_GET['product'] == "14") { //Licencia Microsoft Office + PDF + Multimedia
				$precioDolar = 55;
				$nombreProducto = "MetaClean for Microsoft Office + PDF + Image, Audio and Video";
			} else if ($_GET['product'] == "15") { //Licencia OpenOffice + PDF + Multimedia
				$precioDolar = 53;
				$nombreProducto = "MetaClean for OpenOffice + PDF + Image, Audio and Video";
			} else if ($_GET['product'] == "16") { //Licencia Microsoft Office + Multimedia
				$precioDolar = 51;
				$nombreProducto = "MetaClean for Microsoft Office + Image, Audio and Video";
			} else if ($_GET['product'] == "17") { //Licencia Outlook
				$precioDolar = 29;
				$nombreProducto = "MetaClean for Outlook";
			}
		}
		$p->add_field('business', 'sales@adarsus.com');
		if ($_GET['lang'] == "es-ES") {
			$p->add_field('return', $this_script . '?action=success&lang=es-ES');
		} else {
			$p->add_field('return', $this_script . '?action=success');
		}
		//Página que le enviamos a paypal para validar el IPN.
		$p->add_field('notify_url', $this_script . '?action=ipn&lang=' . $_GET['lang'] . '&suscripcion=' . $_GET['suscripcion']);

		if (isset($_GET['suscripcion']) && $_GET['suscripcion'] == "1")
			$precioDolar = $precioDolar / 2;

		if (isset($_GET['currency']) && $_GET['currency'] == "USD") {
			$p->add_field('currency_code', 'USD');
			$p->add_field('item_name', $nombreProducto);
			$p->add_field('amount', round($precioDolar * 1.25));
			$p->add_field('cmd', '_xclick');
			$p->add_field('address_country', 'USD');
			$p->add_field('undefined_quantity', '1');
			$p->add_field('lc', 'US');
		} else if (isset($_GET['currency']) && $_GET['currency'] == "GBP") {
			$p->add_field('currency_code', 'GBP');
			$p->add_field('item_name', $nombreProducto);
			$p->add_field('amount', round($precioDolar * 0.95));
			$p->add_field('cmd', '_xclick');
			$p->add_field('address_country', 'GBP');
			$p->add_field('undefined_quantity', '1');
			$p->add_field('lc', 'US');
		} else {
			$p->add_field('currency_code', 'EUR');
			$p->add_field('item_name', $nombreProducto);
			$p->add_field('amount', $precioDolar);
			$p->add_field('cmd', '_xclick');
			$p->add_field('address_country', 'EUR');
			$p->add_field('undefined_quantity', '1');
			//$p->add_field('quantity', '1');
		}
		$p->add_field('display', '0');
		$p->add_field('no_shipping', '1');
		$p->submit_paypal_post(); // submit the fields to paypal
		//$p->dump_fields();      // for debugging, output a table of all the fields
		break;
	case 'success':      // Order was successful...
		$html = "<html>";
		$html .= "<head>";
		$html .= "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />";
		$html .= "<meta property=\"og:title\" content=\"Confirmation of payment MetaClean\" />   ";
		$html .= "<title>Email confirmation of payment MetaClean</title>    	";
		$html .= "<style type=\"text/css\">			#outlook a{padding:0;}			body{width:100% !important;}			body{-webkit-text-size-adjust:none;}			/* Reset styles */			body{margin:0; padding:0;}			#backgroundTable{height:100% !important; margin:0; padding: 20px 0 0; width:100% !important;}			table td{border-collapse:collapse;border-spacing:0;}			tr.spaceTop > td {padding-top: 1em;}			tr.spaceBottom > td {padding-bottom: 3em;}			body, .backgroundTable{ /*@editable*/ background-color:#ffffff; }			.headerContent{ padding-top:15px; padding-right:0; padding-bottom:15px; padding-left:0px; text-align:left; vertical-align:middle; background-color: white; border-bottom: 3px solid #333; }			.headerContent2{ background-color: #FFFFFF; border-bottom: 3px solid #333333;}			.headerContent2 img {height: 50px; position: relative; top: -40px;}			.headerContent h2{ font-family: Arial, Helvetica, sans-serif; padding: 0 0 0 15px; margin: 0; color:black; font-weight:bold; font-size:18px;}			.bodyContent{ color:#505050; background-color:#ffffff; font-family:Arial; font-size:12px; line-height:115%; text-align:left; }			h3 { color: #333; font-family: Arial; font-size: 18px; font-weight: normal; margin: 10px 0; padding: 0; }			h4 { color: #333; font-family: Arial; font-size: 15px; margin: 10px 0; padding: 3px; }			p { font-size: 12px; color: #505050; font-family: Arial; margin: 0 0 10px 0; padding: 0; }			.aviso { padding: 10px; border: 1px solid #dfdfdf; background-color: #f1f8fb; }			.info { font-size: 11px; font-family: Arial, Helvetica, sans-serif; padding: 3px 0; margin: 0; }			.legal { font-size: 10px; font-family: Arial, Helvetica, sans-serif; color: #999999; padding: 10px; margin: 0; }</style>	";
		$html .= "</head>";

		$html .= "<body leftmargin=\"0\" marginwidth=\"0\" topmargin=\"0\" marginheight=\"0\" offset=\"0\">	<center>	";
		$html .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" height=\"100%\" width=\"100%\" id=\"backgroundTable\">    ";
		$html .= "<tr>            	";
		$html .= "<td align=\"center\" valign=\"top\">			";
		$html .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" id=\"templateContainer\">       ";
		$html .= "<tr>                            	";
		$html .= "<td align=\"center\" valign=\"top\">";
		$html .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" id=\"templateHeader\">   ";
		$html .= "<tr>                                            ";
		$html .= "<td class=\"headerContent\" width=\"50\"><img src=\"https://www.adarsus.com/wp-content/uploads/2018/11/adarsus-logo-metaclean.png\" width=\"200\" alt=\"MetaClean\"/></td>";
		$html .= "</tr>                                    ";
		$html .= "</table>                                       ";
		$html .= "</td>                            ";
		$html .= "</tr>                            ";
		$html .= "<tr class=\"spaceTop\">              ";
		$html .= "<td align=\"center\" valign=\"top\"> ";
		$html .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" class=\"bodyContent\">      ";
		$html .= "<tr>                                        	";
		if ($_GET['lang'] == "es-ES")
			$html .= "<td valign=\"top\"><h3>Gracias por su compra.</h3></td>                    ";
		else
			$html .= "<td valign=\"top\"><h3>Thank you for your purchase.</h3></td>                    ";
		$html .= "</tr>                                        ";
		$html .= "<tr>";
		if ($_GET['lang'] == "es-ES")
			$html .= "<td valign=\"top\"><h4>Recibirá un correo electrónico con instrucciones sobre cómo activar su licencia.</h4></td>  ";
		else
			$html .= "<td valign=\"top\"><h4>You'll receive an e-mail containing instructions on how to activate your license</h4></td>  ";
		$html .= "</tr>                               ";
		$html .= "<tr>                                  ";
		$html .= "<td valign=\"top\">&nbsp;</td>        ";
		$html .= "</tr>                                     ";
		$html .= "<tr>                                        ";
		if ($_GET['lang'] == "es-ES")
			$html .= "<td valign=\"top\" class=\"aviso\">Si tiene alguna pregunta o problema, envíe un correo electrónico a: <strong>support@adarsus.com</strong></td>  ";
		else
			$html .= "<td valign=\"top\" class=\"aviso\">If you have any questions or problems please send an email to: <strong>support@adarsus.com</strong></td>  ";
		$html .= "</tr>                                    ";
		$html .= "</table>                                ";
		$html .= "</td>                            ";
		$html .= "</tr>                     ";
		$html .= "</table>                 ";
		$html .= "</td>             ";
		$html .= "</tr>         ";
		$html .= "</table>	";
		$html .= "</center>";
		$html .= "</body>";
		$html .= "</html>";
		echo $html;
		// You could also simply re-direct them to another page, or your own 
		// order status page which presents the user with the status of their
		// order based on a database (which can be modified with the IPN code 
		// below).
		break;
	case 'cancel':       // Order was canceled...
		// The order was canceled before being completed.
		//echo "<html><head><title>Canceled</title></head><body><h3>Orden Cancelada ----  :-(</h3>";
		//echo "</body></html>";
		echo "<html>\n";
		echo "<head><title>Proceso de Pago Cancelado</title>";
		echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";
		echo "<link href=\"paypal.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\"></head>\n";
		echo "<body>\n";
		echo "<div class=\"todo\">";
		echo "<div class=\"ventana\">";
		echo "<div class=\"logo\"></div>";
		echo "<h1>La compra de la licencia ha sido cancelada.</h1>";
		echo "<div class=\"madridgolf\">Adarsus.com<br>MetaClean</div>";
		echo "</div>";
		echo "<div class=\"paypal\">Espere por favor, su petición se está procesando y será direccionado a PayPal sistema de pago seguro por internet. Puede hacer el pago con dinero Paypal o con tarjeta de crédito. Siga detenidamente las instrucciones que se le vayan indicando. En cuanto haya finalizado el proceso de pago recibirá un email de adarsus.com con el código de validación del producto.</div>";
		echo "<div class=\"carga\"><img src=\"../images/carga.gif\"></div>";
		echo "<div class=\"aviso\"><a href=\"javascript:close();\">Cerrar Ventana</a>.</div>";
		echo "</div>";
		echo "</body></html>\n";
		break;
	case 'ipn':          // Paypal is calling page for IPN validation...
		$ipn->useSandbox(); //
		$verified = $ipn->verifyIPN();
		if ($verified) {
			if ($ipn->ipn_data['payment_status'] == 'Completed') {
				try {
					//Guardamos en BBDD.
					$ipn->log_error("Guardo en BBDD");
					// if (isset($_GET['suscripcion']) && $_GET['suscripcion'] == "1")
					// 	$ipn->insert_bbdd("suscripcion");
					// else
					// 	$ipn->insert_bbdd("perpetua");
					// $ipn->log_error("Sin error en BBDD");
				} catch (\Throwable $th) {
					$ipn->log_error($th->getMessage());
				}
				//Enviamos correo.
				$ipn->ipn_data['codigo_activacion'] = "";
				$subject = $ipn->idioma['mailAsunto'];
				if ($ipn->ipn_data['custom'] == "0")
					$subject = $ipn->idioma['mailAsuntoDonacion'];
				$to = $ipn->ipn_data['payer_email'];
				$body = $ipn->creaMail();
				$from = "sales@adarsus.com";
				$headers = "From: " . strip_tags($from) . "\r\n";
				$headers .= "Reply-To: " . strip_tags($from) . "\r\n";
				$headers .= "MIME-Version: 1.0\r\n";
				$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

				mail($to, $subject, $body, $headers);
			} else if ($ipn->ipn_data['payment_status'] == 'Refunded') {
				//Actualiza BBDD con el producto reembolsado
				$subject = $ipn->idioma['mailReembolso'];
				$to = $ipn->ipn_data['payer_email'];
				$body =  $ipn->idioma['mailMensajeReembolso'];
				$from = "sales@adarsus.com";
				$headers = "From:" . $from;
				mail($to, $subject, $body, $headers);
			}
		}
		break;
	case 'entradas':
		echo "<html>\n";
		echo "<head><title>Generando Ticket de Entrada...</title>";
		echo "<link href=\"paypal.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\"></head>\n";
		echo "<body onLoad=\"document.forms['ticket'].submit();\">\n";
		echo "<form method=\"post\" name=\"ticket\" ";
		echo "action=\"" . $p->creaPDF . "\">\n";
		echo "<input type=\"hidden\" name=\"emailTicket\" value=" . $_GET["email"] . ">\n";
		echo "<input type=\"hidden\" name=\"codigoTicket\" value=" . $_GET["codigoTicket"] . ">\n";
		echo "</form>\n";
		echo "<div class=\"todo\">";
		echo "<div class=\"ventana\">";
		echo "<div class=\"logo\"></div>";
		echo "<h1>Generando Ticket de Entrada...</h1>";
		echo "<div class=\"madridgolf\">4ª Feria Madrid Golf<br>23-25 de Octubre 2009<br>IFEMA Madrid</div>";
		echo "</div>";
		echo "<div class=\"paypal\">Espere por favor, su petición se está procesando y será direccionado a PayPal sistema de pago seguro por internet. Puede hacer el pago con dinero Paypal o con tarjeta de crédito. Siga detenidamente las instrucciones que se le vayan indicando. En cuanto haya finalizado el proceso de pago recibirá un email de adarsus.com con el código de validación del producto.</div>";
		echo "<div class=\"carga\"><img src=\"../images/carga.gif\"></div>";
		echo "<div class=\"aviso\">Si en 5 segundos no le ha redireccionado automáticamente a PayPal <a href=\"javascript:document.forms['ticket'].submit();\">pinche aquí</a>.</div>";
		echo "</div>";
		echo "</body></html>\n";
		break;
	case 'validaEnvioMail':
		$subject = $p->idioma['mailAsunto'];
		if ($p->ipn_data['custom'] == "0")
			$subject = $p->idioma['mailAsuntoDonacion'];
		$to = "sales@adarsus.com";
		$body = $p->testCreaMail();
		$from = "sales@adarsus.com";
		$headers = "From: " . strip_tags($from) . "\r\n";
		$headers .= "Reply-To: " . strip_tags($from) . "\r\n";
		$headers .= "MIME-Version: 1.0\r\n";
		$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
		mail($to, $subject, $body, $headers);
		break;
}
