﻿<?php

/*******************************************************************************

 *                      PHP Paypal IPN Integration Class

 *******************************************************************************

 *      Author:     Micah Carrick

 *      Email:      email@micahcarrick.com

 *      Website:    http://www.micahcarrick.com

 *

 *      File:       paypal.class.php

 *      Version:    1.3.0

 *      Copyright:  (c) 2005 - Micah Carrick 

 *                  You are free to use, distribute, and modify this software 

 *                  under the terms of the GNU General Public License.  See the

 *                  included license.txt file.

 *      

 *******************************************************************************

 *  VERION HISTORY:

 *      v1.3.0 [10.10.2005] - Fixed it so that single quotes are handled the 

 *                            right way rather than simple stripping them.  This

 *                            was needed because the user could still put in

 *                            quotes.

 *  

 *      v1.2.1 [06.05.2005] - Fixed typo from previous fix :)

 *

 *      v1.2.0 [05.31.2005] - Added the optional ability to remove all quotes

 *                            from the paypal posts.  The IPN will come back

 *                            invalid sometimes when quotes are used in certian

 *                            fields.

 *

 *      v1.1.0 [05.15.2005] - Revised the form output in the submit_paypal_post

 *                            method to allow non-javascript capable browsers

 *                            to provide a means of manual form submission.

 *

 *      v1.0.0 [04.16.2005] - Initial Version

 *

 *******************************************************************************

 *  DESCRIPTION:

 *

 *      NOTE: See www.micahcarrick.com for the most recent version of this class

 *            along with any applicable sample files and other documentaion.

 *

 *      This file provides a neat and simple method to interface with paypal and

 *      The paypal Instant Payment Notification (IPN) interface.  This file is

 *      NOT intended to make the paypal integration "plug 'n' play". It still

 *      requires the developer (that should be you) to understand the paypal

 *      process and know the variables you want/need to pass to paypal to

 *      achieve what you want.  

 *

 *      This class handles the submission of an order to paypal aswell as the

 *      processing an Instant Payment Notification.

 *  

 *      This code is based on that of the php-toolkit from paypal.  I've taken

 *      the basic principals and put it in to a class so that it is a little

 *      easier--at least for me--to use.  The php-toolkit can be downloaded from

 *      http://sourceforge.net/projects/paypal.

 *      

 *      To submit an order to paypal, have your order form POST to a file with:

 *

 *          $p = new paypal_class;

 *          $p->add_field('business', 'somebody@domain.com');

 *          $p->add_field('first_name', $_POST['first_name']);

 *          ... (add all your fields in the same manor)

 *          $p->submit_paypal_post();

 *

 *      To process an IPN, have your IPN processing file contain:

 *

 *          $p = new paypal_class;

 *          if ($p->validate_ipn()) {

 *          ... (IPN is verified.  Details are in the ipn_data() array)

 *          }

 *

 *

 *      In case you are new to paypal, here is some information to help you:

 *

 *      1. Download and read the Merchant User Manual and Integration Guide from

 *         http://www.paypal.com/en_US/pdf/integration_guide.pdf.  This gives 

 *         you all the information you need including the fields you can pass to

 *         paypal (using add_field() with this class) aswell as all the fields

 *         that are returned in an IPN post (stored in the ipn_data() array in

 *         this class).  It also diagrams the entire transaction process.

 *

 *      2. Create a "sandbox" account for a buyer and a seller.  This is just

 *         a test account(s) that allow you to test your site from both the 

 *         seller and buyer perspective.  The instructions for this is available

 *         at https://developer.paypal.com/ as well as a great forum where you

 *         can ask all your paypal integration questions.  Make sure you follow

 *         all the directions in setting up a sandbox test environment, including

 *         the addition of fake bank accounts and credit cards.

 * 

 *******************************************************************************

 */
class paypal_class
{
	var $last_error;                 // holds the last error encountered
	var $ipn_log;                    // bool: log IPN results to text file?
	var $ipn_log_file;               // filename of the IPN log
	var $ipn_response;               // holds the IPN response from paypal   
	var $ipn_data = array();         // array contains the POST values for IPN
	var $idioma = array();
	var $fields = array();           // array holds the fields to submit to paypal

	function paypal_class()
	{
		// initialization constructor.  Called when class is created.
		//$this->paypal_url = 'https://www.paypal.com/cgi-bin/webscr';
		$this->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
		//$this->creaPDF = '../barcode/ticketPDF.php';
		$settings = parse_ini_file('../../../../home/s149bf90/databaseaccess/mysqlConnection.ini');
		if (!empty($_GET['lang']) && $_GET['lang'] == "es-ES")
			$this->idioma = parse_ini_file('../../../../../../home/s149bf90/databaseaccess/es-ES.ini');
		else
			$this->idioma = parse_ini_file('../../../../../../home/s149bf90/databaseaccess/en-GB.ini');
		$this->add_field('cmd', '_s-xclick');
	}

	function add_field($field, $value)
	{
		$this->fields["$field"] = $value;
	}

	function submit_paypal_post()
	{
		// this function actually generates an entire HTML page consisting of
		// a form with hidden elements which is submitted to paypal via the 
		// BODY element's onLoad attribute.  We do this so that you can validate
		// any POST vars from you custom form before submitting to paypal.  So 
		// basically, you'll have your own form which is submitted to your script
		// to validate the data, which in turn calls this function to create
		// another hidden form and submit to paypal.
		// The user will briefly see a message on the screen that reads:
		// "Please wait, your order is being processed..." and then immediately
		// is redirected to paypal.
		echo "<!DOCTYPE html>\n";
		echo "<html><head><title>" . $this->idioma['tituloInicial'] . "</title>";
		echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";
		echo "<link href=\"paypal.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\">";
		echo "</head>\n";
		echo "<body onLoad=\"document.forms['paypal_form'].submit();this.window.focus();\">\n";
		echo "<?php include_once(\"analyticstracking.php\") ?>";
		echo "<form method=\"post\" name=\"paypal_form\" ";
		echo "action=\"" . $this->paypal_url . "\">\n";
		foreach ($this->fields as $name => $value) {
			echo "<input type=\"hidden\" name=\"$name\" value=\"$value\"/>\n";
		}
		echo "</form>\n";
		echo "<div class=\"todo\">";
		echo "<div class=\"textoPayPal\">";
		echo "<div class=\"paypal\">";
		echo "<div class=\"avisoPayPal\">" . $this->idioma['piePaginaPayPal'] . "</div>";
		echo "</div>";
		echo "<div class=\"border-horiz\"></div>";
		echo "<div class=\"carga\"><img src=\"../images/carga.gif\"></div>";
		echo "<div class=\"aviso\">" . $this->idioma['redireccionPaypal'] . " <a href=\"javascript:document.forms['paypal_form'].submit();\">" . $this->idioma['hazClickAqui'] . "</a>.</div>";
		echo "</div>";
		echo "</div>";
		echo "</body></html>\n";
	}

	function write_log($log)
	{
		if (is_array($log) || is_object($log)) {
			error_log(
				print_r($log, true)
			);
		} else {
			error_log(
				$log
			);
		}
	}
}
