function comprarSoftFinal() {

    var data = jQuery('#product').select2('data');

    var productos = ' ';

    jQuery.each(data, function (index, value) {
        productos = productos + value.text;
    });

    var moneda = '';
    switch (jQuery('#moneda').val()) {
        case "1":
            moneda = "EUR";
            break;
        case "2":
            moneda = "USD";
            break;
        case "3":
            moneda = "GBP";
            break;
        default:
            moneda = "EUR";
    }

    var suscripcion = 1;
    if (jQuery("input[name='suscripcion']").first()[0].checked)
        suscripcion = 1;
    else
        suscripcion = 2;


    if (productos.indexOf("Microsoft Office") < 0 && productos.indexOf("OpenOffice") > 0 && productos.indexOf("PDF") < 0 && (productos.indexOf("Imágenes") > 0 || productos.indexOf("Image") > 0))
        idProductos = 9;
    else if (productos.indexOf("Microsoft Office") < 0 && productos.indexOf("OpenOffice") < 0 && productos.indexOf("PDF") > 0 && (productos.indexOf("Imágenes") > 0 || productos.indexOf("Image") > 0))
        idProductos = 10;
    else if (productos.indexOf("Microsoft Office") < 0 && productos.indexOf("OpenOffice") < 0 && productos.indexOf("PDF") < 0 && (productos.indexOf("Imágenes") > 0 || productos.indexOf("Image") > 0))
        idProductos = 11; //Multimedia
    else if (productos.indexOf("Microsoft Office") > 0 && productos.indexOf("OpenOffice") > 0 && productos.indexOf("PDF") > 0 && (productos.indexOf("Imágenes") > 0 || productos.indexOf("Image") > 0))
        idProductos = 12; //Licencia FULL
    else if (productos.indexOf("Microsoft Office") > 0 && productos.indexOf("OpenOffice") > 0 && productos.indexOf("PDF") < 0 && (productos.indexOf("Imágenes") > 0 || productos.indexOf("Image") > 0))
        idProductos = 13;
    else if (productos.indexOf("Microsoft Office") > 0 && productos.indexOf("OpenOffice") < 0 && productos.indexOf("PDF") > 0 && (productos.indexOf("Imágenes") > 0 || productos.indexOf("Image") > 0))
        idProductos = 14;
    else if (productos.indexOf("Microsoft Office") < 0 && productos.indexOf("OpenOffice") > 0 && productos.indexOf("PDF") > 0 && (productos.indexOf("Imágenes") > 0 || productos.indexOf("Image") > 0))
        idProductos = 15;
    else if (productos.indexOf("Microsoft Office") > 0 && productos.indexOf("OpenOffice") < 0 && productos.indexOf("PDF") < 0 && (productos.indexOf("Imágenes") > 0 || productos.indexOf("Image") > 0))
        idProductos = 16;
    else if (productos.indexOf("Microsoft Office") > 0 && productos.indexOf("OpenOffice") > 0 && productos.indexOf("PDF") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 1; //Licencia Microsoft Office + Open Office + PDF
    else if (productos.indexOf("Microsoft Office") > 0 && productos.indexOf("OpenOffice") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 2; //Licencia Microsoft Office + Open Office
    else if (productos.indexOf("Microsoft Office") > 0 && productos.indexOf("PDF") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 3;  //Licencia Microsoft Office + PDF
    else if (productos.indexOf("OpenOffice") > 0 && productos.indexOf("PDF") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 4; //Licencia Open Office + PDF
    else if (productos.indexOf("Microsoft Office") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 5; //Licencia Microsoft Office
    else if (productos.indexOf("OpenOffice") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 6; //Licencia Open Office
    else if (productos.indexOf("PDF") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 7; //Licencia PDF
    else if (productos.indexOf("Home Standard Edition") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 8;
    else if (productos.indexOf("MetaClean For Outlook") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 17;
    else if (productos.indexOf("MetaClean Websites") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 18;
    else if (productos.indexOf("MetaClean For Websites") != -1 || productos.indexOf("MetaClean para Portales Web") != -1)
        idProductos = 19;
    else if (productos.indexOf("Home Extended Edition") > 0 && (productos.indexOf("Imágenes") < 0 || productos.indexOf("Image") < 0))
        idProductos = 20;
    else {
        alert("Error");
        return;
    }
    var windowFeatures = "height=630,width=950,toolbar=0,scrollbars=1,status=0,resizable=1,location=0,menuBar=0";
    var centeredY = (screen.height - 630) / 2;
    var centeredX = (screen.width - 950) / 2;
    var popup = window.open('https://www.adarsus.com/wp-content/themes/adarsus-t/payPal/test/paypal_test.php?product=' + idProductos + '&lang=' + document.documentElement.lang + '&currency=' + moneda + '&suscripcion=' + suscripcion, 'PayPal', windowFeatures + ',left=' + centeredX + ',top=' + centeredY);
    setTimeout(function () {
        if (!popup || popup.outerHeight === 0) {
            if (document.documentElement.lang == "es-ES")
                alert("Está activado el bloqueador de ventanas PopUp! por favor permita las ventanas emergentes para esta aplicación.");
            else
                alert("Popup Blocker is enabled! Please add this site to your exception list.");
        } else {
            popup.focus();
        }
    }, 250);
}

jQuery(document).ready(function ($) {

    setTimeout(init, 1000);

    function runSelect2() {
        var $eventSelectProduct = $('#product').select2({
            //dropdownParent: $('#modal-paypal'),
            allowClear: false,
            placeholder: document.documentElement.lang == "es-ES" ? "Seleccionar producto" : "Select product",
            dropdownAutoWidth: true,
            width: '100%'
        });

        $eventSelectProduct.on("select2:select", function (e) {
            calculatePrice();
        });

        $eventSelectProduct.on("select2:unselect", function (e) {
            calculatePrice();
        });

        $eventSelectProduct.on("select2:open", function (e) {
            setTimeout(function () {
                $(".select2-results__option .select2-results__group").bind("click", selectAlllickHandler);
            }, 0);

            setTimeout(function () {
                $(".select2-results__option .select2-results__group").bind("mouseover", tooltipMouseOverHandler);
            }, 0);
            calculatePrice();
        });

        var tooltipMouseOverHandler = function () {
            $(".select2-results__group").tooltip({
                title: function () {
                    if (document.documentElement.lang == "es-ES")
                        return "Esta seleccione incluye: Microsoft Office, PDF, OpenOffice, Multimedia.";
                    else
                        return "This selection includes: Microsoft Office, PDF, OpenOffice, Multimedia."
                },
                placement: "auto"
            });
            $(".select2-results__group").tooltip('show');
        };

        var selectAlllickHandler = function () {
            $(".select2-results__option .select2-results__group").unbind("click", selectAlllickHandler);
            $(".select2-results__option .select2-results__group").unbind("mouseover", selectAlllickHandler);
            $('#product').select2('destroy').find('option').prop('selected', 'selected').end();
            calculatePrice();
            $(".tooltip").tooltip('hide');
            runSelect2();
        };
    }

    function checkAssignment() {
        //Compruebo la platarforma
        if ($('#platform').val() == null)
            $('#platform').val(1).trigger('change');
        //Compruebo la moneda
        if ($('#moneda').val() == null)
            $('#moneda').val(1).trigger('change');
        //Compruebo la suscripción
        if ($("input[name='suscripcion']:checked").length == 0)
            $("input[name='suscripcion']").first()[0].checked = true;

    }


    function calculatePrice() {
        checkAssignment();
        var price = 0;
        if ($('#product').val() != null) {
            // Full Version
            if ($('#product').val().length == 4) {
                if ($("input[name='suscripcion']").first()[0].checked)
                    price = 28.5;
                else
                    price = 57;
            } else {
                var products = $('#product').val();
                $.each($('#product').val(), function (index, value) {
                    if (value == 1) { //Licencia Microsoft Office
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price += 10;
                        else
                            price += 20;
                    }
                    if (value == 2) { //Licencia Open Office
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price += 8;
                        else
                            price += 16;
                    }
                    if (value == 3) { //Licencia PDF
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price += 10;
                        else
                            price += 20;
                    }
                    if (value == 4) { //Licencia Multimedia
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price += 15.5;
                        else
                            price += 31;
                    }
                    if (value == 5) { //Licencia Microsoft Office
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price += 14.5;
                        else
                            price += 29;
                    }
                });
                //Si son los productos Licencia Microsoft Office + Open Office + PDF el precio es de 55€
                if ($('#product').val().length == 3) {
                    if ($.inArray("1", products) >= 0 && $.inArray("2", products) >= 0 && $.inArray("3", products) >= 0) {
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price = 27.5;
                        else
                            price = 55;
                    }
                }

                //Licencia Microsoft Office + Open Office + Multimedia 55€
                if ($('#product').val().length == 3) {
                    if ($.inArray("1", products) >= 0 && $.inArray("2", products) >= 0 && $.inArray("4", products) >= 0) {
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price = 27.5;
                        else
                            price = 55;
                    }
                }

                //MetaClean for Open Office + PDF + Image, Audio and Video
                if ($('#product').val().length == 3) {
                    if ($.inArray("2", products) >= 0 && $.inArray("3", products) >= 0 && $.inArray("4", products) >= 0) {
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price = 26.5;
                        else
                            price = 53;
                    }
                }

                //Licencia Microsoft Office + PDF + Multimedia
                if ($('#product').val().length == 3) {
                    if ($.inArray("1", products) >= 0 && $.inArray("3", products) >= 0 && $.inArray("4", products) >= 0) {
                        if ($("input[name='suscripcion']").first()[0].checked)
                            price = 27.5;
                        else
                            price = 55;
                    }
                }
            }
        }

        if (price > 0) {

            var currency = '';
            switch ($('#moneda').val()) {
                case "1":
                    currency = '€';
                    break;
                case "2":
                    currency = '$';
                    price = price * 1.25;
                    price = Math.round(price);
                    break;
                case "3":
                    currency = '£';
                    price = price * 0.95;
                    price = Math.round(price);
                    break;
                default:
                    currency = '€';
            }
            var newText = '';
            //Texto a mostrar.
            if (document.documentElement.lang == "es-ES")
                newText = 'Precio Total (impuestos incluidos): {money} {currency}';
            else
                newText = 'License Price (taxes included): {money} {currency}';
            //Remplazo variables.
            newText = newText.replace('{money}', price)
            newText = newText.replace('{currency}', currency);
            //Asignamos el texto
            $('.total-price').text(newText);
            //Mostramos el label.
            $('.total-price').show();
            enablePurchase();
        } else {
            enablePurchase();
            $('.total-price').hide();
        }
    }

    function enablePurchase() {
        if ($("#product").val() == null ||
            $("input[name='suscripcion']:checked").length == 0 ||
            $("#platform").val() == null ||
            $("#moneda").val() == null)
            $('#btnBuy').attr('disabled', 'disabled');
        else
            $('#btnBuy').removeAttr('disabled');

    }

    function init() {
        $('[data-toggle="tooltip"]').tooltip();
        var modal = $('#modal-paypal');

        $('.total-price').hide();

        $('#modal-paypal').appendTo('.entry-content');

        runSelect2();

        calculatePrice();

        $("input[name='suscripcion']").change(function (e) {
            calculatePrice();
        });

        var $eventSelectPlatform = $('#platform').select2({
            allowClear: false,
            placeholder: document.documentElement.lang == "es-ES" ? "Seleccionar plataforma" : "Select platform",
            dropdownAutoWidth: true,
            width: '100%',
            minimumResultsForSearch: Infinity
        });

        var $eventSelectMoneda = $('#moneda').select2({
            allowClear: false,
            placeholder: document.documentElement.lang == "es-ES" ? "Seleccionar plataforma" : "Select currency",
            dropdownAutoWidth: true,
            width: '100%',
            minimumResultsForSearch: Infinity
        });

        $eventSelectMoneda.on("select2:select", function (e) {
            calculatePrice();
        });

    }
});