<?php

require('PaypalIPN.php');

use PaypalIPN;

$ipn = new PaypalIPN();

// Use the sandbox endpoint during testing.
$ipn->useSandbox();
$verified = $ipn->verifyIPN();

if ($verified) {
    if ($ipn->ipn_data['payment_status'] == 'Completed') {
        
        try {
            //Guardamos en BBDD.
            $ipn->log_error("Guardo en BBDD");
            $ipn->insert_bbdd();
            $ipn->log_error("Sin error en BBDD");
            //code...
        } catch (\Throwable $th) {
            $ipn->log_error($th->getMessage());
            //throw $th;
        }

        $ipn->ipn_data['codigo_activacion'] = "";
        $subject = $ipn->idioma['mailAsunto'];
        if ($ipn->ipn_data['custom'] == "0")
            $subject = $ipn->idioma['mailAsuntoDonacion'];
        $to = $ipn->ipn_data['payer_email'];
        $body = $ipn->creaMail();
        $from = "sales@adarsus.com";
        $headers = "From: " . strip_tags($from) . "\r\n";
        $headers .= "Reply-To: " . strip_tags($from) . "\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

        mail($to, $subject, $body, $headers);
    } else if ($ipn->ipn_data['payment_status'] == 'Refunded') {
        //Actualiza BBDD con el producto reembolsado
        $subject = $ipn->idioma['mailReembolso'];
        $to = $ipn->ipn_data['payer_email'];
        $body =  $ipn->idioma['mailMensajeReembolso'];
        $from = "sales@adarsus.com";
        $headers = "From:" . $from;
        mail($to, $subject, $body, $headers);
    }
}

// Reply with an empty 200 response to indicate to paypal the IPN was received correctly.
//header("HTTP/1.1 200 OK");
