<?php

class PaypalIPN
{
    /** @var bool Indicates if the sandbox endpoint is used. */
    private $use_sandbox = false;
    /** @var bool Indicates if the local certificates are used. */
    private $use_local_certs = false;

    /** Production Postback URL */
    const VERIFY_URI = 'https://ipnpb.paypal.com/cgi-bin/webscr';
    /** Sandbox Postback URL */
    const SANDBOX_VERIFY_URI = 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr';

    /** Response from PayPal indicating validation was successful */
    const VALID = 'VERIFIED';
    /** Response from PayPal indicating validation failed */
    const INVALID = 'INVALID';

    var $ipn_data = array();         // array contains the POST values for IPN
    var $ipn_log_file;               // filename of the IPN log
    var $idioma = array();

    //Builder
    function PaypalIPN()
    {
        if (!empty($_GET['lang']) && $_GET['lang'] == "es-ES")
            $this->idioma = parse_ini_file('../../../../../../home/s149bf90/databaseaccess/es-ES.ini');
        else
            $this->idioma = parse_ini_file('../../../../../../home/s149bf90/databaseaccess/en-GB.ini');

        //settings para guardar en bbdd.
        $settings = parse_ini_file('../../../../../../home/s149bf90/databaseaccess/mysqlConnection.ini');
        $this->username = $settings['username'];
        $this->password = $settings['password'];
        $this->database = $settings['database'];
        $this->hostname = $settings['hostname'];
        $this->cipher = $settings['cipher'];
        $this->mode = $settings['mode'];
        $this->secret_key = $settings['secret_key'];
        $this->iv = $settings['iv'];

        $this->ipn_log_file = 'ipn_results.log';
    }

    /**
     * Sets the IPN verification to sandbox mode (for use when testing,
     * should not be enabled in production).
     * @return void
     */
    public function useSandbox()
    {
        $this->use_sandbox = true;
    }

    /**
     * Sets curl to use php curl's built in certs (may be required in some
     * environments).
     * @return void
     */
    public function usePHPCerts()
    {
        $this->use_local_certs = false;
    }

    /**
     * Determine endpoint to post the verification data to.
     *
     * @return string
     */
    public function getPaypalUri()
    {
        if ($this->use_sandbox) {
            return self::SANDBOX_VERIFY_URI;
        } else {
            return self::VERIFY_URI;
        }
    }

    /**
     * Verification Function
     * Sends the incoming post data back to PayPal using the cURL library.
     *
     * @return bool
     * @throws Exception
     */
    public function verifyIPN()
    {
        if (!count($_POST)) {
            throw new Exception("Missing POST Data");
        }

        foreach ($_POST as $field => $value) {
            $this->ipn_data["$field"] = $value;
        }

        $raw_post_data = file_get_contents('php://input');
        $raw_post_array = explode('&', $raw_post_data);
        $myPost = array();
        foreach ($raw_post_array as $keyval) {
            $keyval = explode('=', $keyval);
            if (count($keyval) == 2) {
                // Since we do not want the plus in the datetime string to be encoded to a space, we manually encode it.
                if ($keyval[0] === 'payment_date') {
                    if (substr_count($keyval[1], '+') === 1) {
                        $keyval[1] = str_replace('+', '%2B', $keyval[1]);
                    }
                }
                $myPost[$keyval[0]] = urldecode($keyval[1]);
            }
        }

        // Build the body of the verification post request, adding the _notify-validate command.
        $req = 'cmd=_notify-validate';
        $get_magic_quotes_exists = false;
        if (function_exists('get_magic_quotes_gpc')) {
            $get_magic_quotes_exists = true;
        }
        foreach ($myPost as $key => $value) {
            if ($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
                $value = urlencode(stripslashes($value));
            } else {
                $value = urlencode($value);
            }
            $req .= "&$key=$value";
        }

        // Post the data back to PayPal, using curl. Throw exceptions if errors occur.
        $ch = curl_init($this->getPaypalUri());
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
        curl_setopt($ch, CURLOPT_SSLVERSION, 6);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

        // This is often required if the server is missing a global cert bundle, or is using an outdated one.
        if ($this->use_local_certs) {
            curl_setopt($ch, CURLOPT_CAINFO, __DIR__ . "/cert/cacert.pem");
        }
        curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'User-Agent: PHP-IPN-Verification-Script',
            'Connection: Close',
        ));
        $res = curl_exec($ch);
        if (!($res)) {
            $errno = curl_errno($ch);
            $errstr = curl_error($ch);
            curl_close($ch);
            throw new Exception("cURL error: [$errno] $errstr");
        }

        $info = curl_getinfo($ch);
        $http_code = $info['http_code'];
        if ($http_code != 200) {
            throw new Exception("PayPal responded with http code $http_code");
        }

        curl_close($ch);

        // Check if PayPal verifies the IPN data, and if so, return true.
        if ($res == self::VALID) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Create email Function
     * Crea el cuerpo del correo que se le enviará a los usuarios que comprarón una licencia..
     *
     * @return bool
     * @throws Exception
     */
    function creaMail()
    {
        $tipoLicencia = $this->ipn_data["custom"];
        $producto = $this->ipn_data['item_name'];
        $idLicenciaComprada = "";
        $idTransaccion = $this->ipn_data["txn_id"];
        $enviarInstruccionesDescarga = true;
        if ($tipoLicencia == "0") { //Donacion
            $idLicenciaComprada = "donate";
            $idTransaccion = "0";
            $enviarInstruccionesDescarga = false;
        } else if ($tipoLicencia == "1") { //Licencia Microsoft Office + Open Office + PDF
            $idLicenciaComprada = "CMZ";
        } else if ($tipoLicencia == "2") { //Licencia Microsoft Office + Open Office
            $idLicenciaComprada = "ER6";
        } else if ($tipoLicencia == "3") { //Licencia Microsoft Office + PDF
            $idLicenciaComprada = "EEY";
        } else if ($tipoLicencia == "4") { //Licencia Open Office + PDF
            $idLicenciaComprada = "36R";
        } else if ($tipoLicencia == "5") { //Licencia Microsoft Office
            $idLicenciaComprada = "7SC";
        } else if ($tipoLicencia == "6") { //Licencia Open Office
            $idLicenciaComprada = "PKK";
        } else if ($tipoLicencia == "7") { //Licencia PDF
            $idLicenciaComprada = "S3D";
        } else if ($tipoLicencia == "8") { //Licencia Command Line Home Standard Edition
            $idLicenciaComprada = "S8Z";
            $enviarInstruccionesDescarga = false;
        } else if ($tipoLicencia == "9") { //Licencia OpenOffice + Multimedia
            $idLicenciaComprada = "AB1";
        } else if ($tipoLicencia == "10") { //Licencia PDF + Multimedia
            $idLicenciaComprada = "AB2";
        } else if ($tipoLicencia == "11") { //Licencia Multimedia
            $idLicenciaComprada = "AB3";
        } else if ($tipoLicencia == "12") { //Licencia FULL
            $idLicenciaComprada = "AB4";
        } else if ($tipoLicencia == "13") { //Licencia Microsoft Office + Open Office + Multimedia
            $idLicenciaComprada = "AB5";
        } else if ($tipoLicencia == "14") { //Licencia Microsoft Office + PDF + Multimedia
            $idLicenciaComprada = "AB6";
        } else if ($tipoLicencia == "15") { //Licencia OpenOffice + PDF + Multimedia
            $idLicenciaComprada = "AB7";
        } else if ($tipoLicencia == "16") { //Licencia Microsoft Office + Multimedia
            $idLicenciaComprada = "AB8";
        } else if ($tipoLicencia == "17") { //Licencia Outlook
            $idLicenciaComprada = "OUT";
            $enviarInstruccionesDescarga = false;
        } else if ($tipoLicencia == "18") { //Licencia OneClick
            $idLicenciaComprada = "ONE";
            $enviarInstruccionesDescarga = false;
        } else if ($tipoLicencia == "19") { //Licencia Web Server
            $idLicenciaComprada = "WEB";
            $enviarInstruccionesDescarga = false;
        } else if ($tipoLicencia == "20") { //Licencia MetaClean Command Line Home Extended Edition
            $idLicenciaComprada = "CHE";
            $enviarInstruccionesDescarga = false;
        }

        $argumentos = "id=" . $idTransaccion . "&pid=" . $idLicenciaComprada;
        $currency = "";

        if ($this->ipn_data["mc_currency"] == "USD")
            $currency = "$";
        if ($this->ipn_data["mc_currency"] == "GBP")
            $currency = "£";
        if ($this->ipn_data["mc_currency"] == "EUR")
            $currency = "€";

        $html = "<html>";

        $html .= "    <head>";
        $html .= "    	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />";
        $html .= "        <meta property=\"og:title\" content=\"" . $this->idioma['mail1'] . "\" />";
        $html .= "        <title>" . $this->idioma['mailTitulo'] . "</title>";
        $html .= "    	<style type=\"text/css\">";
        $html .= "			#outlook a{padding:0;}";
        $html .= "			body{width:100% !important;}";
        $html .= "			body{-webkit-text-size-adjust:none;}";
        $html .= "			/* Reset styles */";
        $html .= "			body{margin:0; padding:0;}";
        $html .= "			#backgroundTable{height:100% !important; margin:0; padding: 20px 0 0; width:100% !important;}";
        $html .= "			table td{border-collapse:collapse;border-spacing:0;}";
        $html .= "			tr.spaceTop > td {padding-top: 1em;}";
        $html .= "			tr.spaceBottom > td {padding-bottom: 3em;}";
        $html .= "			body, .backgroundTable{ /*@editable*/ background-color:#ffffff; }";
        $html .= "			.headerContent{ padding-top:15px; padding-right:0; padding-bottom:15px; padding-left:0px; text-align:left; vertical-align:middle; background-color: white; border-bottom: 3px solid #333; }";
        $html .= "			.headerContent2{ background-color: #FFFFFF; border-bottom: 3px solid #333333;}";
        $html .= "			.headerContent2 img {height: 50px; position: relative; top: -40px;}";
        $html .= "			.headerContent h2{ font-family: Arial, Helvetica, sans-serif; padding: 0 0 0 15px; margin: 0; color:black; font-weight:bold; font-size:18px;}";
        $html .= "			.bodyContent{ color:#505050; background-color:#ffffff; font-family:Arial; font-size:12px; line-height:115%; text-align:left; }";
        $html .= "			h3 { color: #333; font-family: Arial; font-size: 18px; font-weight: normal; margin: 10px 0; padding: 0; }";
        $html .= "			h4 { color: #333; font-family: Arial; font-size: 14px; background-color: #f3f5f7; margin: 10px 0; padding: 3px; }";
        $html .= "			p { font-size: 12px; color: #505050; font-family: Arial; margin: 0 0 10px 0; padding: 0; }";
        $html .= "			.aviso { padding: 10px; border: 1px solid #dfdfdf; background-color: #f1f8fb; }";
        $html .= "			.info { font-size: 11px; font-family: Arial, Helvetica, sans-serif; padding: 3px 0; margin: 0; }";
        $html .= "			.text { font-size: 12px; color: #505050; font-family: Arial; margin: 0 0 10px 0; padding: 0; }";
        $html .= "			.legal { font-size: 10px; font-family: Arial, Helvetica, sans-serif; color: #999999; padding: 10px; margin: 0; }";
        $html .= "		</style>";
        $html .= "	</head>";
        $html .= "";

        $html .= "<body leftmargin=\"0\" marginwidth=\"0\" topmargin=\"0\" marginheight=\"0\" offset=\"0\">";
        $html .= "	<center>";
        $html .= "		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" height=\"100%\" width=\"100%\" id=\"backgroundTable\">";
        $html .= "        	<tr>";
        $html .= "            	<td align=\"center\" valign=\"top\">";
        $html .= "			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" id=\"templateContainer\">";
        $html .= "                    	<tr class=\"spaceBottom\">";
        if ($this->idioma['extensionImagenes'] == "esp")
            $html .= "                        	<td class=\"info\" align=\"center\">" . $this->idioma['mail2'] . "<a href=\"https://www.adarsus.com/bat/confirmacion.php?" . $argumentos . "\" target=\"_blank\">" . $this->idioma['hazClickAqui'] . "</a></td>";
        else
            $html .= "                        	<td class=\"info\" align=\"center\">" . $this->idioma['mail2'] . "<a href=\"https://www.adarsus.com/bat/confirmation.php?" . $argumentos . "\" target=\"_blank\">" . $this->idioma['hazClickAqui'] . "</a></td>";
        $html .= "                        </tr>";
        $html .= "                        <tr>";
        $html .= "                            	<td align=\"center\" valign=\"top\">";
        $html .= "                                    <!-- // Begin Template Header \\ -->";
        $html .= "                                	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" id=\"templateHeader\">";
        $html .= "                                        <tr>";
        $html .= "                                            <td class=\"headerContent\" width=\"50\">";

        $html .=                                                "<div>";
        $html .=                                                    "<p style=\"margin-top:0\"><img src=\"https://www.adarsus.com/wp-content/uploads/2019/02/adarsus-logo.png\" alt=\"Adarsus\" style=\"border:none;display:inline-block;font-size:14px;font-weight:bold;height:auto;outline:none;text-decoration:none;text-transform:capitalize;vertical-align:middle;margin-left:0;margin-right:0\" class\"CToWUd\"></p>";
        $html .=                                                "</div>";


        $html .= "<div>";
        $html .=   "<h4>" . $this->idioma['mailCodValidacion'] . "</h4>";
        $html .=  "</div>";

        $html .= "<div>";
        $html .=   "<span>" . $this->idioma['mailLeerInstrucciones'] . "</span>";
        $html .=  "</div>";

        if ($this->idioma['extensionImagenes'] == "esp"){
            $html .= "<div>";
            $html .=   "<p><a href=\"https://www.adarsus.com/downloads/instructions.pdf\">instrucciones</a></p>";
            $html .=  "</div>";
        }
        else{
            $html .= "<div>";
            $html .=   "<p><a href=\"https://www.adarsus.com/downloads/instructions.pdf\">instructions</a></p>";
            $html .=  "</div>";
        }

        $html .= "<div>";
        $html .=   "<span>" . $this->idioma['mailURL'] . "</span>";
        $html .=  "</div>";

        if ($this->idioma['extensionImagenes'] == "esp"){
            $html .= "<div>";
            $html .=   "<p><a href=\"https://www.adarsus.com/bat/redirection.php?" . $argumentos . "&lang=es-ES\" target=\"_blank\">" . $this->idioma['hazClickAqui'] . "</a></p>";
            $html .=  "</div>";
        }
        else{
            $html .= "<div>";
            $html .=   "<p><a href=\"https://www.adarsus.com/bat/redirection.php?" . $argumentos . "\" target=\"_blank\">" . $this->idioma['hazClickAqui'] . "</a></p>";
            $html .=  "</div>";
        }

        if ($enviarInstruccionesDescarga)
        {
            //Descarga del manual de usuario.
            $html .= "<div>";
            $html .=   "<span>" . $this->idioma['mailManualUsuario'] . "</span>";
            $html .=  "</div>";

            if ($this->idioma['extensionImagenes'] == "esp"){
                $html .= "<div>";
                $html .=   "<p><a href=\"https://www.adarsus.com/downloads/MetaClean_Control_User_Manual.pdf\">" . $this->idioma['hazClickAqui'] . "</a></p>";
                $html .=  "</div>";
            }
            else{
                $html .= "<div>";
                $html .=   "<p><a href=\"https://www.adarsus.com/downloads/MetaClean_Control_User_Manual.pdf\">". $this->idioma['hazClickAqui'] . "</a></p>";
                $html .=  "</div>";
            }
        }


        $html .=                                                    "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"background-color:#578e9f;color:#ffffff;border-bottom:0;font-weight:bold;line-height:100%;vertical-align:middle;font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif;border-radius:3px 3px 0 0\">";
        $html .=                                                        "<tbody>";
        $html .=                                                            "<tr>";
        $html .=                                                                "<td style=\"padding:36px 48px;display:block;text-align: center;\">";
        if (strlen($producto) > 0)
            $html .=                                                                "<h1>" . $this->idioma['mailCompraConfirmada'] . "</h1>";
        else
            $html .=                                                                 "<h1>" . $this->idioma['mailCodError'] . "</h1>";
        $html .=                                                                "</td>";
        $html .=                                                            "</tr>";
        $html .=                                                        "</tbody>";
        $html .=                                                     "</table>";
        $html .= "                                            </td>";
        $html .= "                                        </tr>";
        $html .= "                                    </table>";
        $html .= "                                    <!-- // End Template Header \\ -->";
        $html .= "                                </td>";
        $html .= "                            </tr>";
        $html .= "                            <tr class=\"spaceTop\">";
        $html .= "                            	<td align=\"center\" valign=\"top\">";
        $html .= "                                    <!-- // Begin Template Body \\ -->";
        $html .= "                                	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" class=\"bodyContent\">";
        if ($idLicenciaComprada == "donate") {
            $html .= "                                        <tr>";
            $html .= "                                        	<td valign=\"top\">";
            $html .= "                                            	<p>" . $this->idioma['mailAgradecerDonacion'] . "</p>";
            $html .= "                                            </td>";
            $html .= "                                        </tr>";
        } else if (strlen($producto) > 0) {
            $html .= "                       <table cellspacing=\"0\" cellpadding=\"6\" border=\"1\" style=\"color:#636363;border:1px solid #e5e5e5;vertical-align:middle;width:100%;font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif\">";
            $html .= "                              <thead>";
            $html .= "                                  <tr>";
            $html .= "                                      <th scope=\"col\" style=\"color:#636363;border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:left\">" . $this->idioma["mailProducto"] . "</th>";
            $html .= "                                      <th scope=\"col\" style=\"color:#636363;border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:left\">" . $this->idioma["mailCantidad"] . "</th>";
            $html .= "                                      <th scope=\"col\" style=\"color:#636363;border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:left\">" . $this->idioma["mailPrecio"] . "</th>";
            $html .= "                                   </tr>";
            $html .= "                              </thead>";
            $html .= "                          <tbody>";
            $html .= "                              <tr>";
            $html .= "                                  <td style=\"color:#636363;border:1px solid #e5e5e5;padding:12px;text-align:left;vertical-align:middle;font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif;word-wrap:break-word\">";
            $html .= "                                      <span class=\"il\"><span>" . $producto  . "</span></span>";
            $html .= "                                  </td>";
            $html .= "                                  <td style=\"color:#636363;border:1px solid #e5e5e5;padding:12px;text-align:left;vertical-align:middle;font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif\">" . $this->ipn_data["quantity"] . "</td>";
            $html .= "                                  <td style=\"color:#636363;border:1px solid #e5e5e5;padding:12px;text-align:left;vertical-align:middle;font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif\">";
            $html .= "                                      <span>" . $this->ipn_data["mc_gross"] . "<span> " . $currency . " </span></span>";
            $html .= "                                   </td>";
            $html .= "                              </tr>";
            $html .= "                          </tbody>";
            $html .= "                          <tfoot>";
            $html .= "                             <tr>";
            $html .= "                                 <th scope=\"row\" colspan=\"2\" style=\"color:#636363;border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:left;border-top-width:4px\">Total:</th>";
            $html .= "                                  <td style=\"color:#636363;border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:left;border-top-width:4px\">";
            $html .= "                                      <span>" . $this->ipn_data["mc_gross"] . "<span> " . $currency . " </span></span>";
            $html .=                                     "</td>";
            $html .= "                               </tr>";

            $html .= "                           </tfoot>";
            $html .= "                     </table>";


            $html .=                                        "<tr>";
            $html .=                                           "<td valign=\"top\" width=\"50%\" style=\"text-align:left;font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif;border:0;padding:0\">";
            $html .=                                               "<h4 style=\"color:#578e9f;display:block;font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif;font-size:18px;font-weight:bold;line-height:130%;margin:0 0 18px;text-align:left\">" . $this->idioma["mailInformacionComprador"] . "</h4>";
            $html .=                                               "<address style=\"padding:12px;color:#636363;border:1px solid #e5e5e5\">";
            $html .=                                                   $this->ipn_data["first_name"] . " " . $this->ipn_data["last_name"] . " " . "<br>" . $this->ipn_data["address_name"] . "<br>" . $this->ipn_data["address_city"] . "<br>" . $this->ipn_data["address_country"] . "<br>" . $this->ipn_data["address_zip"] . "<br>";
            $html .=                                                   "<a href=\"mailto:" . $this->ipn_data["payer_email"] . "\" target=\"_blank\">" . $this->ipn_data["payer_email"] . "</a>";
            $html .=                                               "</address>";
            $html .=                                           "</td>";
            $html .=                                        "</tr>";
            $html .=                                        "<br>";

            $html .= "                                        <tr>";
            $html .= "                                       	<td valign=\"top\"></td>";
            $html .= "                                        </tr>";

            $html .= "                                        <tr>";
            $html .= "                                        	<td valign=\"top\"></td>";
            $html .= "                                        </tr>";
        }
        $html .= "                                        <tr>";
        $html .= "                                        	<td valign=\"top\">&nbsp;";
        $html .= "                                            	";
        $html .= "                                            </td>";
        $html .= "                                        </tr>";
        $html .= "                                        <tr>";
        $html .= "                                        	<td valign=\"top\">&nbsp;";
        $html .= "                                            	";
        $html .= "                                            </td>";
        $html .= "                                        </tr>";
        $html .= "                                        <tr>";
        $html .= "                                        	<td valign=\"top\" class=\"aviso\">";
        $html .= "                                            	" . $this->idioma['mailEnviarMail'] . "<strong>support@adarsus.com</strong>";
        $html .= "                                          </td>";
        $html .= "                                        </tr>";
        $html .= "                                    </table>";
        $html .= "                                </td>";
        $html .= "                            </tr>";
        $html .= "                     </table>";
        $html .= "                 </td>";
        $html .= "             </tr>";
        $html .= "         </table>";
        $html .= "	</center>";
        $html .= "</body>";

        $html .= "</html>";
        //Guardamos el HTML en el LOG.
        $this->log_error($html);
        return $html;
    }

    function check_input($mysqli, $value)
    {
        // Stripslashes
        if (get_magic_quotes_gpc()) {
            $value = stripslashes($value);
        }
        // Quote if not a number
        if (!is_numeric($value)) {
            $value = "'" .  mysqli_real_escape_string($mysqli, $value) . "'";
        }
        return $value;
    }
    /** */
    function insert_bbdd($suscription)
    {
        $mysqli = new mysqli($this->hostname, $this->username, $this->password, $this->database);
        if ($mysqli->connect_errno) {
            $this->log_error("Falló la conexión con MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error);
        }

        $nombre = $this->check_input($mysqli, $this->ipn_data["first_name"]);
        $apellidos = $this->check_input($mysqli, $this->ipn_data["last_name"]);
        $verify_sign = $this->check_input($mysqli, $this->ipn_data["verify_sign"]);
        $txn_id = $this->check_input($mysqli, $this->ipn_data["txn_id"]);
        $email = $this->check_input($mysqli, $this->ipn_data["payer_email"]);
        $cod_activacion = $this->check_input($mysqli, $this->ipn_data["codigo_activacion"]);
        $transaccion = $this->check_input($mysqli, $this->ipn_data["payment_status"]);
        $precio = $this->check_input($mysqli, $this->ipn_data["mc_gross"]);
        $producto = $this->ipn_data["custom"];
        $direccion = $this->check_input($mysqli, $this->ipn_data["address_street"]);
        $ciudad = $this->check_input($mysqli, $this->ipn_data["address_city"]);
        $provincia = $this->check_input($mysqli, $this->ipn_data["address_state"]);
        $cp = $this->check_input($mysqli, $this->ipn_data["address_zip"]);
        $tip_licencia = $this->check_input($mysqli, $suscription);
        $cadena = "INSERT INTO wp_ventas (nombre, apellidos, verify_sign, txn_id, email, cod_activacion, direccion, ciudad, provincia, cp, producto, transaccion, precio, Tipo_Licencia ) VALUES (" . $nombre . "," . $apellidos . "," . $verify_sign . "," . $txn_id . "," . $email . "," . $cod_activacion . "," . $direccion . "," . $ciudad . "," . $provincia . "," . $cp . "," . $producto . "," . $transaccion . "," . $precio . "," . $tip_licencia . ")";

        $this->log_error("Cadena a insertar ->" . $cadena);

        if (!$mysqli->query($cadena)) {
            $this->log_error("Falló en la insersión del registro en la tabla: (" . $mysqli->errno . ") " . $mysqli->error);
        }

        if (!$mysqli->close($cadena)) {
            $this->log_error("Error cerrando la conexión: (" . $mysqli->errno . ") " . $mysqli->error);
        }
    }

    function log_error($text)
    {
        // Write to log
        $fp = fopen($this->ipn_log_file, 'a');
        fwrite($fp, $text . "\n\n");
        fclose($fp);  // close file
    }
}
