var dropArea = document.getElementById('dropArea');
var canvas = null;
var destinationUrl = 'https://www.metaclean.es/metaCleanOnline/upload.php';
var list = [];
var totalSize = 0;
var totalProgress = 0;
var microsoftExtension = ".doc, .dot, .docx, .docm, .dotx, .dotm, .xls, .xlt, .xlsx, .xlsm, .xltx, .xltm, .xlsb, .ppt, .pot, .pptx, .pptm, .potx, .potm, .ppsx, .ppsm, .vsd, .rtf";
var openOfficeExtension = ".odt, .ods, .odp";
var rawExtension = ", .arw, .cr2, .cr3, .crm, .crw, .ciff, .dng, .fff, .cs1, .erf, .iiq, .mef, .mrw, .nef, .nrw, .orf, .pef, .raf, .raw, .rw2, .rwl, .sr2, .srw, .x3f, .arq";
var audioVideo = ", .3g2, .3gp2, .3gp, .3gpp, .dvb, .f4a, .f4b, .f4p, .f4v, .m4a, .m4b, .m4p, .m4v, .mov, .qt, .avi, .mp3, .mp4, .mqv, .qtif, .qti, .qif, .aax, .avif, .dr4, .eps, .epsf, .ps, .exif, .flif, .gpr, .heic, .heif, .hif, .lrv, .xmp";
var allMultiMediaSupportFormat = ".dcp, .exv, .gif, .hdp, .wdp, .jxr, .jp2, .icc, .icm, .jpf, .j2k, .jpm, .jpx, .jpeg, .jpg, .jpe, .mie, .mos, .mpo, .png, .jng, .mng, .psd, .psb, .thm, .tiff, .tif, .vrd, .dng, .ai, .ait" + rawExtension + audioVideo;
var supportedFormat = microsoftExtension + openOfficeExtension + allMultiMediaSupportFormat + ", .pdf, .zip, .7z";
(function () {
    function initHandlers() {
        dropArea.addEventListener('drop', handleDrop, false);
        dropArea.addEventListener('dragover', handleDragOver, false);
        jQuery("#dropArea").append('<input type="file" id="fileDialog" style="display: none;" accept="' + supportedFormat + '"/>');
        jQuery(".box__icon").on("click", function () {
            jQuery("#fileDialog").trigger("click")
        });
        jQuery(':file').on('change', function () {
            processFiles(this.files)
        });
        jQuery("div#mcwsmessageArea").removeClass();
        jQuery("div#mcwsresultsfilename").removeClass();
        jQuery("div#mcwsresults div.et_pb_all_tabs div.et_pb_tab.clearfix div.et_pb_tab_content").html('No file uploaded.');
        jQuery("div#mcwsresults div.et_pb_all_tabs div.et_pb_tab.clearfix div.et_pb_tab_content").css({
            overflow: "auto",
            maxHeight: "22em"
        });
        jQuery("div.et_pb_with_border.et_pb_row.et_pb_row_1.et_pb_equal_columns div.et_pb_column.et_pb_column_1_2.et_pb_column_1.et_pb_css_mix_blend_mode_passthrough").css({
            display: "flex",
            justifyContent: "center",
            alignItems: "center"
        })
    }

    function removeMetadataFile(event) {
        event.stopPropagation();
        event.preventDefault();
        var buttonObj = this;
        var xhr = new XMLHttpRequest();
        xhr.open('POST', destinationUrl);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.responseType = 'blob';
        xhr.send("fileID=" + buttonObj.getAttribute("data-file-id"));
        xhr.onload = function (e) {
            if (this.status == 200) {
                var blob = new Blob([this.response], {
                    type: buttonObj.getAttribute("data-file-type")
                });
                var a = document.createElement("a");
                a.style = "display: none";
                document.body.appendChild(a);
                var url = window.URL.createObjectURL(blob);
                a.href = url;
                a.download = buttonObj.getAttribute("data-file-name");
                a.click();
                window.URL.revokeObjectURL(url)
            } else {
                jQuery("div#mcwsmessageArea").html('<div class="alert alert-danger" role="alert">The file has been removed from the server, upload it again.</div>')
            }
        }
    }

    function drawProgress(progress) {
        return false;
        context.clearRect(0, 0, canvas.width, canvas.height);
        context.beginPath();
        context.strokeStyle = '#4B9500';
        context.fillStyle = '#4B9500';
        context.fillRect(0, 0, progress * 500, 20);
        context.closePath();
        context.font = '16px Verdana';
        context.fillStyle = '#000';
        context.fillText('Progress: ' + Math.floor(progress * 100) + '%', 50, 15)
    }

    function handleDragOver(event) {
        event.stopPropagation();
        event.preventDefault();
        dropArea.className = 'hover'
    }

    function handleDrop(event) {
        event.stopPropagation();
        event.preventDefault();
        processFiles(event.dataTransfer.files)
    }

    function processFiles(filelist) {
        totalSize = 0;
        totalProgress = 0;
        jQuery("#mcwsmessageArea").empty();
        jQuery("#mcwsresultsfilename").empty();
        jQuery("#removeMetadata").parent().remove();
        jQuery("div#mcwsresults div.et_pb_all_tabs div.et_pb_tab.clearfix div.et_pb_tab_content").html('');
        if (!filelist || !filelist.length || list.length) return;
        else if (filelist.length > 1) {
            jQuery("div#mcwsmessageArea").html('<div class="alert alert-warning" role="alert">MetaClean Demo lets you upload one file at a time. <p>If you wish to upload more than one file at a time, ask for one of our plans, <a href="https://www.adarsus.com/en/contact/"><span>contact us.</span></a></div>');
            return
        }
        for (var i = 0; i < filelist.length && i < 5; i++) {
            list.push(filelist[i]);
            totalSize += filelist[i].size
        }
        uploadNext()
    }

    function handleComplete(size) {
        totalProgress += size;
        drawProgress(totalProgress / totalSize);
        uploadNext()
    }

    function handleProgress(event) {
        var progress = totalProgress + event.loaded;
        drawProgress(progress / totalSize)
    }

    function uploadFile(file, status) {
        var xhr = new XMLHttpRequest();
        xhr.overrideMimeType("application/json");
        xhr.open('POST', destinationUrl);
        xhr.onload = function () {
            handleComplete(file.size);
            if (this.status == 200) {
                var jsonResponse = JSON.parse(this.responseText);
                if (jsonResponse.msgError.toString().length > 0) {
                    jQuery("div#mcwsmessageArea").html('<div class="alert alert-danger" role="alert">' + jsonResponse.msgError + '</div>')
                } else {
                    for (var i = 0; i < 5; i++) {
                        var obj = jsonResponse[i];
                        if (obj == null) {
                            break
                        } else if (obj.Generico.length == 0 && obj.EXIF.length == 0 && obj.IPTC.length == 0 && obj.GPS.length == 0 && obj.XMP.length == 0) {
                            jQuery("div#mcwsmessageArea").html('<div class="alert alert-warning alert-dismissible"><button type="button" class="close" data-dismiss="alert">&times;</button>The file does not contain metadata.</div>');
                            jQuery("div#mcwsresultsfilename").html('<div class="alert alert-secondary" role="alert">File Name: ' + obj.dataFileName + '</div>');
                            continue
                        }
                        var mmExtension = allMultiMediaSupportFormat.split(",").map(function (item) {
                            return item.trim()
                        });
                        var extension = '.' + file.name.split('.').pop().toLowerCase();
                        var tipoFichero = mmExtension.includes(extension) ? "file" : "document";
                        jQuery('<div><button type="button" id="removeMetadata" class="btn btn-info" data-file-id="' + obj.dataFileId + '" data-file-name="' + obj.dataFileName + '" data-file-type="' + obj.dataFileType + '">Get my ' + tipoFichero + ' clean</button></div>').insertAfter("#mcwsresults");
                        document.getElementById('removeMetadata').addEventListener('click', removeMetadataFile, false);
                        jQuery("div#mcwsresultsfilename").html('<div class="alert alert-secondary" role="alert">File Name: ' + obj.dataFileName + '</div>');
                        if (obj.Generico) {
                            var contenido = '';
                            Object.keys(obj.Generico).forEach(function (item) {
                                contenido += '<div class="mcws-row"><span class="mcws-keymeta">' + item + "</span>: " + obj.Generico[item] + '</div>'
                            });
                            jQuery("div#mcwsresults div.et_pb_all_tabs div.et_pb_tab.et_pb_tab_0 div.et_pb_tab_content").html(contenido);
                            if (contenido.trim().length > 0) {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_0").attr('style', 'display: block;');
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_0").trigger("click")
                            } else {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_0").attr('style', 'display: none;')
                            }
                        }
                        if (obj.EXIF) {
                            var contenido = '';
                            Object.keys(obj.EXIF).forEach(function (item) {
                                contenido += '<div class="mcws-row"><span class="mcws-keymeta">' + item + "</span>: " + obj.EXIF[item] + '</div>'
                            });
                            jQuery("div#mcwsresults div.et_pb_all_tabs div.et_pb_tab.et_pb_tab_1 div.et_pb_tab_content").html(contenido);
                            if (contenido.trim().length > 0) {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_1").attr('style', 'display: block;');
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_1").trigger("click")
                            } else {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_1").attr('style', 'display: none;')
                            }
                        }
                        if (obj.GPS) {
                            var contenido = '';
                            Object.keys(obj.GPS).forEach(function (item) {
                                contenido += '<div class="mcws-row"><span class="mcws-keymeta">' + item + "</span>: " + obj.GPS[item] + '</div>'
                            });
                            jQuery("div#mcwsresults div.et_pb_all_tabs div.et_pb_tab.et_pb_tab_2 div.et_pb_tab_content").html(contenido);
                            if (contenido.trim().length > 0) {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_2").attr('style', 'display: block;')
                            } else {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_2").attr('style', 'display: none;')
                            }
                        }
                        if (obj.IPTC) {
                            var contenido = '';
                            Object.keys(obj.IPTC).forEach(function (item) {
                                contenido += '<div class="mcws-row"><span class="mcws-keymeta">' + item + "</span>: " + obj.IPTC[item] + '</div>'
                            });
                            jQuery("div#mcwsresults div.et_pb_all_tabs div.et_pb_tab.et_pb_tab_3 div.et_pb_tab_content").html(contenido);
                            if (contenido.trim().length > 0) {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_3").attr('style', 'display: block;')
                            } else {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_3").attr('style', 'display: none;')
                            }
                        }
                        if (obj.XMP) {
                            var contenido = '';
                            Object.keys(obj.XMP).forEach(function (item) {
                                contenido += '<div class="mcws-row"><span class="mcws-keymeta">' + item + "</span>: " + obj.XMP[item] + '</div>'
                            });
                            jQuery("div#mcwsresults div.et_pb_all_tabs div.et_pb_tab.et_pb_tab_4 div.et_pb_tab_content").html(contenido);
                            if (contenido.trim().length > 0) {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_4").attr('style', 'display: block;')
                            } else {
                                jQuery("div#mcwsresults.et_pb_module.et_pb_tabs.et_pb_tabs_0 ul.et_pb_tabs_controls.clearfix li.et_pb_tab_4").attr('style', 'display: none;')
                            }
                        }
                    }
                }
            } else if (this.status == 404) {
                jQuery("div#mcwsmessageArea").html('<div class="alert alert-warning" role="alert">' + this.responseText + '</div>');
                jQuery("div#mcwsresultsfilename").html('<div class="alert alert-secondary" role="alert">File Name: ' + file.name + '</div>')
            }
            if (canvas != null) canvas.style.display = "none"
        };
        xhr.onerror = function () {
            jQuery("div#mcwsmessageArea").html('<div class="alert alert-danger" role="alert">' + this.responseText + '</div>');
            handleComplete(file.size)
        };
        xhr.upload.onprogress = function (event) {
            handleProgress(event)
        };
        xhr.upload.onloadstart = function (event) {
            if (canvas != null) canvas.style.display = "block"
        };
        var formData = new FormData();
        formData.append('fileToProcess', file);
        xhr.send(formData)
    }

    function uploadNext() {
        if (list.length) {
            dropArea.className = 'uploading';
            var nextFile = list.shift();
            if (nextFile.size >= 51200000) {
                jQuery("div#mcwsmessageArea").html('<div class="alert alert-warning" role="alert">File size exceeds maximum allowed size: ' + formatBytes(nextFile.size, 2) + '<p>Maximum allowed size: 50 MB</p></div>');
                jQuery("div#mcwsresultsfilename").html('<div class="alert alert-secondary" role="alert">File Name: ' + nextFile.name + '</div>');
                handleComplete(nextFile.size)
            } else {
                uploadFile(nextFile, status)
            }
        } else {
            dropArea.className = ''
        }
    }

    function formatBytes(bytes, decimals) {
        if (bytes === 0) return '0 Bytes';
        var k = 1024;
        var dm = decimals < 0 ? 0 : decimals;
        var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
        var i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i]
    }
    initHandlers()
})();