<?php


// Incluir Bootstrap CSS
function bootstrap_css()
{
	wp_enqueue_style(
		'bootstrap_css',
		get_stylesheet_directory_uri() . '/css/bootstrap.min.css',
		array(),
		'4.3.1'
	);
}
add_action('wp_enqueue_scripts', 'bootstrap_css');

// Incluir Bootstrap JS
function bootstrap_js()
{
	wp_enqueue_script(
		'bootstrap_js',
		get_stylesheet_directory_uri() . '/js/bootstrap.min.js',
		array('jquery'),
		'4.3.1',
		true
	);
	wp_enqueue_script(
		'bootstrap_b_js',
		get_stylesheet_directory_uri() . '/js/bootstrap.bundle.min.js',
		array('jquery'),
		'4.3.1',
		true
	);
}
add_action('wp_enqueue_scripts', 'bootstrap_js');

add_action('wp_ajax_download_trial_software', 'download_trial_software');
add_action('wp_ajax_nopriv_download_trial_software', 'download_trial_software');

function download_trial_software()
{
	global $wpdb; // this is how you get access to the database

	$table_name = $wpdb->prefix . "descargas";
	$des = "";
	switch ($_POST['idproducto']) {
		case "633":
		case "1057":
			$des = "MetaClean Control";
			break;
		case "635":
		case "1055":
			$des = "MetaClean Command-Line";
			break;
		case "637":
		case "1047":
			$des = "Metaclean for outlook";
			break;
	}

	//Insertamos en bbdd.
	try {
		$data = array(
			'producto' => $des . " " . $_POST['so'],
			'email' => $_POST['email'],
			'ndescargas' => 1,
			'idioma' => ICL_LANGUAGE_CODE == 'es' ? "es_ES" : "en_US",
		);

		$insert = $wpdb->insert(
			$table_name,
			$data,
			array('%s', '%s', '%d', '%s')
		);
		$id = $wpdb->insert_id;
		$whatever += 200;
	} catch (Exception $e) {
		write_log('Error al guardar en la tabla de ventas error generado: ',  $e->getMessage(), "\n");
		if (is_wp_error($insert)) {
			throw new WC_API_Exception('woocommerce_order_status_completed', $insert->get_error_message(), 400);
		}
		$whatever += 100;
	}
	echo $whatever;
	die();
}

/**
 * Pagina.
 * https://www.adarsus.com/en/metaclean.html?id=wc_order_4NtsZjicDbHOR&pid=633&variant_id=1252
 */
  
  
function buy_metaclean() {
	$url = "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	$parts = parse_url($url);
	$_SESSION["tran"] = "";
	//write_log($parts);
	if(!isset($parts['query']))
		return;
	parse_str($parts['query'], $query);

    if(strpos($url, 'edicion-metadatos-documentos-metaclean') !== false || strpos($url, 'edit-metadata-documents-metaclean') !== false){ 
        if($_SESSION["tran"] != $query['id'] && $query['pid'] != ""){
			$_SESSION["tran"] = $query['id'];
			$tipoLicencia = $query['pid'];
			$metaclean = '';
			if ($tipoLicencia == "CMZ") { 
				$metaclean = 'Licencia Microsoft Office + Open Office + PDF';
			} else if ($tipoLicencia == "ER6") { 
				$metaclean = 'Licencia Microsoft Office + Open Office';
			} else if ($tipoLicencia == "EEY") { 
				$metaclean =  'Licencia Microsoft Office + PDF';
			} else if ($tipoLicencia == "36R") { 
				$metaclean = 'Licencia Open Office + PDF';
			} else if ($tipoLicencia == "7SC") { 
				$metaclean = 'Licencia Microsoft Office';
			} else if ($tipoLicencia == "PKK") { 
				$metaclean = 'Licencia Open Office';
			} else if ($tipoLicencia == "S3D") { 
				$metaclean = 'Licencia PDF';
			} else if ($tipoLicencia == "AB1") { 
				$metaclean = 'Licencia Command Line Home Standard Edition';
			} else if ($tipoLicencia == "AB1") { 
				$metaclean = 'Licencia OpenOffice + Multimedia';
			} else if ($tipoLicencia == "AB2") { 
				$metaclean = 'Licencia PDF + Multimedia';
			} else if ($tipoLicencia == "AB3") { 
				$metaclean = 'Licencia Multimedia';
			} else if ($tipoLicencia == "AB4") { 
				$metaclean = 'Licencia FULL';
			} else if ($tipoLicencia == "AB5") { 
				$metaclean = 'Licencia Microsoft Office + Open Office + Multimedia';
			} else if ($tipoLicencia == "AB6") { 
				$metaclean = 'Licencia Microsoft Office + PDF + Multimedia';
			} else if ($tipoLicencia == "AB7") { 
				$metaclean = 'Licencia OpenOffice + PDF + Multimedia';
			} else if ($tipoLicencia == "AB8") { 
				$metaclean = 'Licencia Microsoft Office + Multimedia';
			} else if ($tipoLicencia == "OUT") { 
				$metaclean = 'Licencia Outlook';
			}else{
				$metaclean = 'Licencia no valida.';
			}
			include( locate_template( 'buy_metaclean.php', false, false ) ); 
		}
    }
}

add_action( 'wp_head', 'buy_metaclean' );
