<?php
if (!defined('ABSPATH')) {
	exit;
}
?>
<!-- Latest compiled and minified CSS -->
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/multiple-select/1.2.3/multiple-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="//cdnjs.cloudflare.com/ajax/libs/multiple-select/1.2.3/multiple-select.min.js"></script>

<!-- Modal -->
<script type="text/javascript">
	jQuery(document).ready(function($) {

		setTimeout(openDialog, 3000);

		function getUrlVars() { // Read a page's GET URL variables and return them as an associative array.
			var vars = [],
				hash;
			var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
			for (var i = 0; i < hashes.length; i++) {
				hash = hashes[i].split('=');
				vars.push(hash[0]);
				vars[hash[0]] = hash[1];
			}
			return vars;
		}

		$('#plataforma').multipleSelect({
			placeholder: '<?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Seleccionar' : 'Choose');  ?>',
			selectAll: false,
			single: true
		});

		var ctrlDown = false,
			ctrlKey = 17,
			cmdKey = 91,
			vKey = 86,
			cKey = 67;

		$(document).keydown(function(e) {
			if (e.keyCode == ctrlKey || e.keyCode == cmdKey) ctrlDown = true;
		}).keyup(function(e) {
			if (e.keyCode == ctrlKey || e.keyCode == cmdKey) ctrlDown = false;
		});

		// Document Ctrl + C/V 
		$(document).keydown(function(e) {
			if (ctrlDown && (e.keyCode == vKey)) $('#btnActivar').removeProp('disabled');
		});


		function openDialog() {
			$('#name_product').text('<?php echo str_replace('Licencia', ICL_LANGUAGE_CODE == 'es' ? 'Licencia' : 'Licensing', $metaclean); ?>');
			//$('#metaclean-modal').modal('show');
			$('#metaclean-modal').modal({
				backdrop: 'static',
				keyboard: false
			})


		}

		$("#inputCodValidacion").keypress(function() {
			$('#btnActivar').removeAttr('disabled', 'disabled');
		});

		// $("#inputCodValidacion").change(function(event) {
		// 	$('#btnActivar').removeAttr('disabled');
		// });

		$("#inputCodValidacion").keyup(function() {
			if (!this.value) {
				$('#btnActivar').attr('disabled', 'disabled');
			}else{
				$('#btnActivar').removeAttr('disabled', 'disabled');
			}
		});

		$(".activation").hide();

		$('#btnActivar').on('click', function() {
			// event.preventdefault();
			var $result = $("#result");
			$result.text("");
			var codVerificacion = $("#inputCodValidacion").val().trim();
			var plataforma = $('#plataforma').val();
			if (!plataforma) {
				$result.text('<?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Debe seleccionar al menos una plataforma.' : 'You must select at least one platform.')  ?>');
				$result.css("color", "red");
				return false;
			} else {
				plataforma = $('.ms-parent span').first().text();
			}
			if (codVerificacion.length > 0 && codVerificacion.lastIndexOf(" ") < 0) {
				try {
					var parametros = "codVerificacion=" + encodeURIComponent(codVerificacion) + "&txn_id=" + encodeURIComponent(getUrlVars()["id"]) + "&lang=" + document.documentElement.lang + "&plataforma=" + $.trim(plataforma);
					$.ajax({
						data: parametros,
						url: 'https://www.adarsus.com/bat/activation.php',
						type: 'post',
						success: function(response) {
							$(".activation").fadeIn(10, function() {
								$(".activation").show();
								$("#textAreaCodActivacion").val(response);
								$("#textAreaCodActivacion").focusin(function() {
									this.select();
								});
							});
						},
						fail: function(response) {
							$(".activation").show();
							$("#textAreaCodActivacion").val(response);
						}
					});
				} catch (error) {
					console.error(error);
					$(".activation").show();
					$("#textAreaCodActivacion").val(response);
					// expected output: ReferenceError: nonExistentFunction is not defined
					// Note - error messages will vary depending on browser
				}

			} else
				$("#insertCodValidacion").fadeIn();
		});
	});
</script>

<!-- Modal -->
<div class="modal fade" id="metaclean-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header color-principal">
				<h5 class="modal-title text-white" id="exampleModalLongTitle"><?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Obtener código de activación' : 'Get Activation Code')  ?></h5>
				<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<div id="alert-ok" class="alert alert-success invisible" role="alert"></div>
				<div id="alert-ko" class="alert alert-danger invisible" role="alert"></div>
				<div class="form-group row">
					<label class="col-sm-4 col-form-label"><?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Metaclean Para.' : 'Metaclean for.')  ?></label>
					<div class="col-sm-8">
						<label id="name_product" for="product" class="col-form-label"></label>
					</div>
				</div>
				<div class="form-group row">
					<label for="inputPassword" class="col-sm-4 col-form-label"><?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Plataforma' : 'Plataform')  ?></label>
					<div class="col-sm-8">
						<select id="plataforma" multiple="multiple" style="width: 300px;">
							<option value="1">Microsoft Windows</option>
							<option value="2">Linux</option>
							<option value="3">Unix</option>
							<option value="4">Mac OS X</option>
						</select>
						<p id='result'></p>
					</div>
				</div>
				<div class="form-group row">

					<label class="col-sm-12 col-form-label"><a target="_blank" href="https://www.adarsus.com/wp-content/uploads/2019/04/instructions.pdf"><strong><?php printf(ICL_LANGUAGE_CODE == 'es' ? '¿Cómo obtener mi MetaClean-ID? ' : 'How to obtain my MetaClean-ID?')  ?></strong></a></label>
				</div>
				<div class="form-group row">
					<div class="col-sm-12">
						<input type="text" class="form-control" id="inputCodValidacion" placeholder="<?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Ingrese su Metaclean-ID' : 'Enter your MetaClean-ID')  ?>">
					</div>
				</div>

				<div class="form-group row activation">
					<div class="col-sm-12">
						<label id="etiquetaCodVerif" for=""><?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Copie el siguiente código de activación.' : 'Copy the following activation code.')  ?></label>
					</div>
				</div>
				<div class="form-group row activation">
					<div class="col-sm-12">
						<textarea id="textAreaCodActivacion" class="form-control"></textarea>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button id="btnActivar" type="button" class="btn color-principal text-white" disabled><?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Activar' : 'Activate')  ?></button>
				<button id="btnClose" type="button" class="btn btn-secondary" data-dismiss="modal"><?php printf(ICL_LANGUAGE_CODE == 'es' ? 'Cerrar' : 'Close')  ?></button>
			</div>
		</div>
	</div>
</div>