const maxFileSizeBytes = 52428800;  //50 MB

//Supported Extensions
const microsoftExtension = ".doc, .dot, .docx, .docm, .dotx, .dotm, .xls, .xlt, .xlsx, .xlsm, .xltx, .xltm, .xlsb, .ppt, .pot, .pptx, .pptm, .potx, .potm, .ppsx, .ppsm, .vsd, .rtf";
const openOfficeExtension = ".odt, .ods, .odp";
const rawExtension = ", .arw, .cr2, .cr3, .crm, .crw, .ciff, .dng, .fff, .cs1, .erf, .iiq, .mef, .mrw, .nef, .nrw, .orf, .pef, .raf, .raw, .rw2, .rwl, .sr2, .srw, .x3f, .arq";
const audioVideo = ", .3g2, .3gp2, .3gp, .3gpp, .dvb, .f4a, .f4b, .f4p, .f4v, .m4a, .m4b, .m4p, .m4v, .mov, .qt, .avi, .mp3, .mp4, .mqv, .qtif, .qti, .qif, .aax, .avif, .dr4, .eps, .epsf, .ps, .exif, .flif, .gpr, .heic, .heif, .hif, .lrv, .xmp";
const compressedExtension = ".zip, .7z";

const allMultiMediaSupportFormat = ".dcp, .exv, .gif, .hdp, .wdp, .jxr, .jp2, .icc, .icm, .jpf, .j2k, .jpm, .jpx, .jpeg, .jpg, .jpe, .mie, .mos, .mpo, .png, .jng, .mng, .psd, .psb, .thm, .tiff, .tif, .vrd, .dng, .ai, .ait" + rawExtension + audioVideo;
const supportedFormat =  microsoftExtension + ", " + openOfficeExtension + ", " + allMultiMediaSupportFormat  + ", " + compressedExtension + ", .pdf";

let dropArea = document.getElementById('dropArea');
let canvas = null;
let list = [];
let totalSize = 0;
let totalProgress = null;

const pdfTemplate = new Array("Title", "Subject", "Author", "Keywords", "Create Date", "Modify Date", "Application", "PDF Producer", "Custom Properties");
const microsoftOfficeTemplate = new Array("Title", "Subject", "Author", "Keywords", "Create Date", "Modify Date", "Application", "Manager", "Company", "Modify By", "Custom Properties", "Category", "Status", "Revision Number", "Template", "Content Type", "Edition Time", "Printed Date", "Comments");
const openOfficeTemplate = new Array("Title", "Subject", "Author", "Keywords", "Create Date", "Modify Date", "Application", "Modify By", "Custom Properties", "Revision Number", "Edition Time", "Printed By", "Printed Date", "Comments");
let arrayTemplate = null;

let pattern = /^([1-9]|([012][0-9])|(3[01]))-([0]{0,1}[1-9]|1[012])-\d\d\d\d, (20|21|22|23|[0-1]?\d):[0-5]?\d:[0-5]?\d$/g;
//let pattern = /^([1-9]|([012][0-9])|(3[01])) (ene|feb|mar|abr|may|jun|jul|ago|sep|oct|nov|dic) \d\d\d\d, (20|21|22|23|[0-1]?\d):[0-5]?\d:[0-5]?\d (AM|PM)$/g;
//let pattern = /^([1-9]|([012][0-9])|(3[01])) (ene|feb|mar|abr|may|jun|jul|ago|sep|oct|nov|dic) \d\d\d\d, ([0]{0,1}[1-9]|1[012]):[0-5]?\d:[0-5]?\d (AM|PM)$/g;

const enMessage = {
	noFileUpload: "No file uploaded.", 
	mainTitle: "Online Metadata Cleaner/Editor", 
	tabMetadataDocument: "DOCUMENT METADATA", 
	fileDownloaded: "The file has been downloaded from the server. Please select a file again.", 
	errorDateFormat: "<p>Date format error. Please apply the following format: </p><span> Example-1: 24-03-2018, 23:19:53</span><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Example-2: 13-1-2021, 3:59:03</span>",
	metadataTemplateNull: "Metadata template is Null",
	noServerResponse: "No response from server, please check your network connection.",
	multipleFilesUpload: "The metadata edition does not allow uploading several files at the same time.",
	fileName: "File Name:",
	compressedFiles: "For compressed files, the metadata will not be displayed.",
	noMetadataFile: "The XXX file does not contain any metadata.",
	cleanMetadataButton: "Clean metadata",
	customMetadataButton: "Custom metadata",
	pdfSigned: "Signed PDF file. If you modify its metadata you will lose the digital signature credentials.",
	fileExcedsMaxAllowed: "File size exceeds maximum allowed size: XXX <br>Maximum allowed size: YYY",
	extensionFileNoSupported: "File extension not supported",
	moreInfo: " (more info)"
};

const esMessage = {
	noFileUpload: "No se ha cargado ningún fichero.",
	mainTitle: "Limpiador/Editor de Metadatos Online",
	tabMetadataDocument: "METADATOS DEL DOCUMENTO",
	fileDownloaded: "El fichero ha sido descargado del servidor. Seleccione de nuevo un fichero.",
	errorDateFormat: "<p>Error en el formato de fecha. Aplique el siguiente formato: </p><span> Ejemplo-1: 24-03-2018, 23:19:53</span><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ejemplo-2: 13-1-2021, 3:59:03</span>",
	metadataTemplateNull: "La plantilla de metadatos es NULL",
	noServerResponse: "No hay respuesta del servidor, por favor verifica la conexión.",
	multipleFilesUpload: "La edición de metadatos no permite subir varios ficheros a la vez.",
	fileName: "Fichero:",
	compressedFiles: "Para los ficheros comprimidos no se mostrarán los metadatos.",
	noMetadataFile: "El XXX no contiene metadatos.",
	cleanMetadataButton: "Borrar metadatos",
	customMetadataButton: "Editar metadatos",
	pdfSigned: "Fichero firmado electrónicamente. Si modifica sus metadatos las firmas perderán su validez.",
	fileExcedsMaxAllowed: "El fichero excede el tamaño máximo permitido: XXX <br>Tamaño máximo permitido: YYY",
	extensionFileNoSupported: "Extensión de fichero no soportada",
	moreInfo: " (más info)"
};

//Internationalization
let userMessage = null; 

(function() {
	
	function getLanguage() {
		let userLang = navigator.language || navigator.userLanguage;
		
		if(window.location.host.includes("cleandoc-eng.")) {
			userLang = "en";
			userMessage = enMessage;
			
		} else if(window.location.host.includes("cleandoc")) {
			userLang = "es";
			userMessage = esMessage;
		}
		
		userMessage = (userLang=='es'?esMessage:enMessage)
		
		//console.log('userLang: ' + userLang);
		
		getWebServiceUrl().then(result => {
			// init handlers
			initHandlers();
			
			if(!metacleanUrl.startsWith("http")) {
				$("#modalLoginMessage").modal('show');
				
				if(localStorage.getItem("loginMetaCleanOnline") && localStorage.getItem("passwdMetaCleanOnline")) {
					$("input#loginUsername" ).val(localStorage.getItem("loginMetaCleanOnline"));
					$("input#loginPasswd" ).val(localStorage.getItem("passwdMetaCleanOnline"));
				}
				
				$(".modal-backdrop.show").css("opacity", "1");
			}
			
		}).catch((error) => { 
			console.log("Error getWebServiceUrl :::: " + error.message); 
		});
	}
	
    function initHandlers() {
		$("#dropArea").append('<input type="file" id="fileDialog" style="display: none;" accept="'+supportedFormat+'"/>');
		
        dropArea.addEventListener('drop', handleDrop, false);
        dropArea.addEventListener('dragover', handleDragOver, false);
		dropArea.addEventListener('dragleave', handleDragLeave, false);
		
		dropArea.addEventListener("click", function(){
			document.getElementById('fileDialog').click();
		});
		
		document.getElementById('fileDialog').onchange = function(event) {
			if (event.target.files.length > 0)
				processFiles(event.target.files);
			
			// this line will reset the input field so you can re-add the same file
			event.target.value = '';
		};
		
        $("div#mcwsmessageArea").removeClass();
        $("div#mcwsresultsfilename").removeClass();
        
        //Borramos el contenido de todos los DIV de pestañas
        $("div#mcwsresults div.tab-content div.mc_tab_content").html(userMessage.noFileUpload);
        
		//Acciones sobre el contenido de los metadatos
		$('div#mcwsresults').on('mouseenter', 'div.mcws-input.mcws-textfield div.mcws-keymeta', function() {
			$(this).find('div').first().css("visibility", "visible");
		});
		
		$('div#mcwsresults').on('mouseleave', 'div.mcws-input.mcws-textfield div.mcws-keymeta', function() {
			$(this).find('div').first().css("visibility", "hidden");
		});
		
		//Evento para eliminar la fila del metadato
		$('div#mcwsresults').on('click', 'div.mcws-input.mcws-textfield div.mcws-keymeta div button.close', function() {
			$(this).fadeOut("normal", function() {
				$.when($(this).parent().parent().parent().remove()).then( () => {
					//Eliminamos el mensaje de error de fecha si corresponde
					let totalDateFieldElement = $('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield div.mcws-valuemeta.dateField').length;
					let errorDateFound = false;
							
					$('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield div.mcws-valuemeta.dateField').each(function(index) {
						if(!$(this).text().trim().match(pattern) && $(this).text().trim().length > 0)
							errorDateFound = true;
								
						if($("#removeMetadata").is(':disabled')) {
							$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.fileDownloaded + '</div>');
							$("#customMetadata").css("visibility", "hidden");
							
							return false;
								
						} else if (index === totalDateFieldElement-1) {
							if(errorDateFound) {
								$("#customMetadata").css("visibility", "hidden");
							} else {
								$("#customMetadata").css("visibility", "visible");
								$("div#mcwsmessageArea").empty();
							}
						}
					});
					
					if($("#removeMetadata").is(':disabled')) {
						$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.fileDownloaded + '</div>');
						$("#customMetadata").css("visibility", "hidden");
								
					} else if(totalDateFieldElement === 0) {
						//Mostramos el boton para customizar los metadatos del documento
						$("#customMetadata").css("visibility", $('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield div.mcws-keymeta').length > 0 ? "visible" : "hidden");
					}
				});
			});
		});
		
		//Descargar el fichero procesado SIN metadatos
		$('html body div.container div.upload_form_cont div.info').on('click', 'button#removeMetadata', removeMetadataFile);
		
		//Descargar el fichero procesado CON metadatos customizados
		$('html body div.container div.upload_form_cont div.info').on('click', 'button#customMetadata', customMetadataFile);
				
		$('div#mcwsresults').on('keydown', 'div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield div.mcws-valuemeta', function(e) {
			let event = e || window.event;
			let key = (typeof e.which == "number") ? event.which : event.keyCode;
			let ctrl = event.ctrlKey ? event.ctrlKey : ((key === 17) ? true : false); // ctrl detection
			
			if($(this).hasClass("numberField") && !(key >= 48 && key <= 57) && key != 8 && key != 37 && key != 39) 
				return false;
			else if($(this).hasClass("dateField") && !(key >= 48 && key <= 57) && key != 8 && key != 37 && key != 39 && String.fromCharCode(key) != ',' && String.fromCharCode(key) != ':' && String.fromCharCode(key) != '-' && String.fromCharCode(key) != ' ')
				return false;
						
			if($("#removeMetadata").is(':disabled')) {
				$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.fileDownloaded + '</div>');
				$("#customMetadata").css("visibility", "hidden");
					
			} else if($(this).hasClass("dateField")) {
				if($(this).text().trim().match(pattern) || $(this).text().trim().length == 0) {
					$(this).css("border", "");
					
					let totalDateError = $('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield div.mcws-valuemeta.dateField').length;
					let removeMsg = true;
					
					$('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield div.mcws-valuemeta.dateField').each(function(index) {
						if(!$(this).text().trim().match(pattern) && $(this).text().trim().length > 0)
							removeMsg = false;
						
						if ((index === (totalDateError - 1)) && removeMsg) {
							$("div#mcwsmessageArea").empty();
							$("#customMetadata").css("visibility", "visible");
						}
					});
					
				} else {
					$(this).css("border", "red solid 2px");
				
					$("div#mcwsmessageArea").html('<div class="alert alert-danger" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.errorDateFormat + '</div>');
					$("#customMetadata").css("visibility", "hidden");
				}
				
			} else {
				let totalElement = $('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield div.mcws-valuemeta.dateField').length;
				let errorDateFound = false;
					
				if(totalElement == 0)
					$("#customMetadata").css("visibility", "visible");
					
				$('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield div.mcws-valuemeta.dateField').each(function(index) {
					if(!$(this).text().trim().match(pattern) && $(this).text().trim().length > 0)
						errorDateFound = true;
						
					if (index === totalElement-1) {
						if(errorDateFound) {
							$("#customMetadata").css("visibility", "hidden");
						} else {
							$("#customMetadata").css("visibility", "visible");
							$("div#mcwsmessageArea").empty();
						}
					}
				});
			}

			/*
			if($(this).hasClass("numberField") && !(key >= 48 && key <= 57) && key != 8 && key != 37 && key != 39) 
				return false;
			else if ( (key == 86 || key == 67) && ctrl)
				return true;
			else if($(this).hasClass("dateField") && !(key >= 48 && key <= 57) && key != 8 && key != 37 && key != 39 && String.fromCharCode(key) != ',' && String.fromCharCode(key) != ':' && String.fromCharCode(key) != '-' && String.fromCharCode(key) != ' ')
				return false;
			else
				return true;
			*/
		});
		
		$('div#mcwsresults').on('click', 'i.fas.fa-list', function(event) {
			$("div#mcwsmessageArea").empty();
			
			if(arrayTemplate != null) {
				let map = new Object();
				let contenido = '';
				
				//Guardamos los valores actuales de los metadatos
				$('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield').each(function(index) {
					let key = $(this).find('.mcws-keymeta').text().trim();
					let objectValue = $(this).find('.mcws-valuemeta');
					let value = objectValue.text().trim();
					
					if(objectValue.hasClass("dateField") && !value.match(pattern))
						value = "";

					if(value.length > 0)
						map[key.slice(0,-1)] = value; //Para eliminar el ultimo caracter del nombre de la clave
				});
				
				$.each(arrayTemplate, function(index, value) {
					let item = arrayTemplate[index];
					
					if(item.toLowerCase().endsWith("date")) {
						contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta">' + item + '<div><button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></div></div><div class="mcws-valuemeta dateField" contenteditable="true">' + (map.hasOwnProperty(item)?map[item]:'&nbsp;') + '</div></div>';
									
					} else if(item.toLowerCase().endsWith("revision number") || item.toLowerCase().endsWith("edition time")) {
						contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta">' + item + '<div><button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></div></div><div class="mcws-valuemeta numberField" contenteditable="true">' + (map.hasOwnProperty(item)?map[item]:'0') + '</div></div>';
									
					} else {
						contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta">' + item + '<div><button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></div></div><div class="mcws-valuemeta" contenteditable="true">' + (map.hasOwnProperty(item)?map[item]:'-') + '</div></div>';
					}
				});
				
				//Añadimos el contenido
                $("div#mcwsresults div.tab-content div#metadataDoc.container.tab-pane div.mc_tab_content").html(contenido);
				
			} else
				alert(userMessage.metadataTemplateNull);
		});
		
		try {
			$("body > div > div.contr > span").text(userMessage.mainTitle);
			$("#mcwsresults > ul > li:nth-child(1) > a").html(userMessage.tabMetadataDocument);
			
		} catch(ex) {
			console.log('Se ha producido un error en la internacionalizacion :::: ' + ex.message);
		}
    }
    
    function removeMetadataFile(event) {
        event.stopPropagation();
        event.preventDefault();
        
        let buttonObj = this;
        
        let xhr = new XMLHttpRequest();
        xhr.open('GET', (metacleanServerUrl != null ? metacleanServerUrl : metacleanUrl) + '/service/file?fileID=' + encodeURIComponent(buttonObj.getAttribute('data-file-id')) + '&originalFileName=' + encodeURIComponent(buttonObj.getAttribute("data-file-name")));
        
        //Send the proper header information along with the request
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

        //set the reponse type to blob since that's what we're expecting back
        xhr.responseType = 'blob';
		//xhr.timeout = 5000;
		
        xhr.send(); 

        xhr.onload = function(e) {
            if (this.status == 200) {
				let ct = xhr.getResponseHeader("content-type") || "";
						
				if (ct.indexOf('application/json') > -1) {
					let reader = new FileReader();
					
					reader.addEventListener("loadend", function() {
						let output = JSON.parse(reader.result)[0];
						let errorMsg = output.msgError.length > 0 ? output.msgError : output.msgOut;	

						$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + errorMsg + '</div>');
					});
					
					reader.readAsText(xhr.response);
					
				} else {
					// Create a new Blob object using the response data of the onload object
					let blob = new Blob([this.response], {type: buttonObj.getAttribute("data-file-type")});
					//Create a link element, hide it, direct it towards the blob, and then 'click' it programatically
					let a = document.createElement("a");
					a.style = "display: none";
					document.body.appendChild(a);
					//Create a DOMString representing the blob and point the link element towards it
					let url = window.URL.createObjectURL(blob);
					a.href = url;
					a.download = buttonObj.getAttribute("data-file-name");
					//programatically click the link to trigger the download
					a.click();
					//release the reference to the file by revoking the Object URL
					window.URL.revokeObjectURL(url);
					
					//$('div.container div.upload_form_cont div.info').focus();
				}
				
				//Disable buttons
				$("#removeMetadata").prop("disabled",true);
				$("#customMetadata").prop("disabled",true);
                
            } else {
				$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.noServerResponse + '</div>');
            }
        };
    }
	
	function customMetadataFile(event) {
        event.stopPropagation();
        event.preventDefault();
        
        let buttonObj = this;
        
        let xhr = new XMLHttpRequest();
        xhr.open('POST', (metacleanServerUrl != null ? metacleanServerUrl : metacleanUrl) + '/service/file');
        
        //Send the proper header information along with the request
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

        //set the reponse type to blob since that's what we're expecting back
        xhr.responseType = 'blob';
		
		let metadataEntries = 'fileID=' + encodeURIComponent(buttonObj.getAttribute('data-file-id'));
		
		$('div#metadataDoc.container.tab-pane.active div.mc_tab_content div.mcws-input.mcws-textfield').each(function(index) {
			let key = $(this).find('.mcws-keymeta').text().toLowerCase().trim();
			let value = $(this).find('.mcws-valuemeta').text().trim();
			
			if(value.length > 0 && value != '-')
				metadataEntries += '&' + encodeURIComponent(key) + '=' + encodeURIComponent(value);
		});		
		
		metadataEntries += '&originalFileName' + '=' + encodeURIComponent(buttonObj.getAttribute("data-file-name"));
		
        xhr.send(metadataEntries); 

        xhr.onload = function(e) {
            if (this.status == 200) {
				let ct = xhr.getResponseHeader("content-type") || "";
						
				if (ct.indexOf('application/json') > -1) {
					let reader = new FileReader();
					
					reader.addEventListener("loadend", function() {
						let output = JSON.parse(reader.result)[0];
						let errorMsg = output.msgError.length > 0 ? output.msgError : output.msgOut;	

						$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + errorMsg + '</div>');
					});
					
					reader.readAsText(xhr.response);
					
				} else {
					// Create a new Blob object using the response data of the onload object
					let blob = new Blob([this.response], {type: buttonObj.getAttribute("data-file-type")});
					//Create a link element, hide it, direct it towards the blob, and then 'click' it programatically
					let a = document.createElement("a");
					a.style = "display: none";
					document.body.appendChild(a);
					//Create a DOMString representing the blob and point the link element towards it
					let url = window.URL.createObjectURL(blob);
					a.href = url;
					a.download = buttonObj.getAttribute("data-file-name");
					//programatically click the link to trigger the download
					a.click();
					//release the reference to the file by revoking the Object URL
					window.URL.revokeObjectURL(url);
					
					//$('div.container div.upload_form_cont div.info').focus();
				}
				
				//Disable buttons
				$("#removeMetadata").prop("disabled",true);
				$("#customMetadata").prop("disabled",true);
				
            } else {
				$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.noServerResponse + '</div>');
            }
		};
    }

    // draw progress
    function drawProgress(progress) {
        return false;
        context.clearRect(0, 0, canvas.width, canvas.height); // clear context

        context.beginPath();
        context.strokeStyle = '#4B9500';
        context.fillStyle = '#4B9500';
        context.fillRect(0, 0, progress * 500, 20);
        context.closePath();

        // draw progress (as text)
        context.font = '16px Verdana';
        context.fillStyle = '#000';
        context.fillText('Progress: ' + Math.floor(progress*100) + '%', 50, 15);
    }

    // drag over
    function handleDragOver(event) {
        event.stopPropagation();
        event.preventDefault();

        dropArea.className = 'hover';
    }
	
	// drag leave
    function handleDragLeave(event) {
        event.stopPropagation();
        event.preventDefault();

        dropArea.className = 'leave';
    }

    // drag drop
    function handleDrop(event) {
        event.stopPropagation();
        event.preventDefault();

        processFiles(event.dataTransfer.files);
    }
	
    // process bunch of files
    function processFiles(filelist) {
        totalSize = 0;
        totalProgress = 0;
		arrayTemplate = null;
        
        $("#mcwsmessageArea").empty();
        $("#mcwsresultsfilename").empty();
        $("#removeMetadata").parent().remove(); 
 
        //Borramos el contenido de todos los DIV de pestañas
        $("div#mcwsresults div.tab-content div.mc_tab_content").html('');
		
		/*Mostramos todas las pestañas
		$('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataDoc"]').attr('style', 'display: block;');
		$('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataEXIF"]').attr('style', 'display: block;');
		$('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataGPS"]').attr('style', 'display: block;');
		$('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataIPTC"]').attr('style', 'display: block;');
		$('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataXMP"]').attr('style', 'display: block;');
		$('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataDoc"]').tab('show');
		*/
		
        if (!filelist || !filelist.length || list.length) {
			dropArea.className = 'leave';
			
            return;
			
        } else if (filelist.length > 1) {
            dropArea.className = 'leave';
			$("div#mcwsmessageArea").html('<div class="alert alert-warning" role="alert">' + userMessage.multipleFilesUpload + '</div>');
            
			return;
			
        } else {
			let extensionFile = (filelist[0].name.split('.').length > 0) ? filelist[0].name.split('.').pop().toLowerCase() : '';
			
			if(extensionFile.length < 3 || supportedFormat.indexOf('.'+extensionFile) < 0) {
				dropArea.className = 'leave';
				
				$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.extensionFileNoSupported + ' <a href="#" onclick="$(\'.contrLeftDiv\').first().click();">' + userMessage.moreInfo + '</a></div>');
				$("div#mcwsresultsfilename").html('<div class="alert alert-secondary" role="alert">' + userMessage.fileName + ' ' + filelist[0].name + '</div>');
				
				return;
			}
		}
        
        for (let i = 0; i < filelist.length && i < 5; i++) {
            list.push(filelist[i]);
            totalSize += filelist[i].size;
        }
       
        uploadNext();
    }

    // on complete - start next file
    function handleComplete(size) {
        totalProgress += size;
        drawProgress(totalProgress / totalSize);
        uploadNext();
    }

    // update progress
    function handleProgress(event) {
        let progress = totalProgress + event.loaded;
        drawProgress(progress / totalSize);
    }

    // upload file
    function uploadFile(file, status) {
        // prepare XMLHttpRequest
        let xhr = new XMLHttpRequest();
        xhr.overrideMimeType("application/json");
        
        xhr.open('POST', metacleanUrl + '/service/json');
        
        xhr.onload = function() {
            handleComplete(file.size);
            
            if (this.status == 200) {
                let jsonResponse = JSON.parse(this.responseText); 
				
					// Get the raw header string
					//const headers = xhr.getAllResponseHeaders();

					// Convert the header string into an array of individual headers
					//const arr = headers.trim().split(/[\r\n]+/);
				
                    for (let i=0;i<jsonResponse.length;i++) {
                        let obj = jsonResponse[i];
						let extension = '.' + file.name.split('.').pop().toLowerCase();
						
						let mmExtension = allMultiMediaSupportFormat.split(",").map(function(item) {
                            return item.trim();
                        });
						
                        let fileType = (mmExtension.includes(extension) || compressedExtension.includes(extension))?"file":"document";
						
						$("div#mcwsresultsfilename").html('<div class="alert alert-secondary" role="alert">' + userMessage.fileName + ' ' + file.name + ' (' + formatBytes(file.size) + ')</div>');
						
                        if (obj == null) {
                            break;
							
						} else if(obj.msgError.toString().length > 0) {
							$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + obj.msgError + '</div>');
							
							break;
							
                        } else if(Object.keys(obj.DOCUMENT).length === 0 && Object.keys(obj.EXIF).length === 0 && Object.keys(obj.IPTC).length === 0 && Object.keys(obj.GPS).length === 0 && Object.keys(obj.XMP).length === 0) {
								
							if(compressedExtension.includes(extension))
								$("div#mcwsmessageArea").html('<div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.compressedFiles + '</div>');
							else
								$("div#mcwsmessageArea").html('<div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.noMetadataFile.replace("XXX", fileType) + '</div>');
                        }
						
						if(obj.serverURL != null && obj.serverURL.toLowerCase().startsWith("http") && false) {
							const urlResponse = new URL(obj.serverURL);
							metacleanServerUrl = urlResponse.protocol + "//" + urlResponse.host;
						} else
							metacleanServerUrl = null;
						
						$('div#mcwsresults div.tab-content').append('<div class="action_area"><button type="button" id="removeMetadata" class="btn btn-info" data-file-id="' + obj.dataFileId + '" data-file-name="' + obj.dataFileName + '" data-file-type="' + obj.dataFileType + '">' + userMessage.cleanMetadataButton + '</button></div>');
						
                        //document.getElementById('removeMetadata').addEventListener('click', removeMetadataFile, false);
						
                        if(obj.DOCUMENT) {
                            let contenido = compressedExtension.includes(extension)?obj.msgOut.toString():"";

							if(fileType == "document") {
								if(microsoftExtension.includes(extension))
									arrayTemplate = microsoftOfficeTemplate;
								else if(openOfficeExtension.includes(extension))
									arrayTemplate = openOfficeTemplate;
								else
									arrayTemplate = pdfTemplate;
							}
							
                            Object.keys(obj.DOCUMENT).forEach(function (item) {
								if(obj.DOCUMENT[item].length == 0) {
									return;
									
								} else if(item === "pdfSigned" && false) {
									$("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.pdfSigned + '</div>');
							
								} else if(item.toLowerCase().endsWith("custom properties")) {
									let custom_prop = "";
									
									Object.keys(obj.DOCUMENT[item]).forEach(function (elem) {
										custom_prop += elem + "=" + obj.DOCUMENT[item][elem] + "; ";
									});
									
									if(custom_prop.length > 2)
										contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta">' + item + '<div><button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></div></div><div class="mcws-valuemeta" contenteditable="true">' + custom_prop.substring(0, custom_prop.lastIndexOf(";")) + '</div></div>';
									
								} else if(item.toLowerCase().endsWith("date")) {
									contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta">' + item + '<div><button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></div></div><div class="mcws-valuemeta dateField" contenteditable="true">' + obj.DOCUMENT[item] + '</div></div>';
									
								} else if(item.toLowerCase().endsWith("revision number") || item.toLowerCase().endsWith("edition time")) {
									/*
									if(obj.DOCUMENT[item] == 0)
										contenido += '&nbsp;';
									else
									*/
										contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta">' + item + '<div><button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></div></div><div class="mcws-valuemeta numberField" contenteditable="true">' + obj.DOCUMENT[item] + '</div></div>';
									
								} else {
										contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta">' + item + '<div><button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></div></div><div class="mcws-valuemeta" contenteditable="true">' + obj.DOCUMENT[item] + '</div></div>';
								}
                            });

                            //Añadimos el contenido
                            $("div#mcwsresults div.tab-content div#metadataDoc.container.tab-pane div.mc_tab_content").html(contenido);
							
                            if(contenido.trim().length > 0 || fileType == "document") {
                                //Ponemos visible la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataDoc"]').attr('style', 'display: block;');

                                //Hacemos click sobre el boton
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataDoc"]').tab('show');
								
								if(contenido.trim().length === 0)
									$("div#mcwsmessageArea").html('<div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.noMetadataFile.replace("XXX", fileType) + '</div>');
								
								$('<button type="button" id="customMetadata" class="btn btn-info" style="left: 1.0em; visibility: hidden;" data-file-id="' + obj.dataFileId + '" data-file-name="' + obj.dataFileName + '" data-file-type="' + obj.dataFileType + '">' + userMessage.customMetadataButton + '</button>').insertAfter("#removeMetadata");
								
								//Añadimos la opcion para añadir la plantilla de metadatos
								$('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataDoc"]').html(userMessage.tabMetadataDocument + " <i class='fas fa-list'></i>");

                            } else {
                                //Ocultamos la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataDoc"]').attr('style', 'display: none;');
                            }
                        }

                        if(obj.EXIF) {
                            let contenido = '';

                            Object.keys(obj.EXIF).forEach(function (item) {
                                contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta-mmf">' + item + ':</div><div class="mcws-valuemeta-mmf" contenteditable="false">' + obj.EXIF[item] + '</div></div>';
                            });

                            //Añadimos el contenido
                            $("div#mcwsresults div.tab-content div#metadataEXIF.container.tab-pane div.mc_tab_content").html(contenido);
							
                            if(contenido.trim().length > 0) {
                                //Ponemos visible la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataEXIF"]').attr('style', 'display: block;');

                                //Hacemos click sobre el boton
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataEXIF"]').tab('show');

                            } else {
                                //Ocultamos la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataEXIF"]').attr('style', 'display: none;');
                            }
                        }

                        if(obj.GPS) {
                            let contenido = '';

                            Object.keys(obj.GPS).forEach(function (item) {
                                contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta-mmf">' + item + ':</div><div class="mcws-valuemeta-mmf" contenteditable="false">' + obj.GPS[item] + '</div></div>';
                            });

                            //Añadimos el contenido
                            $("div#mcwsresults div.tab-content div#metadataGPS.container.tab-pane div.mc_tab_content").html(contenido);
							
                            if(contenido.trim().length > 0) {
                                //Ponemos visible la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataGPS"]').attr('style', 'display: block;');

                            } else {
                                //Ocultamos la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataGPS"]').attr('style', 'display: none;');
                            }
                        }

                        if(obj.IPTC) {
                            let contenido = '';

                            Object.keys(obj.IPTC).forEach(function (item) {
                                contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta-mmf">' + item + ':</div><div class="mcws-valuemeta-mmf" contenteditable="false">' + obj.IPTC[item] + '</div></div>';
                            });

                            //Añadimos el contenido
                            $("div#mcwsresults div.tab-content div#metadataIPTC.container.tab-pane div.mc_tab_content").html(contenido);
							
                            if(contenido.trim().length > 0) {
                                //Ponemos visible la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataIPTC"]').attr('style', 'display: block;');

                            } else {
                                //Ocultamos la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataIPTC"]').attr('style', 'display: none;');
                            }
                        }

                        if(obj.XMP) {
                            let contenido = '';

                            Object.keys(obj.XMP).forEach(function (item) {
                                contenido += '<div class="mcws-input mcws-textfield"><div class="mcws-keymeta-mmf">' + item + ':</div><div class="mcws-valuemeta-mmf" contenteditable="false">' + obj.XMP[item] + '</div></div>';
                            });

                            //Añadimos el contenido
                            $("div#mcwsresults div.tab-content div#metadataXMP.container.tab-pane div.mc_tab_content").html(contenido);
							
                            if(contenido.trim().length > 0) {
                                //Ponemos visible la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataXMP"]').attr('style', 'display: block;');

                            } else {
                                //Ocultamos la pestaña
                                $('div#mcwsresults ul.nav.nav-tabs li.nav-item a[href="#metadataXMP"]').attr('style', 'display: none;');
                            }
                        }
                    }
                
            } else if(this.status == 404) {
                $("div#mcwsmessageArea").html('<div class="alert alert-warning" role="alert">' + this.responseText + '</div>');
                $("div#mcwsresultsfilename").html('<div class="alert alert-secondary" role="alert">' + userMessage.fileName + ' ' + file.name + '</div>');
            }
            
            if(canvas != null)
                canvas.style.display = "none"; 
        };
        
        xhr.onerror = function() {
            $("div#mcwsmessageArea").html('<div class="alert alert-danger" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + (this.responseText.length > 0 ? this.responseText : userMessage.noServerResponse) + '</div>');
            handleComplete(file.size);
        };
        
        xhr.upload.onprogress = function(event) {
            handleProgress(event);
        };
        
        xhr.upload.onloadstart = function(event) {
            if(canvas != null)
                canvas.style.display = "block"; 
        };

        // prepare FormData
        let formData = new FormData();
		formData.append('appName', 'MetaCleanForWebApp splcenter.org');
		formData.append('licenseType', 'splcenter.org');
        formData.append('fileToProcess', file); 
        xhr.send(formData);
    }

    // upload next file
    function uploadNext() {
        if (list.length) {
           // count.textContent = list.length - 1;
            dropArea.className = 'uploading';

			let imgLoading = document.createElement('img');
            imgLoading.src = 'images/wsmetaclean_loading.gif';
			imgLoading.style.zIndex = 1000;
			imgLoading.style.width = '100px';
			imgLoading.style.position = 'fixed';
			imgLoading.setAttribute('id','imgLoadingGif');
			
            dropArea.appendChild(imgLoading);
			
            let nextFile = list.shift();
            if (nextFile.size >= maxFileSizeBytes) {
                $("div#mcwsmessageArea").html('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert">&times;</button>' + userMessage.fileExcedsMaxAllowed.replace("XXX", formatBytes(nextFile.size, 2)).replace("YYY", formatBytes(maxFileSizeBytes, 2)) + '</div>');
                $("div#mcwsresultsfilename").html('<div class="alert alert-secondary" role="alert">' + userMessage.fileName + ' ' + nextFile.name + '</div>');
                
                handleComplete(nextFile.size);  
                
            } else {
                uploadFile(nextFile, status);
            }
            
        } else {
            dropArea.className = '';
			document.getElementById('imgLoadingGif').remove();
        }
    }

    function formatBytes(bytes, decimals = 2) {
        if (bytes === 0) return '0 Bytes';

        let k = 1024;
        let dm = decimals < 0 ? 0 : decimals;
        let sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];

        let i = Math.floor(Math.log(bytes) / Math.log(k));

        return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
    }
	
	function getDomain(url, subdomain) {
		subdomain = subdomain || false;

		url = url.replace(/(https?:\/\/)?(www.)?/i, '');

		if (!subdomain) {
			url = url.split('.');
			url = url.slice(url.length - 2).join('.');
		}

		if (url.indexOf('/') !== -1) {
			return url.split('/')[0];
		}

		return url;
	}

	function getWebServiceUrl() {
		return new Promise(resolve => {
			try {
				let emailDomain = document.referrer;
				metacleanUrl = '';
				
				if(emailDomain == null || emailDomain.length < 5) {
					resolve('Usuario no valido: ' + emailDomain);
					
				} else {
					//emailDomain.split('/')[2]
					let formData = new FormData();
					console.log('Dominio :::: ' + getDomain(emailDomain, true) + " --- :::: " + emailDomain.split('/')[2]);
					
					formData.append('urlWebServiceFromClient', emailDomain.split('/')[2]);
										
					fetch('https://www.adarsus.com/bat/emailExtension/activation.php', {
						method: 'POST',
						headers: { 'cache-control': 'no-cache' },
						body: formData
					}).then(response => {
						if (response.ok) {
							response.text()
								.then(responseText => {
									if(responseText.length > 0) {
										if(responseText.startsWith("http"))
											metacleanUrl = responseText;
										else if(!responseText.includes("not found"))
											metacleanUrl = '';
									}
																
									resolve(metacleanUrl);
														
								}).catch((error) => { resolve("No se han podido obtener el texto de la respuesta :::: " + error.message) });
														
						} else 
							resolve('response no devuelve OK :::: ' + response.message);
										
					}).catch((error) => { resolve("Excepcion en la salida fetch :::: " + error.message) });
				}
				
			} catch(error) {
				resolve("Error en la ejecucion Promise :::: " + error.message)
			}
		});
	}
	
    getLanguage();
    
})();