<?php
header('Content-Type: text/html; charset=UTF-8');
	
class activation_class {
    
	var $fields = array();          
	var $idioma = array();
	
   function activation_class() {
      
      if (!empty($_POST['lang']) && $_POST['lang'] == "es-ES")
      	$this->idioma = parse_ini_file('../../../home/s149bf90/databaseaccess/es-ES.ini');
      else
      	$this->idioma = parse_ini_file('../../../home/s149bf90/databaseaccess/en-GB.ini');
      	
      $settings = parse_ini_file('../../../home/s149bf90/databaseaccess/mysqlConnection.ini');
	 
      $this->username = $settings['username'];
      $this->password = $settings['password'];
      $this->database = $settings['database'];
      $this->hostname = $settings['hostname'];
      $this->secret_key = $settings['secret_key'];
      $this->iv = $settings['iv'];
	  $this->cipher = $settings['cipher'];
	  $this->cipher_len = $settings['cipher_len'];
   }
   
   function getEmailProperties() {		
		try {			
			$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
			 
			if (mysqli_connect_errno()) {
				printf("Falló la conexión: %s\n", mysqli_connect_error());
				exit();
			}	
			 
			if (!mysqli_set_charset($connection, "utf8")) {
				printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
				exit();
			}
						
			/////////////////////// PREVENIR SQL INJECTION MEDIANTE PREPARE STATEMENT /////////////////////////////
			$clientDomainName = $this->fields["getEmailProperties"];
			
			if (strpos($clientDomainName, '@') !== false)
				$clientDomainName = substr($clientDomainName, strpos($clientDomainName, '@') + 1);
			
			$clientDomainName = "%$clientDomainName%"; // prepare the $clientDomainName variable 
			
			$cadena = $connection->prepare('select URL_Web_Service, URL_Dashboard, PuedeCambiarConfig, SelecFicherosProcesar from wp_clientesCorporativos where Nombre_Dominio LIKE ? and LENGTH(URL_Web_Service) > 0 LIMIT 1');
			$cadena->bind_param("s", $clientDomainName); // "s" specifies the variable type => 'string'
			$cadena->execute();

			$result = $cadena->get_result();
			$data = $result->fetch_all( MYSQLI_ASSOC );

			////////////////////////////////////////////////////////////////////////////////////////
			
			if($cadena != null)
				mysqli_free_result($cadena);
		
			if(strpos($this->fields["getEmailProperties"], '@') !== false) {
				//Insertamos la direccion de email en la tabla: wp_cuentasEmail		
				$cadena = $connection->prepare('INSERT INTO wp_cuentasEmail (email,tipo_aplicacion) VALUES(?,?) ON DUPLICATE KEY UPDATE fecha_login=now()');
				$cadena->bind_param("si", $this->fields["getEmailProperties"],$this->fields["tipoApp"]); // "s" specifies the variable type => 'string', "i" variable de tipo int
				$cadena->execute();
				
				if($cadena != null)
					mysqli_free_result($cadena);
			}
			
			if($connection != null)
				mysqli_close($connection);
		
		} catch (Exception $exception) {			
			error_log(date("Y-m-d H:i:s") . " :::: Ha ocurrido el siguiente error --> " . $exception->getMessage(), 3, "./my-errors.log");
		}
		
		return json_encode( $data );
	}
   
	function getWebServiceURL() {
		$urlWebService = "";
		$urlDashboard = "";
		
		try {			
			$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
			 
			if (mysqli_connect_errno()) {
				printf("Falló la conexión: %s\n", mysqli_connect_error());
				exit();
			}	
			 
			if (!mysqli_set_charset($connection, "utf8")) {
				printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
				exit();
			}
			
			/*
			$clientDomainName = "'%" . mysqli_real_escape_string($connection, $this->fields["clientDomainName"]) . "%'";
			
			//execute the SQL query and return records
			$cadena = mysqli_query($connection, "select URL_Web_Service from wp_clientesCorporativos where Nombre_Dominio like $clientDomainName and LENGTH(URL_Web_Service) > 0 LIMIT 1") or die("Error en la consulta de la URL del WebService " . mysqli_error($connection));
					
			//fetch tha data from the database
			while ($row = mysqli_fetch_array($cadena)) {
				$urlWebService = $row[0];
			}
			*/
			
			/////////////////////// PREVENIR SQL INJECTION MEDIANTE PREPARE STATEMENT /////////////////////////////
			$clientDomainName = $this->fields["clientDomainName"];
			
			if (strpos($clientDomainName, '@') !== false)
				$clientDomainName = substr($clientDomainName, strpos($clientDomainName, '@') + 1);
			
			$clientDomainName = "%$clientDomainName%"; // prepare the $clientDomainName variable 
			
			$cadena = $connection->prepare('select URL_Web_Service, URL_Dashboard from wp_clientesCorporativos where Nombre_Dominio LIKE ? and LENGTH(URL_Web_Service) > 0 LIMIT 1');
			$cadena->bind_param("s", $clientDomainName); // "s" specifies the variable type => 'string'
			$cadena->execute();

			$result = $cadena->get_result();
			while ($row = $result->fetch_assoc()) {
				$urlWebService = $row['URL_Web_Service'];
				$urlDashboard = $row['URL_Dashboard'];
			}
			////////////////////////////////////////////////////////////////////////////////////////
			
			if($cadena != null)
				mysqli_free_result($cadena);
		
			if(strpos($this->fields["clientDomainName"], '@') !== false) {
				//Insertamos la direccion de email en la tabla: wp_cuentasEmail		
				$cadena = $connection->prepare('INSERT INTO wp_cuentasEmail (email,tipo_aplicacion) VALUES(?,?) ON DUPLICATE KEY UPDATE fecha_login=now()');
				$cadena->bind_param("si", $this->fields["clientDomainName"],$this->fields["tipoApp"]); // "s" specifies the variable type => 'string', "i" variable de tipo int
				$cadena->execute();
				
				if($cadena != null)
					mysqli_free_result($cadena);
			}
			
			if($connection != null)
				mysqli_close($connection);
		
		} catch (Exception $exception) {			
			error_log(date("Y-m-d H:i:s") . " :::: Ha ocurrido el siguiente error --> " . $exception->getMessage(), 3, "./my-errors.log");
		}
		
		if(!empty($urlDashboard) && strlen($urlDashboard) > 10) {
			$urlWebService = $urlWebService . "@@@" . $urlDashboard;
		}


		return $urlWebService;
	}
	
	function getWebServiceURL_Manual() {
		$urlWebService = "Client not found";

		$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
		 
		if (mysqli_connect_errno()) {
			printf("Falló la conexión: %s\n", mysqli_connect_error());
			exit();
		}	
		 
		if (!mysqli_set_charset($connection, "utf8")) {
			printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
			exit();
		}
		
		/////////////////////// PREVENIR SQL INJECTION MEDIANTE PREPARE STATEMENT /////////////////////////////
		$clientName = $this->fields["urlWebServiceClientName"];
		$clientDomain = $this->fields["urlWebServiceClientDomain"];
		
		$cadena = $connection->prepare('select URL_Web_Service from wp_clientesCorporativos where Nombre_Dominio = ? and Nombre_Cliente = ? and LENGTH(URL_Web_Service) > 0 LIMIT 1');
		$cadena->bind_param('ss', $clientDomain, $clientName); // 's' specifies the variable type => 'string'
		$cadena->execute();

		$result = $cadena->get_result();
		while ($row = $result->fetch_assoc()) {
			$urlWebService = $row['URL_Web_Service'];
		}
		/////////////////////////////////////////////////////////////////////////////////
		
		if($cadena != null)
			mysqli_free_result($cadena);
		
		if($connection != null)
			mysqli_close($connection);
		
		return $urlWebService;
	}

   function add_field($field, $value) {
		$this->fields["$field"] = $value;
	}
   
   function check_input($connection, $value)	{
		// Stripslashes
		if (get_magic_quotes_gpc())	{
			$value = stripslashes($value);
		}
		// Quote if not a number
		if (!is_numeric($value)) {
			$value = "'" . mysqli_real_escape_string($connection, $value) . "'";
		}
			
		return $value;
	}
   
 }
?>