﻿<?php
header('Content-Type: text/html; charset=UTF-8');
	
class activation_class {
    
	var $fields = array();          
	var $idioma = array();
	
   function activation_class() {
      
      if (!empty($_POST['lang']) && $_POST['lang'] == "es-ES")
      	$this->idioma = parse_ini_file('../../home/s149bf90/databaseaccess/es-ES.ini');
      else
      	$this->idioma = parse_ini_file('../../home/s149bf90/databaseaccess/en-GB.ini');
      	
      $settings = parse_ini_file('../../home/s149bf90/databaseaccess/mysqlConnection.ini');
	 
      $this->username = $settings['username'];
      $this->password = $settings['password'];
      $this->database = $settings['database'];
      $this->hostname = $settings['hostname'];
      $this->secret_key = $settings['secret_key'];
      $this->iv = $settings['iv'];
	  $this->cipher = $settings['cipher'];
	  $this->cipher_len = $settings['cipher_len'];
   }
   
   function update_bbdd() {
     	$resultSQL = "";
     	$count = 0;
     	$transaccion = "";
     	$precio = "";
     	$cod_activacion = "";
     	$producto = 0;
     	$equipoRegistrado = "";
     	$suscripcion = "";
		$cod_activacionNew = "";
		$timestampLicencia = "";
		
			$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
			
			/* verificar la conexión */
			if (mysqli_connect_errno()) {
				printf("Falló la conexión: %s\n", mysqli_connect_error());
				exit();
			}
			
			/* cambiar el conjunto de caracteres a utf8 */
			if (!mysqli_set_charset($connection, "utf8")) {
				printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
				exit();
			}
			
			$txn_id = $this->check_input($connection, $this->fields["txn_id"]);
			$codigoActivacion = mysqli_real_escape_string($connection, $this->fields["codVerificacion"]);
			$plataforma = $this->check_input($connection, $this->fields["plataforma"]);
			
			//execute the SQL query and return records
			$cadena = mysqli_query($connection, "select count(*), hora, transaccion, precio, cod_activacion, Tipo_Licencia, producto, equipo from wp_ventas where txn_id = $txn_id") or die("Error en la actualizacion del registro " . mysqli_error($connection));
			
			//fetch tha data from the database
			while ($row = mysqli_fetch_array($cadena)) {
				$transaccion = $row{'transaccion'};
		    	$precio = $row{'precio'};
		    	$cod_activacion = $row{'cod_activacion'};
		    	$suscripcion = $row{'Tipo_Licencia'};
		    	$producto = $row{'producto'};
			  	$count = $row[0];
			  	$equipoRegistrado = $row{'equipo'};
				$timestampLicencia = $row{'hora'};
			}
		
			if($count > 0) {
				if($count < 2) {
					if (strcasecmp($transaccion, "Completed") == 0) {
					//if($transaccion === "Completed") {
							
						if(strlen($cod_activacion) > 1) {
							//Ya registr񟤬 producto anteriormente. No permitir generar nueva clave si ya hay un registro hecho,
							//provocaria que con un $txn_id correcto obtengan "n" codigos de activacion.
																					
							if($equipoRegistrado === $codigoActivacion)
								$resultSQL = $cod_activacion;
							else 
								$resultSQL = $this->idioma['activacionRegistrada'];
								
						} else if ($producto > 0 && floatval($precio) > 0) {//Primer registro del producto
							//Comprobamos si para el mismo equipo tiene otros productos registrados (PDF + MicroSoft Office).
							$parametro = $this->check_input($connection, $codigoActivacion);
							$productosComprados = $producto;
							
							if(strlen($productosComprados) < 2)
								$productosComprados = "0".$productosComprados;
								
							if(strcasecmp($suscripcion, "suscripcion") == 0) {
								$phpdate = strtotime( $timestampLicencia );
								$mysqldate = date( 'Y-m-d', $phpdate );

								//gyBR470SztKxAwPbNTD6n4D/cJi3V4NM122020-08-2699
								//$suscripcion = date('Y-m-d', strtotime('+1 years'))."99";
								$suscripcion = date('Y-m-d', strtotime($mysqldate. '+1 years'))."99";
								
							} else
								$suscripcion = "";
									
							$cadenaEncriptar = $codigoActivacion.$productosComprados.$suscripcion;
							$cod_activacionNew = $this->encrypt($cadenaEncriptar);
							
							//Comprobamos que el MetaCleanID tiene un formato correcto
							$metaCleanID = $this->decrypt($codigoActivacion);
							
							if(strlen($cod_activacionNew) > 10 && strlen($metaCleanID) > 0) {
								$cod_activacionEsc = $this->check_input($connection, $cod_activacionNew);
								$equipo = $this->check_input($connection, $codigoActivacion);
								
								$consulta = "update wp_ventas set cod_activacion = $cod_activacionEsc, equipo = $equipo, plataforma = $plataforma where txn_id = $txn_id";
								$estado = mysqli_query($connection, $consulta) or die("Error en la actualizacion del registro " . mysqli_error($connection));
			
								if($estado > 0) {
									//$resultSQL = $cadenaEncriptar;
									$resultSQL = $cod_activacionNew;
								} else {
									$resultSQL = $this->idioma['activacionErrorRegistro'];
								}
								
								/* liberar la serie de resultados */
								mysqli_free_result($estado);
			
							} else {
								$resultSQL = $this->idioma['activacionMalGenerado'];
							}
							
						} else {
							if(floatval($precio) > 0)
								$resultSQL = $this->idioma['activacionProductoNoIdentificado'];
							else
								$resultSQL = $this->idioma['activacionErrorPrecio'];
						}
							
					} else {
						$resultSQL = $this->idioma['activacionErrorProcesoPago'];
					}
				} else {
					$resultSQL = $this->idioma['activacionRegistrosDuplicados'];
				}
			} else { //No existe el codigo txn_id
				$resultSQL = $this->idioma['activacionTransaccionNoEncontrada'];
			}
			
			/* liberar la serie de resultados */
			mysqli_free_result($cadena);

			/* cerrar la conexión */
			mysqli_close($connection);
			
			return $resultSQL;
	}

	function getWebServiceURL() {
		$urlWebService = "No existe cliente";

		$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
		 
		if (mysqli_connect_errno()) {
			printf("Falló la conexión: %s\n", mysqli_connect_error());
			exit();
		}	
		 
		if (!mysqli_set_charset($connection, "utf8")) {
			printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
			exit();
		}
		
		$clientDomainName = "'%" . mysqli_real_escape_string($connection, $this->fields["clientDomainName"]) . "%'";
		
		//execute the SQL query and return records
		$cadena = mysqli_query($connection, "select URL_Web_Service from wp_clientesCorporativos where Nombre_Dominio like $clientDomainName and LENGTH(URL_Web_Service) > 0 LIMIT 1") or die("Error en la consulta de la URL del WebService " . mysqli_error($connection));
				
		//fetch tha data from the database
		while ($row = mysqli_fetch_array($cadena)) {
			$urlWebService = $row[0];
		}
		
		if($cadena != null)
			mysqli_free_result($cadena);
		
		if($connection != null)
			mysqli_close($connection);
		
		return $urlWebService;
	}
	
	function getEvidencias_microCeENS() {
		$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
		 
		if (mysqli_connect_errno()) {
			printf("Falló la conexión: %s\n", mysqli_connect_error());
			exit();
		}	
		 
		if (!mysqli_set_charset($connection, "utf8")) {
			printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
			exit();
		}
		
		$DIR3 = $this->check_input($connection, $this->fields["DIR3"]); 
		$fecha_inicio = $this->check_input($connection, $this->fields["fecha_inicio"]); 
		$fecha_fin = $this->check_input($connection, $this->fields["fecha_fin"]); 
		
		//execute the SQL query and return records
		$cadena = mysqli_query($connection, "select Fecha_Procesamiento, Nombre_Usuario_PC as Email_Usuario, Fichero_Procesado, Resultado_Procesamiento, Nombre_Aplicacion from wp_microCeENS_registroActividad where ID_Organismo like $DIR3 AND Fecha_Procesamiento BETWEEN $fecha_inicio AND $fecha_fin ORDER BY Fecha_Procesamiento DESC") or die("Error en la consulta de Evidencias MicroCeENS " . mysqli_error($connection));
				
		$data = [];
		
		//fetch tha data from the database
		while ($row = mysqli_fetch_assoc($cadena)) {
			$data[] = $row;
		}
		
		if($cadena != null)
			mysqli_free_result($cadena);
		
		if($connection != null)
			mysqli_close($connection);
		
		//$query = "select Fecha_Procesamiento, Nombre_Usuario_PC as Email_Usuario, Fichero_Procesado, Resultado_Procesamiento, Nombre_Aplicacion from wp_microCeENS_registroActividad where ID_Organismo like $DIR3 AND Fecha_Procesamiento BETWEEN $fecha_inicio AND $fecha_fin ORDER BY Fecha_Procesamiento DESC";
		//return $query;
		return json_encode($data, JSON_UNESCAPED_UNICODE);
	}

	function insert_microCeENS() {
		$resultSQL = "CampoNoInicializado";
		
		$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
		 
		if (mysqli_connect_errno()) {
			printf("Falló la conexión: %s\n", mysqli_connect_error());
			exit();
		}	
		 
		if (!mysqli_set_charset($connection, "utf8")) {
			printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
			exit();
		}
		
		$Nombre_Usuario_PC = $this->check_input($connection, $this->fields["Nombre_Usuario_PC"]);
		$ID_Organismo = $this->check_input($connection, $this->fields["ID_Organismo"]); 
		$Fichero_Procesado = $this->check_input($connection, $this->fields["Fichero_Procesado"]);
		$Resultado_Procesamiento = $this->check_input($connection, $this->fields["Resultado_Procesamiento"]);
		$Politica_Metadatos = $this->check_input($connection, $this->fields["Politica_Metadatos"]);
		$Nombre_Aplicacion = $this->check_input($connection, $this->fields["Nombre_Aplicacion"]);

		$consulta = "INSERT INTO wp_microCeENS_registroActividad (Nombre_Usuario_PC, ID_Organismo, Fichero_Procesado, Resultado_Procesamiento, Politica_Metadatos, Nombre_Aplicacion) VALUES ($Nombre_Usuario_PC, $ID_Organismo, $Fichero_Procesado, $Resultado_Procesamiento, $Politica_Metadatos, $Nombre_Aplicacion)";
		$estado = mysqli_query($connection, $consulta) or die("Error en la insercion de Evidencias MicroCeENS :::: " . mysqli_error($connection));
										
		if($estado > 0)
			$resultSQL = "Correcto";
		else
			$resultSQL = "ErrorInsercion";
			
		mysqli_free_result($estado);
				
		if($connection != null)
			mysqli_close($connection);
		
		return $resultSQL;
	}

	function registraLicenciasCorporativas() {
		$resultSQL = "CampoNoInicializado";
		$licenciasDisponibles = 0;
		$licenciasAdquiridas = 0;
		$licenciasRegistradas = 0;
		$licenciaRegistradaPreviamente = 0;
		$fechaFinSuscripcion = "";

		$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
		 
		if (mysqli_connect_errno()) {
			printf("Falló la conexión: %s\n", mysqli_connect_error());
			exit();
		}	
		 
		if (!mysqli_set_charset($connection, "utf8")) {
			printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
			exit();
		}
		
		$metacleanID = $this->check_input($connection, $this->fields["metacleanID"]); 
		$PC_Name = $this->check_input($connection, $this->fields["PC_Name"]);
		$userName = $this->check_input($connection, $this->fields["userName"]);
		$cliente = $this->check_input($connection, $this->fields["cliente"]);
		$producto = $this->check_input($connection, $this->fields["producto"]);

		//$consulta = "select Numero_Licencias from clientesCorporativos where Nombre_Cliente = $cliente and Tipo_Licencia = $producto";
		//execute the SQL query and return records
		$cadena = mysqli_query($connection, "select Numero_Licencias, Fecha_Fin_Suscripcion from wp_clientesCorporativos where Nombre_Cliente = $cliente and Tipo_Licencia = $producto") or die("Error en la actualizacion del registro " . mysqli_error($connection));
				
		//fetch tha data from the database
		while ($row = mysqli_fetch_array($cadena)) {
			$licenciasAdquiridas = $row['Numero_Licencias'];
			$fechaFinSuscripcion = $row['Fecha_Fin_Suscripcion'];
		}
		
		if($licenciasAdquiridas == 0) {
			//Comprobamos si existe el cliente pero no existe el producto para ese cliente
			$cadena = mysqli_query($connection, "select count(*) from wp_clientesCorporativos where Nombre_Cliente = $cliente") or die("Error en la consulta del registro " . mysqli_error($connection));
					
			//fetch tha data from the database
			while ($row = mysqli_fetch_array($cadena)) {
				$licenciaRegistradaPreviamente = $row[0];
			}
			
			if($licenciaRegistradaPreviamente == 0)
				$resultSQL = "NoExisteCliente";
			else {
				$resultSQL = "There is no product: ". $producto . " for the customer: " . $cliente;
				$licenciaRegistradaPreviamente = 0;
			}
			
			mysqli_free_result($cadena);
			
		} else {
			//Verificamos si para el mismo Cliente, mismo nombre de producto y mismo MetaCleanID ya se ha registrado la licencia anteriormente
			$cadena = mysqli_query($connection, "select count(*) from wp_licenciasCorporativas where MetaCleanID = $metacleanID and Nombre_Cliente = $cliente and Tipo_Licencia = $producto") or die("Error en la consulta del registro " . mysqli_error($connection));
					
			//fetch tha data from the database
			while ($row = mysqli_fetch_array($cadena)) {
				$licenciaRegistradaPreviamente = $row[0];
			}
			
			if($licenciaRegistradaPreviamente == 0) {
				//execute the SQL query and return records
				$cadena = mysqli_query($connection, "select count(*) from wp_licenciasCorporativas where Nombre_Cliente = $cliente and Tipo_Licencia = $producto") or die("Error en la consulta del registro " . mysqli_error($connection));
						
				//fetch tha data from the database
				while ($row = mysqli_fetch_array($cadena)) {
					$licenciasRegistradas = $row[0];
				}
				
				if($licenciasAdquiridas > 0 && $licenciasAdquiridas >= $licenciasRegistradas)
					$licenciasDisponibles = $licenciasAdquiridas - $licenciasRegistradas;
			}
		}
		
		if($licenciaRegistradaPreviamente > 0) {			
			$estado = mysqli_query($connection, "UPDATE wp_licenciasCorporativas set Fecha_Insercion=now() where MetaCleanID = $metacleanID and Nombre_Cliente = $cliente and Tipo_Licencia = $producto and Nombre_PC = $PC_Name") or die("Error en la actualizacion del registro " . mysqli_error($connection));
										
			$resultSQL = "Correcto".$fechaFinSuscripcion;
			
			mysqli_free_result($estado);
			
		} else if($licenciasDisponibles > 0) {
			$consulta = "INSERT INTO wp_licenciasCorporativas (Nombre_PC, Nombre_Usuario, MetaCleanID, Nombre_Cliente, Tipo_Licencia) VALUES ($PC_Name, $userName, $metacleanID, $cliente, $producto)";
			$estado = mysqli_query($connection, $consulta) or die("Error en la actualizacion del registro " . mysqli_error($connection));
										
			if($estado > 0)
				$resultSQL = "Correcto".$fechaFinSuscripcion;
			else
				$resultSQL = "ErrorInsercion";
			
			mysqli_free_result($estado);
			
		} else if($resultSQL == "CampoNoInicializado") {
			$resultSQL = "NumeroLicenciasExcedido";
		}
		
		if($cadena != null)
			mysqli_free_result($cadena);
		
		if($connection != null)
			mysqli_close($connection);
		
		return $resultSQL;
	}
   
	function actualiza_tabla_descargas() {
   		$resultSQL = "";
     	$count = 0;
     	$ndescargas = 0;
			
		$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
				
		 
		if (mysqli_connect_errno()) {
			printf("Falló la conexión: %s\n", mysqli_connect_error());
			exit();
		}
				
		 
		if (!mysqli_set_charset($connection, "utf8")) {
			printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
			exit();
		}
								
		$eMail = $this->check_input($connection, $this->fields["eMail"]); 
		$producto = $this->check_input($connection, $this->fields["producto"]);
		$idiomaDescarga = $this->check_input($connection, $this->fields["lang"]);
			
		if($this->fields["eMail"] != "anonimo") {
			//execute the SQL query and return records
			$cadena = mysqli_query($connection, "select count(*), ndescargas from descargas where email = $eMail and producto = $producto") or die("Error en la actualizacion del registro " . mysqli_error($connection));
				
			//fetch tha data from the database
			while ($row = mysqli_fetch_array($cadena)) {
				$count = $row[0];
				$ndescargas = $row{'ndescargas'};
			}
			
			mysqli_free_result($cadena);	
		}
			
		if($this->fields["download"] == "no") {
			if($count == 0) {
				$consulta = "INSERT INTO descargas (email, producto, idioma, ndescargas) VALUES ($eMail,$producto,$idiomaDescarga, 1)";
				$estado = mysqli_query($connection, $consulta) or die("Error en la actualizacion del registro " . mysqli_error($connection));
									
				if($estado > 0) {
					$resultSQL = "correcto";
				} else {
					$resultSQL = $this->idioma['mailDescargaErrorInesp'];
				}
					
				mysqli_free_result($estado);
					
			} else if($count > 0) {
				$ndescargas++;
				$consulta = "update descargas set ndescargas = $ndescargas, hora = now() where email = $eMail and producto = $producto";
				$estado = mysqli_query($connection, $consulta) or die("Error en la actualizacion del registro " . mysqli_error($connection));
					
				if($estado > 0) {
					$resultSQL = "correcto";
				} else {
					$resultSQL = $this->idioma['mailDescargaErrorInesp'];
				}
					
				mysqli_free_result($estado);
			}			
										
		} else if($count == 0 && $this->fields["download"] == "si") {
			$resultSQL = $this->idioma['mailDescargaValidacion'];
		}
					
		mysqli_close($connection);
			
		if($resultSQL == "correcto") {
			if (strpos(strtoupper($producto), 'METACLEANONECLICK') == TRUE) {					
				if (strpos(strtoupper($producto), 'JRE') == TRUE)
					$resultSQL = "downloads/WithJRE/MetaCleanOneClickJRE.zip";
				else
					$resultSQL = "downloads/MetaCleanOneClick.zip";						
					 					
			} else if (strpos(strtoupper($producto), 'METACLEANFOROUTLOOK') == TRUE) {					
				if (strpos(strtoupper($producto), 'JRE') == TRUE)
					$resultSQL = "downloads/WithJRE/MetaCleanForOutlookJRE.zip";
				else
					$resultSQL = "downloads/MetaCleanForOutlook.zip";						
					 					
			} else if (strpos(strtoupper($producto), 'METACLEANCOMMANDLINE') == TRUE) {
				if (strpos(strtoupper($producto), 'WINDOWS') == TRUE) {
					if (strpos(strtoupper($producto), 'JRE') == TRUE)
						$resultSQL = "downloads/WithJRE/MetaCleanCLWinJRE.zip";
					else
						$resultSQL = "downloads/MetaCleanCLWin.zip";
						
				} else {
					if (strpos(strtoupper($producto), 'JRE') == TRUE)
						$resultSQL = "downloads/WithJRE/MetaCleanCLJRE.zip";
					else
						$resultSQL = "downloads/MetaCleanCL.zip";
				}
					
			} else if (strpos(strtoupper($producto), 'WINDOWS') == TRUE) {
				if (strpos(strtoupper($producto), 'JRE') == TRUE)
					$resultSQL = "downloads/WithJRE/MetaCleanWinJRE.zip";
				else
					$resultSQL = "downloads/MetaCleanWin.zip";
						
			} else if (strpos(strtoupper($producto), 'OS X') == TRUE) {
				if (strpos(strtoupper($producto), 'JRE') == TRUE)
					$resultSQL = "downloads/WithJRE/MetaCleanJRE.dmg";
				else
					$resultSQL = "downloads/MetaClean.dmg";
						
			} else {
				if (strpos(strtoupper($producto), 'JRE') == TRUE)
					$resultSQL = "downloads/WithJRE/MetaCleanJRE.zip";
				else
					$resultSQL = "downloads/MetaClean.zip";
			}
		}
					
		return $resultSQL;
   }
   
   function compruebaMaildeCompra() {
   		$resultSQL = "error";
   		$transaccion = "";
   		$tipoLicencia = "";
   		$idLicenciaComprada = "";
     	$count = 0;
     	
			$connection = mysqli_connect($this->hostname, $this->username, $this->password, $this->database);
			
			 
			if (mysqli_connect_errno()) {
				printf("Falló la conexión: %s\n", mysqli_connect_error());
				exit();
			}
			
			 
			if (!mysqli_set_charset($connection, "utf8")) {
				printf("Error cargando el conjunto de caracteres utf8: %s\n", mysqli_error($connection));
				exit();
			}
								
			$eMail = $this->check_input($connection, $this->fields["eMail"]); 
					
			//execute the SQL query and return records
			$cadena = mysqli_query($connection, "select count(*), txn_id, producto from wp_ventas where email = $eMail and precio > 1 and CHAR_LENGTH(cod_activacion) = 0 LIMIT 1") or die("Error en la actualizacion del registro " . mysqli_error($connection));
			$ndescargas = 0;
			
			//fetch tha data from the database
			while ($row = mysqli_fetch_array($cadena)) {
				$count = $row[0];
				$transaccion = $row{'txn_id'};
		    	$tipoLicencia = $row{'producto'};
			}
			
			mysqli_free_result($cadena);
		
			if($count == 0) {
				$resultSQL = "error";
					
			} else if($count > 0) {
			
				if ($tipoLicencia == "1") { //Licencia Microsoft Office + Open Office + PDF
					$idLicenciaComprada = "CMZ";
				} else if ($tipoLicencia == "2") {//Licencia Microsoft Office + Open Office
					$idLicenciaComprada = "ER6";
				} else if ($tipoLicencia == "3") {//Licencia Microsoft Office + PDF
					$idLicenciaComprada = "EEY";
				} else if ($tipoLicencia == "4") {//Licencia Open Office + PDF
					$idLicenciaComprada = "36R";
				} else if ($tipoLicencia == "5") {//Licencia Microsoft Office
					$idLicenciaComprada = "7SC";
				} else if ($tipoLicencia == "6") {//Licencia Open Office
					$idLicenciaComprada = "PKK";
				} else if ($tipoLicencia == "7") {//Licencia PDF
					$idLicenciaComprada = "S3D";
				} else if ($tipoLicencia == "8") {//Licencia Command Line
					$idLicenciaComprada = "S8Z";		
					
				} else if ($tipoLicencia == "9") { //Licencia OpenOffice + Multimedia
					$idLicenciaComprada = "AB1";
				} else if ($tipoLicencia == "10") { //Licencia PDF + Multimedia
					$idLicenciaComprada = "AB2";
				} else if ($tipoLicencia == "11") { //Licencia Multimedia
					$idLicenciaComprada = "AB3";
				} else if ($tipoLicencia == "12") { //Licencia FULL
					$idLicenciaComprada = "AB4";
				} else if ($tipoLicencia == "13") { //Licencia Microsoft Office + Open Office + Multimedia
					$idLicenciaComprada = "AB5";
				} else if ($tipoLicencia == "14") { //Licencia Microsoft Office + PDF + Multimedia
					$idLicenciaComprada = "AB6";
				} else if ($tipoLicencia == "15") { //Licencia OpenOffice + PDF + Multimedia
					$idLicenciaComprada = "AB7";
				} else if ($tipoLicencia == "16") { //Licencia Microsoft Office + Multimedia
					$idLicenciaComprada = "AB8";
				} else if ($tipoLicencia == "17") { //Licencia Outlook
					$idLicenciaComprada = "OUT";
				} else if ($tipoLicencia == "18") { //Licencia OneClick
					$idLicenciaComprada = "ONE";
				} else if ($tipoLicencia == "19") { //Licencia Web Server
					$idLicenciaComprada = "WEB";
				} else if ($tipoLicencia == "20") { //Licencia MetaClean Command Line Home Extended Edition
					$idLicenciaComprada = "CHE";
				}		
			
				$resultSQL = "&id=".$transaccion."&pid=".$idLicenciaComprada;
			}			
				
			mysqli_close($connection);
				
			return $resultSQL;
   }
   
   function add_field($field, $value) {
		$this->fields["$field"] = $value;
	}
   
   function check_input($connection, $value)	{
		// Stripslashes
		if (get_magic_quotes_gpc())	{
			$value = stripslashes($value);
		}
		// Quote if not a number
		if (!is_numeric($value)) {
			$value = "'" . mysqli_real_escape_string($connection, $value) . "'";
		}
			
		return $value;
	}
	
	/**
     * Encrypt data using AES Cipher (CBC) with 128 bit key
     * 
     * @param type $key - key to use should be 16 bytes long (128 bits)
     * @param type $iv - initialization vector
     * @param type $data - data to encrypt
     * @return encrypted data in base64 encoding with iv attached at end after a :
     */
	function encrypt($data) {
		$key = $this->secret_key; 
		$iv = $this->iv;
		$cipher = $this->cipher;
		$cipher_len = $this->cipher_len;
	  
		//echo "key: " .$key . " iv: " . $iv . " data: " . $data . " CIPHER_KEY_LEN: " . $cipher_len;
		
        if (strlen($key) < $cipher_len) {
            $key = str_pad("$key", $cipher_len, "0"); //0 pad to len 16
        } else if (strlen($key) > $cipher_len) {
            $key = substr($str, 0, $cipher_len); //truncate to 16 bytes
        }
		
        return base64_encode(openssl_encrypt($data, $cipher, $key, OPENSSL_RAW_DATA, $iv));
    }
	
	/**
     * Decrypt data using AES Cipher (CBC) with 128 bit key
     * 
     * @param type $key - key to use should be 16 bytes long (128 bits)
     * @param type $data - data to be decrypted in base64 encoding with iv attached at the end after a :
     * @return decrypted data
     */
    function decrypt($data) {
		$key = $this->secret_key; 
		$iv = $this->iv;
		$cipher = $this->cipher;
		$cipher_len = $this->cipher_len;
		
        if (strlen($key) < $cipher_len) {
            $key = str_pad("$key", $cipher_len, "0"); //0 pad to len 16
        } else if (strlen($key) > $cipher_len) {
            $key = substr($str, 0, $cipher_len); //truncate to 16 bytes
        }
		
        return openssl_decrypt(base64_decode($data), $cipher, $key, OPENSSL_RAW_DATA, base64_decode(base64_encode($iv)));
    }
	
	function decryptTokenMITM($data) {
		$key = '9.-i452Rt.-Lwrty';
		$iv = 'WeEr6-oPP785-g.f';
		$cipher = "aes-128-cbc";
		$cipher_len = 16;
		
        if (strlen($key) < $cipher_len) {
            $key = str_pad("$key", $cipher_len, "0"); //0 pad to len 16
        } else if (strlen($key) > $cipher_len) {
            $key = substr($str, 0, $cipher_len); //truncate to 16 bytes
        }
		
        return openssl_decrypt(base64_decode($data), $cipher, $key, OPENSSL_RAW_DATA, base64_decode(base64_encode($iv)));
    }
   
   function creaMail() {
   		$tipoLicencia = $this->ipn_data["custom"];
   		$producto = $this->ipn_data['item_name'];
   		$idLicenciaComprada = "";
   		
   		if ($tipoLicencia == "1") { //Licencia Microsoft Office + Open Office + PDF
				$idLicenciaComprada = "CMZ";
			} else if ($tipoLicencia == "2") {//Licencia Microsoft Office + Open Office
				$idLicenciaComprada = "ER6";
			} else if ($tipoLicencia == "3") {//Licencia Microsoft Office + PDF
				$idLicenciaComprada = "EEY";
			} else if ($tipoLicencia == "4") {//Licencia Open Office + PDF
				$idLicenciaComprada = "36R";
			} else if ($tipoLicencia == "5") {//Licencia Microsoft Office
				$idLicenciaComprada = "7SC";
			} else if ($tipoLicencia == "6") {//Licencia Open Office
				$idLicenciaComprada = "PKK";
			} else if ($tipoLicencia == "7") {//Licencia PDF
				$idLicenciaComprada = "S3D";
			} else if ($tipoLicencia == "8") {//Licencia Command Line Home Standard Edition
				$idLicenciaComprada = "S8Z";
			
			} else if ($tipoLicencia == "9") { //Licencia OpenOffice + Multimedia
				$idLicenciaComprada = "AB1";
			} else if ($tipoLicencia == "10") { //Licencia PDF + Multimedia
				$idLicenciaComprada = "AB2";
			} else if ($tipoLicencia == "11") { //Licencia Multimedia
				$idLicenciaComprada = "AB3";
			} else if ($tipoLicencia == "12") { //Licencia FULL
				$idLicenciaComprada = "AB4";
			} else if ($tipoLicencia == "13") { //Licencia Microsoft Office + Open Office + Multimedia
				$idLicenciaComprada = "AB5";
			} else if ($tipoLicencia == "14") { //Licencia Microsoft Office + PDF + Multimedia
				$idLicenciaComprada = "AB6";
			} else if ($tipoLicencia == "15") { //Licencia OpenOffice + PDF + Multimedia
				$idLicenciaComprada = "AB7";
			} else if ($tipoLicencia == "16") { //Licencia Microsoft Office + Multimedia
				$idLicenciaComprada = "AB8";
			} else if ($tipoLicencia == "17") { //Licencia Outlook
				$idLicenciaComprada = "OUT";
			} else if ($tipoLicencia == "18") { //Licencia OneClick
				$idLicenciaComprada = "ONE";
			} else if ($tipoLicencia == "19") { //Licencia Web Server
				$idLicenciaComprada = "WEB";
			} else if ($tipoLicencia == "20") { //Licencia MetaClean Command Line Home Extended Edition
				$idLicenciaComprada = "CHE";
			}	
		
			
			$argumentos = "id=".$this->ipn_data["txn_id"]."&pid=".$idLicenciaComprada;
   			
			$html = "<html>";
			$html .= "    <head>";
			$html .= "    	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />";
			$html .= "        <meta property=\"og:title\" content=\"".$this->idioma['mailAsunto']."\" />";
			$html .= "        <title>".$this->idioma['mailActivacionTitulo']."</title>";
			$html .= "    	<style type=\"text/css\">";
			$html .= "			#outlook a{padding:0;}";
			$html .= "			body{width:100% !important;}";
			$html .= "			body{-webkit-text-size-adjust:none;}";
			$html .= "			/* Reset styles */";
			$html .= "			body{margin:0; padding:0;}";
			$html .= "			#backgroundTable{height:100% !important; margin:0; padding: 20px 0 0; width:100% !important;}";
			$html .= "			table td{border-collapse:collapse;border-spacing:0;}";
			$html .= "			tr.spaceTop > td {padding-top: 1em;}";
			$html .= "			tr.spaceBottom > td {padding-bottom: 3em;}";
			$html .= "			body, .backgroundTable{ /*@editable*/ background-color:#ffffff; }";
			$html .= "			.headerContent{ padding-top:15px; padding-right:0; padding-bottom:15px; padding-left:0px; text-align:left; vertical-align:middle; background-color: white; border-bottom: 3px solid #333; }";
			$html .= "			.headerContent2{ background-color: #FFFFFF; border-bottom: 3px solid #333333;}";
			$html .= "			.headerContent2 img {height: 50px; position: relative; top: -40px;}";
			$html .= "			.headerContent h2{ font-family: Arial, Helvetica, sans-serif; padding: 0 0 0 15px; margin: 0; color:black; font-weight:bold; font-size:18px;}";
			$html .= "			.bodyContent{ color:#505050; background-color:#ffffff; font-family:Arial; font-size:12px; line-height:115%; text-align:left; }";
			$html .= "			h3 { color: #333; font-family: Arial; font-size: 18px; font-weight: normal; margin: 10px 0; padding: 0; }";
			$html .= "			h4 { color: #333; font-family: Arial; font-size: 14px; background-color: #f3f5f7; margin: 10px 0; padding: 3px; }";
			$html .= "			p { font-size: 12px; color: #505050; font-family: Arial; margin: 0 0 10px 0; padding: 0; }";
			$html .= "			.aviso { padding: 10px; border: 1px solid #dfdfdf; background-color: #f1f8fb; }";
			$html .= "			.info { font-size: 11px; font-family: Arial, Helvetica, sans-serif; padding: 3px 0; margin: 0; }";
			$html .= "			.legal { font-size: 10px; font-family: Arial, Helvetica, sans-serif; color: #999999; padding: 10px; margin: 0; }";
			$html .= "		</style>";
			$html .= "	</head>";
			$html .= "";
			$html .= "<body leftmargin=\"0\" marginwidth=\"0\" topmargin=\"0\" marginheight=\"0\" offset=\"0\">";
			$html .= "	<center>";
			$html .= "		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" height=\"100%\" width=\"100%\" id=\"backgroundTable\">";
			$html .= "        	<tr>";
			$html .= "            	<td align=\"center\" valign=\"top\">";
			$html .= "			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" id=\"templateContainer\">";
			$html .= "                    	<tr class=\"spaceBottom\">";

			if($this->idioma['extensionImagenes'] == "esp")
				$html .= "                        	<td class=\"info\" align=\"center\">".$this->idioma['mail2']."<a href=\"http://www.adarsus.com/bat/confirmacion.php?".$argumentos."\" target=\"_blank\">".$this->idioma['hazClickAqui']."</a></td>";
			else
				$html .= "                        	<td class=\"info\" align=\"center\">".$this->idioma['mail2']."<a href=\"http://www.adarsus.com/bat/confirmation.php?".$argumentos."\" target=\"_blank\">".$this->idioma['hazClickAqui']."</a></td>";
			
			$html .= "                        </tr>";
			$html .= "                        	<tr>";
			$html .= "                            	<td align=\"center\" valign=\"top\">";
			$html .= "                                    <!-- // Begin Template Header \\ -->";
			$html .= "                                	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" id=\"templateHeader\">";
			$html .= "                                        <tr>";
			$html .= "                                            <td class=\"headerContent\" width=\"50\">";
			$html .= "                                            	<img src=\"http://www.adarsus.com/images/trial_".$this->idioma['extensionImagenes'].".jpg\" alt=\"MetaClean\"/>";
			$html .= "                                            </td>";
			$html .= "                                        </tr>";
			$html .= "                                    </table>";
			$html .= "                                    <!-- // End Template Header \\ -->";
			$html .= "                                </td>";
			$html .= "                            </tr>";
			$html .= "                            <tr class=\"spaceTop\">";
			$html .= "                            	<td align=\"center\" valign=\"top\">";
			$html .= "                                    <!-- // Begin Template Body \\ -->";
			$html .= "                                	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" class=\"bodyContent\">";
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\">";
			if (strlen($producto) > 0) 
				$html .= "                                            	<h3>".$this->idioma['mailCompraConfirmada']."</h3>";
			else
				$html .= "                                            	<h3>".$this->idioma['mailCodError']."</h3>";
				$html .= "                                            </td>";
			$html .= "                                        </tr>";
			if (strlen($producto) > 0) {
				$html .= "                                        <tr>";
				$html .= "                                        	<td valign=\"top\">";
				$html .= "                                            	<p>".$this->idioma['mailMensajeCompraConf']."<b>" .$producto."</b>".$this->idioma['mailMensajeCompraConf2']."</p>";
				$html .= "                                            </td>";
				$html .= "                                        </tr>";
				$html .= "                                        <tr>";
				$html .= "                                        	<td valign=\"top\">";
				$html .= "                                            	<h4>".$this->idioma['mailCodValidacion']."</h4>";
				$html .= "                                            </td>";
				$html .= "                                        </tr>";
				$html .= "                                        <tr>";
				$html .= "                                        	<td valign=\"top\">";
				$html .= "                                            	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\">";
				$html .= "                                                	<tr>";
				$html .= "                                                    	<td valign=\"top\" width=\"600\"><p>".$this->idioma['mailURL']."</p></td>";
				$html .= "                                                  </tr>";
				$html .= "                                                	<tr class=\"spaceTop\">";
				if($this->idioma['extensionImagenes'] == "esp")
					$html .= "                                                    	<td valign=\"top\" width=\"600\"><p><a href=\"https://www.adarsus.com/en/metaclean-solutions/?".$argumentos."\">https://www.adarsus.com/en/metaclean-solutions/?".$argumentos."</a></p></td>";
				else
					$html .= "                                                    	<td valign=\"top\" width=\"600\"><p><a href=\"https://www.adarsus.com/en/metaclean-solutions/?".$argumentos."\">https://www.adarsus.com/en/metaclean-solutions/?".$argumentos."</a></p></td>";
				$html .= "                                                  </tr>";
				$html .= "                                                </table>";
				$html .= "                                            </td>";
				$html .= "                                        </tr>";
			}
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\">&nbsp;";
			$html .= "                                            	";
			$html .= "                                            </td>";
			$html .= "                                        </tr>";
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\">&nbsp;";
			$html .= "                                            	";
			$html .= "                                            </td>";
			$html .= "                                        </tr>";
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\" class=\"aviso\">";
			$html .= "                                            	".$this->idioma['mailEnviarMail']."<strong>support@adarsus.com</strong>";
			$html .= "                                          </td>";
			$html .= "                                        </tr>";
			$html .= "                                    </table>";
			$html .= "                                </td>";
			$html .= "                            </tr>";
			$html .= "                     </table>";
			$html .= "                 </td>";
			$html .= "             </tr>";
			$html .= "         </table>";
			$html .= "	</center>";
			$html .= "</body>";
			$html .= "</html>";
   	
   		return $html;
   }
   
   function creaMailDescarga() {
   	$eMail = $this->fields["eMail"]; 
	$producto = $this->fields["producto"];
	$lang = $this->fields["lang"];
   			
	$argumentos = "eMail=".$eMail."&product=".$producto;
   			
			$html = "<html>";
			$html .= "    <head>";
			$html .= "    	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />";
			$html .= "      <meta property=\"og:title\" content=\"".$this->idioma['mailDescargaAsunto']."\" />";
			$html .= "      <title>".$this->idioma['mailDescargaAsunto']."</title>";
			$html .= "    	<style type=\"text/css\">";
			$html .= "			#outlook a{padding:0;}";
			$html .= "			body{width:100% !important;}";
			$html .= "			body{-webkit-text-size-adjust:none;}";
			$html .= "			/* Reset styles */";
			$html .= "			body{margin:0; padding:0;}";
			$html .= "			#backgroundTable{height:100% !important; margin:0; padding: 20px 0 0; width:100% !important;}";
			$html .= "			table td{border-collapse:collapse;border-spacing:0;}";
			$html .= "			tr.spaceTop > td {padding-top: 1em;}";
			$html .= "			tr.spaceBottom > td {padding-bottom: 3em;}";
			$html .= "			body, .backgroundTable{ /*@editable*/ background-color:#ffffff; }";
			$html .= "			.headerContent{ padding-top:15px; padding-right:0; padding-bottom:15px; padding-left:0px; text-align:left; vertical-align:middle; background-color: white; border-bottom: 3px solid #333; }";
			$html .= "			.headerContent2{ background-color: #FFFFFF; border-bottom: 3px solid #333333;}";
			$html .= "			.headerContent2 img {height: 50px; position: relative; top: -40px;}";
			$html .= "			.headerContent h2{ font-family: Arial, Helvetica, sans-serif; padding: 0 0 0 15px; margin: 0; color:black; font-weight:bold; font-size:18px;}";
			$html .= "			.bodyContent{ color:#505050; background-color:#ffffff; font-family:Arial; font-size:12px; line-height:115%; text-align:left; }";
			$html .= "			h3 { color: #333; font-family: Arial; font-size: 18px; font-weight: normal; margin: 10px 0; padding: 0; }";
			$html .= "			h4 { color: #333; font-family: Arial; font-size: 14px; background-color: #f3f5f7; margin: 10px 0; padding: 3px; }";
			$html .= "			p { font-size: 12px; color: #505050; font-family: Arial; margin: 0 0 10px 0; padding: 0; }";
			$html .= "			.aviso { padding: 10px; border: 1px solid #dfdfdf; background-color: #f1f8fb; }";
			$html .= "			.info { font-size: 11px; font-family: Arial, Helvetica, sans-serif; padding: 3px 0; margin: 0; }";
			$html .= "			.legal { font-size: 10px; font-family: Arial, Helvetica, sans-serif; color: #999999; padding: 10px; margin: 0; }";
			$html .= "		</style>";
			$html .= "	</head>";
			$html .= "";
			$html .= "<body leftmargin=\"0\" marginwidth=\"0\" topmargin=\"0\" marginheight=\"0\" offset=\"0\">";
			$html .= "	<center>";
			$html .= "		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" height=\"100%\" width=\"100%\" id=\"backgroundTable\">";
			$html .= "        	<tr>";
			$html .= "            	<td align=\"center\" valign=\"top\">";
			$html .= "			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" id=\"templateContainer\">";
			$html .= "                    	<tr class=\"spaceBottom\">";
			$html .= "                        	<td class=\"info\" align=\"center\">".$this->idioma['mail2']."<a href=\"http://www.adarsus.com/bat/download-metaclean.php?".$argumentos."&lang=".$lang."\" target=\"_blank\">".$this->idioma['hazClickAqui']."</a></td>";
			$html .= "                        </tr>";
			$html .= "                        	<tr>";
			$html .= "                            	<td align=\"center\" valign=\"top\">";
			$html .= "                                    <!-- // Begin Template Header \\ -->";
			$html .= "                                	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" id=\"templateHeader\">";
			$html .= "                                        <tr>";
			$html .= "                                            <td class=\"headerContent\" width=\"50\">";
			$html .= "                                            	<img src=\"http://www.adarsus.com/images/trial_".$this->idioma['extensionImagenes'].".jpg\" alt=\"MetaClean\"/>";
			$html .= "                                            </td>";
			$html .= "                                        </tr>";
			$html .= "                                    </table>";
			$html .= "                                    <!-- // End Template Header \\ -->";
			$html .= "                                </td>";
			$html .= "                            </tr>";
			$html .= "                            <tr class=\"spaceTop\">";
			$html .= "                            	<td align=\"center\" valign=\"top\">";
			$html .= "                                    <!-- // Begin Template Body \\ -->";
			$html .= "                                	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" class=\"bodyContent\">";
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\">";
			$html .= "                                            		<h3>".$this->idioma['mailDescargaMetaClean']."</h3>";
			$html .= "                                      	</td>";
			$html .= "                                        </tr>";
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\">";
			$html .= "                                            	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\">";
			$html .= "                                                	<tr>";
			$html .= "                                                    	<td valign=\"top\" width=\"600\"><p>".$this->idioma['mailDescargaURL']."</p></td>";
			$html .= "                                                  </tr>";
			$html .= "                                                	<tr class=\"spaceTop\">";
			if($this->idioma['extensionImagenes'] == "esp")
				$html .= "                                                    	<td valign=\"top\" width=\"600\"><p><a href=\"https://www.adarsus.com/en/metaclean-solutions/?".$argumentos."\">https://www.adarsus.com/en/metaclean-solutions/?".$argumentos."</a></p></td>";
			else
				$html .= "                                                    	<td valign=\"top\" width=\"600\"><p><a href=\"https://www.adarsus.com/en/metaclean-solutions/?".$argumentos."\">https://www.adarsus.com/en/metaclean-solutions/?".$argumentos."</a></p></td>";
			$html .= "                                                  </tr>";
			$html .= "                                                </table>";
			$html .= "                                            </td>";
			$html .= "                                        </tr>";
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\">&nbsp;";
			$html .= "                                            	";
			$html .= "                                            </td>";
			$html .= "                                        </tr>";
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\">&nbsp;";
			$html .= "                                            	";
			$html .= "                                            </td>";
			$html .= "                                        </tr>";
			$html .= "                                        <tr>";
			$html .= "                                        	<td valign=\"top\" class=\"aviso\">";
			$html .= "                                            	".$this->idioma['mailEnviarMail']."<strong>support@adarsus.com</strong>";
			$html .= "                                          </td>";
			$html .= "                                        </tr>";
			$html .= "                                    </table>";
			$html .= "                                </td>";
			$html .= "                            </tr>";
			$html .= "                     </table>";
			$html .= "                 </td>";
			$html .= "             </tr>";
			$html .= "         </table>";
			$html .= "	</center>";
			$html .= "</body>";
			$html .= "</html>";
   	
   		return $html;
   }
   
 }
?>