<?php

class AES_Cipher {

    private static $OPENSSL_CIPHER_NAME = "aes-128-cbc"; //Name of OpenSSL Cipher 
    private static $CIPHER_KEY_LEN = 16; //128 bits

	private static $INITIALIZATION_VECTOR = 'WeEr6-oPP785-g.f';
	private static $KEY_PASS = '9.-i452Rt.-Lwrty';
		
    /**
     * Encrypt data using AES Cipher (CBC) with 128 bit key
     * 
     * @param type $key - key to use should be 16 bytes long (128 bits)
     * @param type $iv - initialization vector
     * @param type $data - data to encrypt
     * @return encrypted data in base64 encoding with iv attached at end after a :
     */

    static function encrypt($data) {
		$iv = AES_Cipher::$INITIALIZATION_VECTOR;
		$key = AES_Cipher::$KEY_PASS;
		
        if (strlen($key) < AES_Cipher::$CIPHER_KEY_LEN) {
            $key = str_pad("$key", AES_Cipher::$CIPHER_KEY_LEN, "0"); //0 pad to len 16
        } else if (strlen($key) > AES_Cipher::$CIPHER_KEY_LEN) {
            $key = substr($key, 0, AES_Cipher::$CIPHER_KEY_LEN); //truncate to 16 bytes
        }
        
        $encodedEncryptedData = base64_encode(openssl_encrypt($data, AES_Cipher::$OPENSSL_CIPHER_NAME, $key, OPENSSL_RAW_DATA, $iv));
        $encodedIV = base64_encode($iv);
        $encryptedPayload = $encodedEncryptedData;//.":".$encodedIV;
        
        return $encryptedPayload;
    }

    /**
     * Decrypt data using AES Cipher (CBC) with 128 bit key
     * 
     * @param type $key - key to use should be 16 bytes long (128 bits)
     * @param type $data - data to be decrypted in base64 encoding with iv attached at the end after a :
     * @return decrypted data
     */
    static function decryptTokenMITM($data) {
		$iv = AES_Cipher::$INITIALIZATION_VECTOR;
		$key = AES_Cipher::$KEY_PASS;
	
		try {
			if (strlen($key) < AES_Cipher::$CIPHER_KEY_LEN) {
				$key = str_pad("$key", AES_Cipher::$CIPHER_KEY_LEN, "0"); //0 pad to len 16
			} else if (strlen($key) > AES_Cipher::$CIPHER_KEY_LEN) {
				$key = substr($key, 0, AES_Cipher::$CIPHER_KEY_LEN); //truncate to 16 bytes
			}
			
			//$parts = explode(':', $data); //Separate Encrypted data from iv.
			$decryptedData = openssl_decrypt(base64_decode($data), AES_Cipher::$OPENSSL_CIPHER_NAME, $key, OPENSSL_RAW_DATA, base64_decode(base64_encode($iv)));
			
			if(strlen($decryptedData) < 1)
				return "Error decrypting string!!!";
			else
				return $decryptedData;
			
		} catch (Exception $e) {
			return "Error decrypting string :::: " + $e;
		}
    }
	
}

?>



