/*
	 * Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
	 * See LICENSE in the project root for license information.
	 */
 
	var mailboxItem;
	var _settings = null;
	
	var value = {
        AsyncResult: null,
        Dialog: null,
        MessageObjects: [],
		NFileProcessed: null,
		CancelSend: false,
		OWAPlatform: false,
		isDialogOpened: false
    };

	// Entry point for MetaClean Message Body Checker add-in before send is allowed.
	// <param name="event">ItemSend event is automatically passed by on-send code to the function specified in the manifest.</param>
	function removeMetadataFromAttachments(event) {
		mailboxItem.body.getAsync("html", { asyncContext: event }, processAttachments);
	}
	
	function processDialogEvent(arg) {
		//console.log('capturo evento CERRAR ventana');
		try {
			localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "close", settings: value.MessageObjects }));
			value.Dialog.close();
			
		} catch (e) {
            console.log("Error al cerrar el dialogo");
        }
		
		value.AsyncResult.asyncContext.completed({ allowEvent: false });
	}
	
	function processDialogMessage(arg) {
		if(arg !== undefined && arg !== null && arg != "") {
			let msg = JSON.parse(arg.message);
			//console.log('MENSAJE RECIBIDO DE LA VENTANA MODAL --> ' + msg.messageText + ' Iteracion --> ' + msg.iteration);
			
			value.NFileProcessed = (msg.iteration != null) ? msg.iteration : msg.messageText;
		}
	}
	
	/**
     * Updates the progress bar by incrementing it
     * @param {number} [increment]  The amount ot increment the progress bar by
     * @param {string} [text]       A new message to display
     * @returns {{Value: number, Cancelled: boolean}}   Returns a JSON object wiht the value
     *                                                 of the progress bar and whether the
     *                                                 user pressed cancel
     */
    function UpdateProgessBar(increment=1, text="", iter) {
        try {
            let messageToDialog = { message: "progress", settings: { Text: text, Caption: "", Number: increment, NFile: iter } };
			localStorage.setItem("MetaCleanProgress", JSON.stringify(messageToDialog));
			
        } catch (e) {
            console.log("Error in UpdateProgessBar ---> " + e.message);
            return "";
        }
    };
	
	function isOWA() {
		//obtenemos el sender del correo
		mailboxItem.from.getAsync(function(asyncResult) {
			if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
				content.emailSender = asyncResult.value.emailAddress;
				//console.log("Message from: " + asyncResult.value.displayName + " (" + asyncResult.value.emailAddress + ")");
				
				if(!content.webServiceUrlRetrieved) {
					getWebServiceUrl()
						.then(result => {
							console.log("Web Service URL: " + result); 
								
						}).catch((error) => { console.log("Error getWebServiceUrl :::: " + error.message); });
				}
					
			} else {
				content.emailSender = "Email no identificado!!!";
				console.error(asyncResult.error);
			}
		});
			
		/*
		Android	--> The platform is an Android device.
		iOS	--> The platform is an iOS device.
		Mac	--> The platform is Mac.
		OfficeOnline --> The platform is Office on the web (in a browser).
		PC --> The platform is PC (Windows).
		Universal --> The platform is WinRT.
		*/
		
		//console.log("Plataforma :::: " + Office.context.platform);
		
		if (Office.context.platform == "OfficeOnline")
			return true; //OWA
		else
			return false;
	}
	
	const timeoutFetch = (time) => {
		let controller = new AbortController();
		setTimeout(() => controller.abort(), time * 1000);
		
		return controller;
	};
	
    async function processAttachments(asyncResult) {
		let result = null;
		
		//Si el appointment tiene ficheros adjuntos la funcion addAttachment da error y no se envia la cita, los adjuntos de los appointment no seran procesados			
		if(Office.context.mailbox.item.seriesId === undefined)
		  result = await getAllAttchmentObjects();
		
		principal: if(result != null && result.message === 'Success' && result.attachObjectArray.length > 0 && needProcessAttachments(result)) {
			//Comprobamos WhiteList
			let whiteList = _settings.get("MetaCleanWhiteList");
		
			if(whiteList != null && whiteList != undefined && whiteList.length > 3) {
				let trustedTo = await isTrustedTo(whiteList);
				
				if(trustedTo.trustedRecipients) {
					let trustedCc = await isTrustedCc(whiteList);
				
					if(trustedCc.trustedRecipients) {
						let trustedBcc = await isTrustedBcc(whiteList);
				
						if(trustedBcc.trustedRecipients) {
							//console.log("Todos los destinatarios son de CONFIANZA !!!");
							break principal;
						}
					}
				}
			}
			
			value.OWAPlatform = isOWA();
			value.AsyncResult = asyncResult;
			UpdateProgessBar(0, "", 0);
			
			/*
			Office.context.ui.displayDialogAsync("https://www.metaclean.es/metaCleanForOutlookOnSend/Dialog.html",
				{ height: (value.OWAPlatform?18:14), width: (value.OWAPlatform?42:24), displayInIframe: true },
				function (modalDialog) {
					value.Dialog = modalDialog.value;
						
					value.Dialog.addEventHandler(Office.EventType.DialogEventReceived, processDialogEvent);
					value.Dialog.addEventHandler(Office.EventType.DialogMessageReceived, processDialogMessage);
				}
			);
			*/
			
			// URL, Ancho, Alto
			openDialogWindow("https://www.adarsus.com/addin/outlookOnSend/Dialog.html", (value.OWAPlatform?35:24), (value.OWAPlatform?14:14));
			
			//console.log("ficheros añadidos --> " + result.attachObjectArray.length);
			
			//Si el proceso tarda mas de 60 segundos en terminar cancelamos el envio (Cuidado al cambiar este valor pues si es un fichero ZIP grande con muchos ficheros puede consumir mas de 60 segundos)
			setTimeout(() => {
				if(value.Dialog != null) {
					try {
						localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "close", settings: value.MessageObjects }));
						value.Dialog.close();
						
					} catch (e) {
						console.log("Error in Dialog.close() :::: ");
					}
				}
				
				//Cancelamos el envio
				asyncResult.asyncContext.completed({ allowEvent: false });
				
            }, 60000);
			
			for (let i = 0; i < result.attachObjectArray.length; i++) {
				let extensionFile = (result.attachObjectArray[i].name.split('.').length > 0) ? result.attachObjectArray[i].name.split('.').pop().toLowerCase() : '';
			
				if(result.attachObjectArray[i].attachmentType === 'cloud' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile)) {
					console.log("Iteracion --> " + i + " NO Procesamos el fichero: " + result.attachObjectArray[i].name + " attachmentType: " + result.attachObjectArray[i].attachmentType);
				
				} else if(result.attachObjectArray[i].attachmentType === 'file' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile)) {
					console.log("Iteracion --> " + i + " Procesamos el fichero: " + result.attachObjectArray[i].name + " attachmentType: " + result.attachObjectArray[i].attachmentType + " Size: " + result.attachObjectArray[i].size);
									
					let porcentaje = (100/result.attachObjectArray.length) * (i+1);
					UpdateProgessBar(porcentaje, result.attachObjectArray[i].name, i);
				
					let fileContent = await getAttachmentContent(result.attachObjectArray[i]);
						
					if(fileContent.message === 'Success') {
						//Proceso los metadatos
						let processedFile = await processMetadata(fileContent.attachContent, fileContent.attachName);
						
						//Verificamos si hay error de conexion y relanzamos el proceso
						if(processedFile.responseCode === 500)
							processedFile = await processMetadata(fileContent.attachContent, fileContent.attachName);
							
						//Si el procesado de metadatos es correcto borro el fichero adjunto original
						if(processedFile.message === 'Success' || processedFile.message === "Metadata removed successfully" || (processedFile.message.startsWith("Track c") && processedFile.message.includes("activated in the document"))) {
							//console.log(`Metadata file removed successfully: ${fileContent.attachName}`);
							
							let removeResult = await removeAttachment(result.attachObjectArray[i].name, result.attachObjectArray[i].id);
							
							//Si el borrado del fichero adjunto es correcto adjunto el nuevo fichero procesado
							if(removeResult != null && removeResult.message != null && removeResult.message === 'Success') {
								let addResult = await addBase64Attachment(processedFile.blobFile, fileContent.attachName);
											
								if(addResult.message != 'Success') {
									//let mensaje_error = "Error al adjuntar el fichero procesado: " + fileContent.attachName + " :::: " + addResult.message;
									value.MessageObjects.push({ message: addResult.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
									
								} else {
									if(content.enableMetaCleanTrackChanges && processedFile.message.startsWith("Track c") && processedFile.message.includes("activated in the document") && (extensionFile.startsWith("do") || extensionFile.startsWith("xl") || extensionFile.startsWith("pp") || extensionFile.startsWith("zip") || extensionFile.startsWith("7z"))) {
										value.MessageObjects.push({ message: processedFile.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });//Aun no esta desarrollada la funcionalidad para aceptar Cambios y borrar comentarios para el Add-in por eso ponemos siempre false.
										//value.MessageObjects.push({ message: processedFile.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: (extensionFile.endsWith("x") || extensionFile.endsWith("zip") || extensionFile.endsWith("7z")) });//Para las versiones antiguas de Word (.doc, .dot) NO damos la opcion de aceptar los cambios automaticamente
									}
										
									if (!value.OWAPlatform) //No es OWA
										await delay(500);
								}
											
							} else {
								console.log("Error al borrar el fichero adjunto: " + fileContent.attachName + " :::: " + (removeResult!=null?removeResult.message:""));
								value.MessageObjects.push({ message: "Error al borrar el fichero adjunto :::: " + (removeResult!=null?removeResult.message:""), fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
							}
								
						} else if(processedFile.message.includes("Signed PDF file")) {
							console.log(result.attachObjectArray[i].name + " :::: " + processedFile.message);
							
							//value.MessageObjects.push({ message: processedFile.message, fileName: result.attachObjectArray[i].name, pdfSigned: true, trackChangesEnabled: false });
						
						} else if(processedFile.message.includes("Your file appears not to be a valid OLE2")) {
							console.log(result.attachObjectArray[i].name + " :::: " + processedFile.message);
							
							//let msgErrorOLE2 = extensionFile.includes("xls")? "Parece que el formato del fichero no corresponde con el formato estandar de ficheros Excel, por favor contacte con support@adarsus.com para comunicar este evento.":"Parece que el formato del fichero no corresponde con el formato estandar de ficheros " + extensionFile + ", por favor contacte con support@adarsus.com para comunicar este evento.";
							
							//value.MessageObjects.push({ message: msgErrorOLE2, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
							
						} else {
							console.log("Error al procesar los metadatos del fichero: " + fileContent.attachName + " :::: " + processedFile.message);
							
							value.MessageObjects.push({ message: processedFile.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
						}
						
					} else {
						console.log("Error al obtener el contenido del fichero: " + result.attachObjectArray[i].name + " :::: " + fileContent.message);
						
						value.MessageObjects.push({ message: "Error al obtener el contenido del fichero :::: " + fileContent.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
					}
					
					do {
						//console.log("Espero... --> " + value.NFileProcessed + " i --> " + i);
						await delay(100);
						
					} while (!value.isDialogOpened && (value.Dialog == null || value.NFileProcessed == null || value.NFileProcessed < i));
					
				} //else
					//console.log("Fichero no soportado --> " + result.attachObjectArray[i].name + " Extension: " + extensionFile);
			}
			
			if(result.attachObjectArray.length > 0) {
				
				if(value.Dialog != null) {
					
					if(value.MessageObjects.length > 0) {//Si han ocurrido avisos entramos
						value.NFileProcessed = null;
						value.CancelSend = false;
						let controlModal = 0;
						
						localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "warningMessages", settings: value.MessageObjects }));
		
						do {
							//Espero 30 segundos a que responda el usuario (controlModal estaba en 1000)
							if(controlModal > 100 && value.Dialog == null)
								value.NFileProcessed = 'Cancelar_Envio'; //'Enviar';
							
							//console.log("Espero controlModal --> " + value.NFileProcessed);
							await delay(300);
							
							controlModal++;
							
						} while (value.NFileProcessed == null);
					
						if(value.NFileProcessed != null) {
							
							if(value.NFileProcessed === 'Cancelar_Envio') {
								value.CancelSend = true;
								
							} else if(value.NFileProcessed === 'Procesar_Ficheros') {
								let nfilesToProcess = 0;
								let iteratorFileMessages = 0;
								
								value.NFileProcessed = null;
									
								for (let zz = 0; zz < value.MessageObjects.length; zz++) {
									if(value.MessageObjects[zz].trackChangesEnabled)
										nfilesToProcess++;
								}
								
								localStorage.setItem("MetaCleanProgress", JSON.stringify({ Text: "", Caption: "", Number: 0, NFile: 0 }));
								
								//Obtenemos la nueva referencia a los ficheros adjuntos
								result = await getAllAttchmentObjects();
								
								for (let i = 0; i < result.attachObjectArray.length; i++) {
									let extensionFile = (result.attachObjectArray[i].name.split('.').length > 0) ? result.attachObjectArray[i].name.split('.').pop().toLowerCase() : '';
								
									if(result.attachObjectArray[i].attachmentType === 'file' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile)) {
										//console.log("Iteracion --> " + i + " fichero: " + result.attachObjectArray[i].name + " attachmentType: " + result.attachObjectArray[i].attachmentType + " Size: " + result.attachObjectArray[i].size);
										
										for (let xx = 0; xx < value.MessageObjects.length; xx++) {
											if(value.MessageObjects[xx].trackChangesEnabled && result.attachObjectArray[i].name === value.MessageObjects[xx].fileName) {
												//console.log("Iteracion --> " + xx + " Procesamos el fichero: " + value.MessageObjects[xx].fileName);
												
												let porcentaje = (100/nfilesToProcess) * (iteratorFileMessages+1);
												UpdateProgessBar(porcentaje, result.attachObjectArray[i].name, iteratorFileMessages);
												
												iteratorFileMessages++;
												
												let fileContent = await getAttachmentContent(result.attachObjectArray[i]);
												
												if(fileContent.message === 'Success') {
													console.log("Contenido del fichero recibido correctamente --> " + fileContent.attachName);
													//Proceso los metadatos
													let processedFile = await processMetadata(fileContent.attachContent, fileContent.attachName);
													
													//Verificamos si hay error de conexion y relanzamos el proceso
													if(processedFile.responseCode === 500)
														processedFile = await processMetadata(fileContent.attachContent, fileContent.attachName);
													
													//Si el procesado de metadatos es correcto borro el fichero adjunto original
													if(processedFile.message === 'Success' || processedFile.message === "Metadata removed successfully") {
														console.log(`Metadatos procesados successfully: ${fileContent.attachName}`);
														
														let removeResult = await removeAttachment(result.attachObjectArray[i].name, result.attachObjectArray[i].id);
														
														//Si el borrado del fichero adjunto es correcto adjunto el nuevo fichero procesado
														if(removeResult != null && removeResult.message != null && removeResult.message === 'Success') {
															console.log(`Metadata file removed successfully: ${fileContent.attachName}`);
															let addResult = await addBase64Attachment(processedFile.blobFile, fileContent.attachName);
																		
															if(addResult.message === 'Success') {
																console.log(`Fichero adjuntado correctamente: ${fileContent.attachName}`);
																
																if (!value.OWAPlatform) //No es OWA
																	await delay(400);
															}
															
															break;
														}															
													}
												}
											}
										}
									}
								}
							}
						}
					}
					
					//Cancelamos el bucle recusivo de iterador de Dialog.html
					if(value.Dialog != null) {
						localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "close", settings: value.MessageObjects }));
						value.Dialog.close();
					}
				}
			}
			
		} //else {
			//console.log("No hay ficheros adjuntos");
		//}
		
		//console.log("End of process!!!");
		let checkBody = false;
 
		/* 
		var listOfBlockedWords = new Array("blockedword", "aaa", "blockedword2");
        var wordExpression = listOfBlockedWords.join('|');
		
		// \b to perform a "whole words only" search using a regular expression in the form of \bword\b.
        // i to perform case-insensitive search.
        var regexCheck = new RegExp('\\b(' + wordExpression + ')\\b', 'i');
        checkBody = regexCheck.test(asyncResult.value);
		*/
		
        if (checkBody || value.CancelSend) {
			// Call event.completed() after all work is done.
			// Block send.
            asyncResult.asyncContext.completed({ allowEvent: false });
			
        } else {
			// Call event.completed() after all work is done.
            // Allow send.
            asyncResult.asyncContext.completed({ allowEvent: true });
        }
    }
	
	function showNotification(messageText) {
		let details = {
			type: Office.MailboxEnums.ItemNotificationMessageType.ProgressIndicator,
			message: messageText,
			persistent: false
		};
		
		if(messageText === "remove")
			mailboxItem.notificationMessages.removeAsync('progress');
		else
			mailboxItem.notificationMessages.replaceAsync('progress', details);
	}
	
	function pixelToPercentage(heightInPixel, widthInPixel) {
		let height = Math.floor(100 * heightInPixel / screen.height);
		let width = Math.floor(100 * widthInPixel / screen.width);
		
		return { height: height, width: width };
	}
	
	async function openDialogWindow(url, ancho, alto) {
		if(value.OWAPlatform && screen.height < 1000) {
			ancho += 13;
			alto += 7;
			
		} else if(!value.OWAPlatform) {//Este remidensionamiento en pixeles solo funciona con las versiones de escritorio
			/*
			let alto = (Office.context.platform == "Mac")?200:200;
			let dim = pixelToPercentage( (url.indexOf('Warning.html') > -1)?400:alto, 750);
			
			ancho = dim.width;
			alto = dim.height;
			*/
			url += "?extra_param=MetaCleanDesktopVersion&vh="+screen.height;
			
			if(screen.height < 800)
				alto += 12;
		}
		
		//console.log("screen.height " + screen.height + " screen.width: " + screen.width);
		
		Office.context.ui.displayDialogAsync(url, { height: alto, width: ancho, displayInIframe: true },
			function (modalDialog) {
				if(modalDialog.status === Office.AsyncResultStatus.Failed) {
					if(modalDialog.error.code === 12007) {
						//openDialogWindow(url, ancho, alto); // Recursive call
						value.isDialogOpened = true;
						
					} else {
						value.isDialogOpened = true;						
					}
					
					console.log("ERROR --> Lanzo de nuevo la ventana Modal --> " + modalDialog.error);
					
				} else {
					value.Dialog = modalDialog.value;
										
					value.Dialog.addEventHandler(Office.EventType.DialogEventReceived, processDialogEvent);
					value.Dialog.addEventHandler(Office.EventType.DialogMessageReceived, processDialogMessage);
				}
			}
		);
	}

	function needProcessAttachments(result) {
		if (!(result.attachObjectArray.length > 0))
			return false;
		
		//let _settings = Office.context.roamingSettings;
		
		content.enableMetaCleanMSOffice = true;
		content.enableMetaCleanOpenOffice = true;
		content.enableMetaCleanPDF = true;
		content.enableMetaCleanMultimedia = false;
		content.enableMetaCleanCompressed = true;
		content.enableMetaCleanPlugIn = true;
		content.enableMetaCleanPDFSigned = false;
		content.enableMetaCleanTrackChanges = true;
			
		if(_settings.get('isFirstRun') != null) {
			let addinEnabledFor = _settings.get("MetaCleanAddIn");
				
			if(!addinEnabledFor.includes("MetaCleanMSOffice"))
				content.enableMetaCleanMSOffice = false;
				
			if(!addinEnabledFor.includes("MetaCleanOpenOffice"))
				content.enableMetaCleanOpenOffice = false;
				
			if(!addinEnabledFor.includes("MetaCleanPDF"))
				content.enableMetaCleanPDF = false;
				 
			if(addinEnabledFor.includes("MetaCleanMultimedia"))
				content.enableMetaCleanMultimedia = true;
				
			if(!addinEnabledFor.includes("MetaCleanCompressed"))
				content.enableMetaCleanCompressed = false;
			
			if(addinEnabledFor.includes("PDFSigned"))
				content.enableMetaCleanPDFSigned = true;
			
			if(!addinEnabledFor.includes("MetaCleanTrackChanges"))
				content.enableMetaCleanTrackChanges = false;
			
			//console.log('MetaClean AddIn install date: ' + _settings.get("installDate") + ' Settings saved values: ' + _settings.get("MetaCleanAddIn"));
			
			content.enableMetaCleanPlugIn = (content.enableMetaCleanMSOffice || content.enableMetaCleanOpenOffice || content.enableMetaCleanPDF || content.enableMetaCleanMultimedia || content.enableMetaCleanCompressed)?true:false;
			
			//_settings.remove("isFirstRun");
			//_settings.saveAsync();
			
		} else {
			let date = new Date();
			
			//console.log('[' + (new Date()).toUTCString() + '] MetaClean AddIn First Run');
			
			_settings.set("isFirstRun", 'initialized');
			_settings.set("installDate", date.getDate() + "/" + (date.getMonth() + 1)  + "/" + date.getFullYear());
			_settings.set("MetaCleanAddIn", 'MetaCleanMSOfficeMetaCleanPDFMetaCleanOpenOfficeMetaCleanCompressedMetaCleanTrackChanges');
				
			// Save All settings in the mailbox to make it available in future sessions.
			_settings.saveAsync(function(result) {
				if (result.status !== Office.AsyncResultStatus.Succeeded)
					console.error('Action failed with message ' + result.error.message);
				//else
					//console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
			});
		}
		
		if(content.enableMetaCleanPlugIn) {
			let encontrado = false;
			
			for (let i = 0; i < result.attachObjectArray.length; i++) {
				let extensionFile = (result.attachObjectArray[i].name.split('.').length > 0) ? result.attachObjectArray[i].name.split('.').pop().toLowerCase() : '';
				
				if(result.attachObjectArray[i].attachmentType === 'file' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile)) {
					//console.log('Analizo el fichero ---> ' + result.attachObjectArray[i].name);
					encontrado =  true;
					break;
				} 
			}
			
			return encontrado;
			
		} else
			return false;	 
	}
	
	function isTrustedTo(whiteList) {
		return new Promise(resolve => {
			mailboxItem.to.getAsync(function(asyncResult) {
				if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
					let msgTo = asyncResult.value;
					
					try {
					    for (let i = 0; i < msgTo.length; i++) {
    						let toEmail = msgTo[i].emailAddress.split('@').pop();
    						
    						//console.log("Para --> (" + msgTo[i].emailAddress + ") whiteList --> " + whiteList + " toEmail --> " + toEmail);
    						
    						if(!whiteList.includes(toEmail)) {
    							console.log("Dominio no confiable !!! " + toEmail);
    							resolve({ message: 'Success', trustedRecipients: false });
    							break;
    						}
    					}
					} catch(error) {
						console.error("Excepcion al obtener los destinatarios TO :::: " + (error.message != null ? error.message : "---") + " :::: " + msgTo);
						
						resolve({ message: 'Success', trustedRecipients: false });
					}					
					
					resolve({ message: 'Success', trustedRecipients: true });
					
				} else {
					resolve({ message: asyncResult.error.message, trustedRecipients: false });
				}
			});
		});
	}
	
	function isTrustedCc(whiteList) {
		return new Promise(resolve => {
			mailboxItem.cc.getAsync(function(asyncResult) {
				if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
					let msgTo = asyncResult.value;
					
					try {
					    for (let i = 0; i < msgTo.length; i++) {
    						let toEmail = msgTo[i].emailAddress.split('@').pop();
    						
    						//console.log("Copia --> (" + msgTo[i].emailAddress + ") whiteList --> " + whiteList + " toEmail --> " + toEmail);
    						
    						if(!whiteList.includes(toEmail)) {
    							console.log("Dominio no confiable !!! " + toEmail);
    							resolve({ message: 'Success', trustedRecipients: false });
    							break;
    						}
    					}
					} catch(error) {
						console.error("Excepcion al obtener los destinatarios TO :::: " + (error.message != null ? error.message : "---") + " :::: " + msgTo);
						
						resolve({ message: 'Success', trustedRecipients: false });
					}
					
					resolve({ message: 'Success', trustedRecipients: true });
					
				} else {
					resolve({ message: asyncResult.error.message, trustedRecipients: false });
				}
			});
		});
	}
	
	function isTrustedBcc(whiteList) {
		return new Promise(resolve => {
			mailboxItem.bcc.getAsync(function(asyncResult) {
				if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
					let msgTo = asyncResult.value;
					
					try {
					    for (let i = 0; i < msgTo.length; i++) {
    						let toEmail = msgTo[i].emailAddress.split('@').pop();
    						
    						//console.log("Copia Oculta --> (" + msgTo[i].emailAddress + ") whiteList --> " + whiteList + " toEmail --> " + toEmail);
    						
    						if(!whiteList.includes(toEmail)) {
    							console.log("Dominio no confiable !!! " + toEmail);
    							resolve({ message: 'Success', trustedRecipients: false });
    							break;
    						}
    					}
					} catch(error) {
						console.error("Excepcion al obtener los destinatarios TO :::: " + (error.message != null ? error.message : "---") + " :::: " + msgTo);
						
						resolve({ message: 'Success', trustedRecipients: false });
					}
					
					resolve({ message: 'Success', trustedRecipients: true });
					
				} else {
					resolve({ message: asyncResult.error.message, trustedRecipients: false });
				}
			});
		});
	}
	
	function getAllAttchmentObjects() {
		return new Promise(resolve => {
			let attachmentsArray = [];
			
            mailboxItem.getAttachmentsAsync(function (result) {
				if (result.status !== Office.AsyncResultStatus.Succeeded) {
					console.log(result.error.message);
					resolve({ message: result.error.message, attachObjectArray: attachmentsArray });
						
				} else {
					resolve({ message: 'Success', attachObjectArray: result.value });
				}
            });
		});
	}
	
	function getAttachmentContent(attachment) {
		return new Promise(resolve => {
			mailboxItem.getAttachmentContentAsync(
				attachment.id,
				{ asyncContext : { nombreFichero: attachment.name, attachID: attachment.id} },
				function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded) {
						console.log(`Error al descargar el fichero: ${result.asyncContext.nombreFichero} :::: ${result.error.message}`);
						
						resolve({ message: result.error.message});
						
					} else if(result.value.format === Office.MailboxEnums.AttachmentContentFormat.Base64) {
						//console.log(`Attachment content loaded successfully: ${result.asyncContext.nombreFichero}`);
						
						resolve({ message: 'Success', attachID: result.asyncContext.attachID, attachName: result.asyncContext.nombreFichero, attachContent: result.value.content });
						
					} else {
						//console.log(`Error al descargar el fichero: ${result.asyncContext.nombreFichero} :::: FileType :::: ${result.value.format}`);
						
						resolve({ message: `Error al descargar el fichero: ${result.asyncContext.nombreFichero} :::: FileType :::: ${result.value.format}`});
					}
				}
			);
		});
	}
	
	function processMetadata(fileContent, attachmentName) {
		return new Promise(resolve => {
			bstr = atob(fileContent), 
            n = bstr.length, 
            u8arr = new Uint8Array(n);
            
			while(n--) {
				u8arr[n] = bstr.charCodeAt(n);
			}
			
			let formData = new FormData();
			let tipo_licencia = " -Trial_License-";
								
			if(content.enterpriseLicense != null && content.enterpriseLicense.length > 0) {
				formData.append('licenseType', content.enterpriseLicense);
				tipo_licencia = " -Professional_License-";
			}
							
			if(content.enableMetaCleanPDFSigned) {
				formData.append('forcePdfProcess', 'force');
				//formData.append('forceWordProcess', 'force');
			}
			
			formData.append('appName', 'MetaCleanForOutlook_New v.2.2.0 (' + Office.context.platform + ') :::: ' + content.emailSender + " :::: " + tipo_licencia);
			formData.append('enabledFileTypes', content.getSupportedExtensions());
			formData.append('file', new File([u8arr], attachmentName));
					
			fetch(content.urlService, {
				method: 'POST',
				body: formData,
				signal: timeoutFetch(60).signal
										
			}).then(function(response) {
				if(response.ok) {
					let ct = response.headers.get("content-type") || "";
											
					if ( (ct.indexOf('xml') > -1) || (ct.indexOf('json') > -1) ) {
						response.json().then(data => {
							let output = data[0];
							let mensajeSalida = (output.msgError.length > 0) ? output.msgError : output.msgOut;
							let processsedFileURL = "";
							
							if( (mensajeSalida === "Metadata removed successfully" || (mensajeSalida.startsWith("Track c") && mensajeSalida.includes("activated in the document"))) 
								&& output.serverURL != null && output.serverURL.toLowerCase().startsWith("http")) {
								
								//Usamos la funcion: Normalize para eliminar los acentos de los nombres de los ficheros.
								const urlToFile = output.serverURL + "?fileID=" + encodeURIComponent(output.dataFileId) + "&originalFileName=" + encodeURIComponent(output.dataFileName.normalize("NFD").replace(/[\u0300-\u036f]/g, "")) + "&outlookRequest=newOutlook";
								processsedFileURL = new String(urlToFile);
								
								//console.log("urlToFile: " + urlToFile + " output.dataFileName: " + output.dataFileName);
							}
							
							resolve({
								message: mensajeSalida,
								blobFile: processsedFileURL,
								responseCode: response.status,
								fileName: attachmentName
							});
						})
													
					} else {
						response.blob().then(miBlob => {
							resolve({
								message: 'Success',
								blobFile: miBlob,
								responseCode: response.status,
								fileName: attachmentName
							});
						})
					}
												
				} else {
					resolve({
						message: 'Server response failed' + (response.message != null ? ' :::: ' + response.message : ''),
						blobFile: "",
						responseCode: response.status != null ? response.status:"",
						fileName: attachmentName
					});
				}
										
			}).catch(function(error) {
				let messageError = 'Server response failed :::: ' + ( (error.message != null && error.message === 'Failed to fetch') ? ' Please check your network connection and try again.' : error.message);
				
				console.log('Error Fetch :::: ' + attachmentName + ' :::: ' + messageError);
				
				resolve({
					message: messageError,
					blobFile: "",
					responseCode: 500,
					fileName: attachmentName
				});
			});
		
		});
	}	
	
	function removeAttachment(attachmentName, attachmentID) {
		return new Promise(resolve => {
			mailboxItem.removeAttachmentAsync(
				attachmentID,
				{ asyncContext : { nombreFichero: attachmentName} },
				function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded) {
						console.log(`Error al borrar el fichero: ${result.asyncContext.nombreFichero} :::: ${result.error.message}`);
								
						resolve({ message: result.error.message });
								
					} else {
						//console.log(`Attachment removed successfully: ${result.asyncContext.nombreFichero}`);
								
						resolve({ message: 'Success' });
					}
				}
			);
		});
	}
	
	function addBase64Attachment(blob, attachmentName) {
		return new Promise(resolve => {
            //base64String = "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAAAsSAAALEgHS3X78AAACRUlEQVRYw82XzXHbMBCFP2F8tzsQc8Ixyh0zoiuIXIGdCsxUYKqC0B04FdiuwMoM7mGOOIXqQGoAymXhgSX+itJM9kIRFLAP+3YXD5Pdbscx5oxaAIW8Ztr6l2PWmQwF4IyaieP53qdfAqQ8CwBn1JU4vpWhrbxXQA5MZfynANmcDIAzKgcy4FKGXsVJFf3nLgKyBQptfT4KQMRz2N0fcbxqmRMDWXflx0VPnrdArq0vekQ1Dv0UeHZGNebHhwjU8AzwKM43RyZnbAf58Q6ghudeWd0Aus0+5EcMIIRi3beua0D3Nm39BEAx3i7HTK4DEBJn5YxKOnaRA5+ErpMBWMpzDvx1RuXCcxOISlufAjfC7zgAsqsvUvMAD0ApPaEtGi9AIlUzKgJo60tt/SyKRkzLrAXERluf7W1gOICWaMyB386oooOWsIHvXbSoHuUSFovtHqicUVnH3EJoeT0aQEf5/XBGlc6otIOWBXAtPeZkAIJ9Bt6cUU9tZautX2nrk3MACHYr1ZKProKRtDw4o8pzAPjWo+NtpXTTvoteDDg8noDAcwbcRedAkGdFXyk2GEDcegVAFp2gyVDHjRQ4o6q2smoqtR5Hd+qMqtoALCWUUymr1m43QMZfOaMK4C0SrMsDANJ2E5FNcbdbjHC+ENl+H0myJFbLtaq4Rt8dyPBYRQV1E40nMv9rl7xrOw3DGb+Whcqu3i/OM6CUOWvgRlufNmnLYy4m77uJI7AXtdNcTDrU71LEyv7v01/N/ovL6bmu5/8A1tNWZldH0W4AAAAASUVORK5CYII=";
            
			if(blob instanceof String) {
				try {
					mailboxItem.addFileAttachmentAsync(
						blob.valueOf(),
						attachmentName,
						{ isInline: false },
						function(result) {
							if (result.status === Office.AsyncResultStatus.Succeeded) {
								//console.log(`Attachment added successfully`);
									
								resolve({ message: 'Success'});
								  
							} else {
								console.error(`addFileAttachmentAsync: ${result.error}`);
								resolve({ message: result.error.message });
							}
						});
				} catch (e) {
					//console.log("Error in UpdateProgessBar ---> " + e.message);
					let mensajeError = (e.message != null && e.message.length > 0) ? e.message : '---';
					resolve({ message: mensajeError });
				}
					
			} else {
				let reader = new FileReader();
				reader.readAsDataURL(blob);
				
				reader.onloadend = function() {
					try {
						mailboxItem.addFileAttachmentFromBase64Async(
							reader.result.split(',')[1],
							attachmentName,
							{ isInline: false },
							function(result) {
								if (result.status === Office.AsyncResultStatus.Succeeded) {
									//console.log(`Attachment added successfully`);
									
									resolve({ message: 'Success'});
								  
								} else {
									console.error(`addFileAttachmentFromBase64Async: ${result.error}`);
									resolve({ message: result.error.message });
								}
						});
					} catch (e) {
						//console.log("Error in UpdateProgessBar ---> " + e.message);
						let mensajeError = (e.message != null && e.message.length > 0) ? e.message : '---';
						resolve({ message: mensajeError });
					}
				}
			}
		});
	}
	
	function delay(time) {
		return new Promise(resolve => setTimeout(resolve, time));
	}
		
	var content = {
		getSupportedExtensions() {
			let tmp = (content.enableMetaCleanMSOffice?"mo,":"") + (content.enableMetaCleanOpenOffice?"oo,":"") + (content.enableMetaCleanPDF?"pdf,":"") + (content.enableMetaCleanMultimedia?"mm":"");
			tmp = tmp.endsWith(",")?tmp.slice(0, -1):tmp;
			
			return tmp;
		},
		isSupportedFormat(extensionFile) {
			if ( (content.enableMetaCleanMSOffice && content.microsoftOfficeExtensions.includes(extensionFile)) || (content.enableMetaCleanOpenOffice && content.openOfficeExtensions.includes(extensionFile)) || (content.enableMetaCleanPDF && content.pdfExtensions.includes(extensionFile)) 
				|| (content.enableMetaCleanCompressed && content.compressedExtensions.includes(extensionFile) && (content.enableMetaCleanMSOffice || content.enableMetaCleanOpenOffice || content.enableMetaCleanPDF || content.enableMetaCleanMultimedia)) 
			|| (content.enableMetaCleanMultimedia && content.multimediaExtensions.includes(extensionFile)) )
				return true;
			else
				return false;
		},
		extractEmails(text) {
			let results = text.match(/([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9_-]+)/gi);
			
			if(results != null && results.length > 0)
				return results[0];
			else
				return "";
		},
		microsoftOfficeExtensions: ["doc", "dot", "docx", "docm", "dotx", "dotm", "xls", "xlt", "xlsx", "xlsm", "xltx", "xltm", "xlsb", "ppt", "pot", "pptx", "pptm", "potx", "potm", "ppsx", "ppsm", "vsd", "rtf"],
		multimediaExtensions: [
			"mp3", "arw", "cr2", "dng", "fff", "cs1", "erf", "iiq", "mef", "mrw", "nef", "nrw", "orf", "pef", "raf", "raw", "rw2", "rwl", "sr2", "srw", "x3f", "3g2", "3gp2", "3gp", "3gpp", "dvb", "f4a", "f4b", "f4p", "f4v", "m4a", "m4b", "m4p", "m4v", "mov", "qt", "mp4", "mqv", "qtif", "qti", "qif", "dcp", "exv", "gif", "hdp", "wdp", "jxr", "jp2", "icc", "icm", "jpf", "j2k", "jpm", "jpx", "jpeg", "jpg", "jpe", "mie", "mos", "mpo", "png", "jng", "mng", "psd", "psb", "thm", "tiff", "tif", "vrd", "dng", "aax", "ai", "ait", "arq", "avif", "crw", "cr3", "crm", "ciff", "dr4", "eps", "ps", "epsf", "exif", "flif", "gpr", "heic", "heif", "hif", "lrv", "xmp" 
		],
		openOfficeExtensions: ["odt", "ods", "odp"],
		compressedExtensions: ["zip", "7z"],
		pdfExtensions: ["pdf"],
		fileBuffer: [],
		composeNotice: null,
		fileNameMessages: [],
		enableMetaCleanPlugIn: true,
		enableMetaCleanMSOffice: true,
		enableMetaCleanOpenOffice: true,
		enableMetaCleanPDF: true,
		enableMetaCleanMultimedia: false,
		enableMetaCleanCompressed: true,
		enableMetaCleanPDFSigned: false,
		enableMetaCleanTrackChanges: true,
		urlService: 'https://metaclean.es/MetaCleanOnline/service/file',
		emailSender: "",
		enabledFileTypes: "",
		webServiceUrlRetrieved: false,
		personalEmailSender: false,
		enterpriseLicense: "Corporativo"
	}
	
	function getWebServiceUrl() {
		return new Promise(resolve => {
			try {
				let emailDomain = "";
				
				if(content.emailSender.length === 0 || !content.emailSender.includes("@")) {
					content.personalEmailSender = true;
					resolve('No se ha obtenido la direccion de email del cliente: ' + content.emailSender);
				} else
					emailDomain = content.emailSender.split("@")[1];
				
				if(emailDomain.startsWith("outlook.") || emailDomain.startsWith("hotmail.") || emailDomain.startsWith("live.com")) {
					content.webServiceUrlRetrieved = true;
					content.personalEmailSender = true;
					resolve('Usuario no corporativo: ' + content.emailSender);
					
				} else if(!content.webServiceUrlRetrieved) {
					let formData = new FormData();
					formData.append('urlWebServiceFromClient', content.emailSender);
					formData.append('tipoApp', 1);
										
					fetch('https://www.adarsus.com/bat/emailExtension/activation.php', {
						method: 'POST',
						headers: { 'cache-control': 'no-cache' },
						body: formData,
						signal: timeoutFetch(10).signal
					}).then(response => {
						if (response.ok) {
							response.text()
								.then(responseText => {
									if(responseText.length > 0) {
										if(responseText.startsWith("http")) {
											content.urlService = responseText;											
										}
										content.enterpriseLicense = "Corporativo";
									}
																
									content.webServiceUrlRetrieved = true;
									resolve(responseText);
														
								}).catch((error) => { resolve("No se han podido obtener el texto de la respuesta :::: " + error.message) });
														
						} else 
							resolve('response no devuelve OK :::: ' + response.message);
										
					}).catch((error) => { resolve("Excepcion en la salida fetch :::: " + error.message) });
								
				} else
					resolve("Web Service URL se estableció previamente a: " + urlService + " para el usuario: " + content.emailSender);
				
			} catch(error) {
				resolve("Error en la ejecucion Promise :::: " + error.message)
			}
		});
	}
	
document.addEventListener('DOMContentLoaded', function() {
	//let _settings = null;
	
	$(document).ready(function() {
		$('input').lc_switch();
		
		let $input = $("#app input"), $appendHere = $(".tagHere"), oldKey = 0, newKey, TABKEY = 9, ENTERKEY = 13;
		
		//$input.focus();
		  
		$input.keydown(function(e) {
			if(e.keyCode == TABKEY || e.keyCode == ENTERKEY) {
				if(e.preventDefault) {
					e.preventDefault();
					
					if($(this).val() == '' || $(this).val() == ' ')
						return false;
					
					addDomain($(this));
				}
				return false;
			}
			
			//if($(this).val() == '' && e.keyCode === 8) //Elimina el ultimo elemento
				//$(".tag:last-child").remove();
		})
		  
		function addDomain(element) {
			let addNewDomain = getDomain($(element).val());
			
			if(addNewDomain.length == 0) {
				return false;
				
			} else {
				let saveNewDomain = addNewDomain;
				if(_settings.get("MetaCleanWhiteList") != null && _settings.get("MetaCleanWhiteList") != undefined)
					saveNewDomain += "|" +_settings.get("MetaCleanWhiteList");
				
				_settings.set("MetaCleanWhiteList", saveNewDomain);
		
				// Save All settings in the mailbox to make it available in future sessions.
				_settings.saveAsync(function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded) {
						console.error('Action failed with message ' + result.error.message);
						
					} else {
						//console.log('[' + (new Date()).toUTCString() + '] WhiteList saved values: ' + _settings.get("MetaCleanWhiteList"));
						
						let $tag = $("<div />"), $a = $("<a href='#' />"), $span = $("<span />");
						$tag.addClass('tag');
						$('<i class="fa fa-times" aria-hidden="true"></i>').appendTo($a);
						
						$span.text(addNewDomain);
						
						$a.bind('click', function() {
							$(this).parent().remove();
							$(this).unbind('click');
							
							let savedDomains = _settings.get("MetaCleanWhiteList");
							let removeDomain = $(this).parent().text();
							
							if(savedDomains.includes("|" + removeDomain))
								removeDomain = "|" + removeDomain;
							else if(savedDomains.includes(removeDomain + "|"))
								removeDomain = removeDomain + "|";
								
							savedDomains = savedDomains.replace(removeDomain, "");
							
							_settings.set("MetaCleanWhiteList", savedDomains);
							_settings.saveAsync();
							
							//console.log('contenido --> ' + savedDomains);
						});
						
						$a.appendTo($tag);
						$span.appendTo($tag);
						$tag.appendTo($appendHere);
						
						$(element).val('');
					}
				});
			}
		}
		  
		function getDomain(content) {
			let parts = content.split('@');
			let domain = parts[parts.length-1].trim().toLowerCase();
			let checkDomain = domain.split('.');
			
			if(checkDomain.length < 2 || checkDomain[checkDomain.length-1].length < 2 || domain.includes(" ")) {
				return "";
				
			} else {
				let savedDomain = _settings.get("MetaCleanWhiteList");
				
				if(savedDomain != null && savedDomain != undefined && savedDomain.includes(domain))
					return "";
				
				return domain;
			}
		}
		
		function addInitialDomains(domain) {
			let $tag = $("<div />"), $a = $("<a href='#' />"), $span = $("<span />");
			$tag.addClass('tag');
			$('<i class="fa fa-times" aria-hidden="true"></i>').appendTo($a);
			$span.text(domain);
			
			$a.bind('click', function() {
				$(this).parent().remove();
				$(this).unbind('click');
				
				let savedDomains = _settings.get("MetaCleanWhiteList");
				let removeDomain = $(this).parent().text();
							
				if(savedDomains.includes("|" + removeDomain))
					removeDomain = "|" + removeDomain;
				else if(savedDomains.includes(removeDomain + "|"))
					removeDomain = removeDomain + "|";
								
				savedDomains = savedDomains.replace(removeDomain, "");
							
				_settings.set("MetaCleanWhiteList", savedDomains);
				_settings.saveAsync();
							
				//console.log('contenido --> ' + savedDomains);
			});
			
			$a.appendTo($tag);
			$span.appendTo($tag);
			$tag.appendTo($appendHere);
		}
		
		Office.initialize = function (reason) {
			mailboxItem = Office.context.mailbox.item;
			
			// Get the resource strings that match the language.
			// Use the UIStrings object from the UIStrings.js file
			// to get the JSON object with the correct localized strings.
			let UIText = UIStrings.getLocaleStrings(Office.context.displayLanguage);

			$("#titleH1MetaClean").text(UIText.titleH1MetaClean);
			$("#OfficeDocuments legend").text(UIText.legendOfficeDocuments);
			$("#LabelPDFSigned").text(UIText.legendLabelSignedFiles);
			$("#MultimediaFiles legend").text(UIText.legendMultimediaFiles);
			$("#MultimediaFiles label").text(UIText.legendLabelMultimediaFiles);
			$("#CompressedFiles legend").text(UIText.legendCompressedFiles);
			$("#CompressedFiles label").text(UIText.legendLabelCompressedFiles);
			$("#TrackChangesFiles legend").text(UIText.legendTrackChangesFiles);
			$("#TrackChangesFiles label").text(UIText.legendLabelTrackChangesFiles);
			$("#WhiteList legend").text(UIText.legendWhiteList);
			
			_settings = Office.context.roamingSettings;
			
			let loadWhiteList = _settings.get("MetaCleanWhiteList");
			
			if(loadWhiteList != null && loadWhiteList != undefined) {
				let whiteListArr = loadWhiteList.split('|');
				
				for (let zz = 0; zz < whiteListArr.length; zz++) {
					if(whiteListArr[zz].length > 3)
						addInitialDomains(whiteListArr[zz]);
				}
			}
		
			// Read storage
			//console.log('_settings.get("MetaCleanAddIn"): ' + _settings.get("MetaCleanAddIn"));
		
			//First run, default settings.
			if(_settings.get("MetaCleanAddIn") == null || _settings.get("MetaCleanAddIn") === undefined) {
				$('#MetaCleanMSOffice').lcs_on();
				$('#MetaCleanOpenOffice').lcs_on();
				$('#MetaCleanPDF').lcs_on();
				$('#MetaCleanCompressed').lcs_on();
				$('#MetaCleanTrackChanges').lcs_on();
					
				let date = new Date();
				
				//console.log('[' + (new Date()).toUTCString() + '] MetaClean AddIn First Run');
					
				_settings.set("isFirstRun", 'initialized');
				_settings.set("installDate", date.getDate() + "/" + (date.getMonth() + 1)  + "/" + date.getFullYear());
				_settings.set("MetaCleanAddIn", 'MetaCleanMSOfficeMetaCleanPDFMetaCleanOpenOfficeMetaCleanCompressedMetaCleanTrackChanges');
						
				// Save All settings in the mailbox to make it available in future sessions.
				_settings.saveAsync(function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded)
						console.error('Action failed with message ' + result.error.message);
					//else
						//console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
				});
					
			} else {
				let addinEnabledFor = _settings.get("MetaCleanAddIn");
					
				if(addinEnabledFor.includes("MetaCleanMSOffice"))
					$('#MetaCleanMSOffice').lcs_on();
				else
					$('#MetaCleanMSOffice').lcs_off();
					
				
				if(addinEnabledFor.includes("MetaCleanOpenOffice"))
					$('#MetaCleanOpenOffice').lcs_on();
				else
					$('#MetaCleanOpenOffice').lcs_off();
					
					
				if(addinEnabledFor.includes("MetaCleanPDF")) {
					$('#MetaCleanPDF').lcs_on();
					
					$('#PDFSigned').parent().parent().show();
					
					if(addinEnabledFor.includes("PDFSigned"))
						$('#PDFSigned').lcs_on();
					else
						$('#PDFSigned').lcs_off();
					
				} else {
					$('#MetaCleanPDF').lcs_off();
					$('#PDFSigned').lcs_off();
					$('#PDFSigned').parent().parent().hide();
				}
					
				if(addinEnabledFor.includes("MetaCleanMultimedia"))
					$('#MetaCleanMultimedia').lcs_on();
				else
					$('#MetaCleanMultimedia').lcs_off();
					
					
				if(addinEnabledFor.includes("MetaCleanCompressed"))
					$('#MetaCleanCompressed').lcs_on();
				else
					$('#MetaCleanCompressed').lcs_off();
				
				if(addinEnabledFor.includes("MetaCleanTrackChanges"))
					$('#MetaCleanTrackChanges').lcs_on();
				else
					$('#MetaCleanTrackChanges').lcs_off();
			}
		}  
	});
	
    // triggered each time a field is checked
    $(document).on('lcs-on', '.lcs_check', function(event) {
		let component = this.id;
		let addinEnabledFor = _settings.get("MetaCleanAddIn");
		
		if(component == 'MetaCleanPDF') {
			$('#PDFSigned').parent().parent().show();
			
			if(addinEnabledFor.includes('PDFSigned'))
				addinEnabledFor = addinEnabledFor.replace('PDFSigned','');
		}
		
		if(!addinEnabledFor.includes(component))
			addinEnabledFor += component;
		else
			return true;
		
		_settings.set("MetaCleanAddIn", addinEnabledFor);
		
		// Save All settings in the mailbox to make it available in future sessions.
		_settings.saveAsync(function(result) {
			if (result.status !== Office.AsyncResultStatus.Succeeded)
				console.error('Action failed with message ' + result.error.message);
			else
				console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
		});
	});
        
    // triggered each time a is unchecked
    $(document).on('lcs-off', '.lcs_check', function() {
		let component = this.id;
		let addinEnabledFor = _settings.get("MetaCleanAddIn");
		
		if(component == 'MetaCleanPDF') {
			$('#PDFSigned').lcs_off();
			$('#PDFSigned').parent().parent().hide();
			
			if(addinEnabledFor.includes('PDFSigned'))
				addinEnabledFor = addinEnabledFor.replace('PDFSigned','');
		}
		
		if(addinEnabledFor.includes(component))
			addinEnabledFor = addinEnabledFor.replace(component,'');
		else
			return true;
		
		_settings.set("MetaCleanAddIn", addinEnabledFor);
		
		// Save All settings in the mailbox to make it available in future sessions.
		_settings.saveAsync(function(result) {
			if (result.status !== Office.AsyncResultStatus.Succeeded)
				console.error('Action failed with message ' + result.error.message);
			else
				console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
		});
    });
	
}, false);