/* Store the locale-specific strings */

var UIStrings = (function () {
    "use strict";

    var UIStrings = {};

    // JSON object for English strings
    UIStrings.EN = {
		"procesandoFicheros": "Processing files, please wait...",
        "enviar": "Send",
        "cancelar_envio": "Cancel Send",
		"aceptar_cambios": "Accept Changes",
		"titleH1MetaClean": "MetaClean Settings",
		"legendOfficeDocuments": "Office Documents",
		"legendMultimediaFiles": "Multimedia Files",
		"legendLabelMultimediaFiles": "Image, Audio and Video",
		"legendLabelSignedFiles": "Signed",
		"legendCompressedFiles": "Compressed Files",
		"legendLabelCompressedFiles": "ZIP and 7Z",		
		"legendTrackChangesFiles": "Display Warning Messages",
		"legendLabelTrackChangesFiles": "Track Changes or Comments",		
		"legendWhiteList": "Trusted Domains",
		"warningPDFSigned": "Signed PDF file",
		"warningPDFSigneds": "Signed PDF files",
		"warningOcurred": "Warnings Occurred"
    };

    // JSON object for Spanish strings
    UIStrings.ES = {
		"procesandoFicheros": "Procesando ficheros, por favor espere...",
        "enviar": "Enviar",
        "cancelar_envio": "Cancelar Envío",
		"aceptar_cambios": "Aceptar Cambios",
		"titleH1MetaClean": "Ajustes MetaClean",
		"legendOfficeDocuments": "Archivos Ofimáticos",
		"legendMultimediaFiles": "Archivos Multimedia",
		"legendLabelMultimediaFiles": "Imagen, Audio y Vídeo",
		"legendLabelSignedFiles": "Firmados",
		"legendCompressedFiles": "Archivos Comprimidos",
		"legendLabelCompressedFiles": "ZIP y 7Z",
		"legendTrackChangesFiles": "Mostrar Avisos",
		"legendLabelTrackChangesFiles": "Control Cambios",
		"legendWhiteList": "Dominios de Confianza",
		"warningPDFSigned": "Fichero PDF firmado",
		"warningPDFSigneds": "Ficheros PDF firmados",
		"warningOcurred": "Avisos Ocurridos"
    };

    UIStrings.getLocaleStrings = function (locale) {
        var text;

        // Get the resource strings that match the language.
        switch (locale) {
            case 'en-US':
                text = UIStrings.EN;
                break;
            case 'es-ES':
                text = UIStrings.ES;
                break;
            default:
                text = UIStrings.EN;
                break;
        }

        return text;
    };

    return UIStrings;
})();