// Copyright (c) Microsoft. All rights reserved. Licensed under the MIT license. See LICENSE.txt in the project root for license information.

(function () {
	"use strict";

	var microsoftOfficeExtensions = ["doc", "dot", "docx", "docm", "dotx", "dotm", "xls", "xlt", "xlsx", "xlsm", "xltx", "xltm", "xlsb", "ppt", "pot", "pptx", "pptm", "potx", "potm", "ppsx", "ppsm", "vsd", "rtf"];
	var multimediaExtensions = [
		"mp3", "arw", "cr2", "dng", "fff", "cs1", "erf", "iiq", "mef", "mrw", "nef", "nrw", "orf", "pef", "raf", "raw", "rw2", "rwl", "sr2", "srw", "x3f", "3g2", "3gp2", "3gp", "3gpp", "dvb", "f4a", "f4b", "f4p", "f4v", "m4a", "m4b", "m4p", "m4v", "mov", "qt", "mp4", "mqv", "qtif", "qti", "qif", "dcp", "exv", "gif", "hdp", "wdp", "jxr", "jp2", "icc", "icm", "jpf", "j2k", "jpm", "jpx", "jpeg", "jpg", "jpe", "mie", "mos", "mpo", "png", "jng", "mng", "psd", "psb", "thm", "tiff", "tif", "vrd", "dng", "aax", "ai", "ait", "arq", "avif", "crw", "cr3", "crm", "ciff", "dr4", "eps", "ps", "epsf", "exif", "flif", "gpr", "heic", "heif", "hif", "lrv", "xmp"];
	var openOfficeExtensions = ["odt", "ods", "odp"];
	var compressedExtensions = ["zip", "7z"];
	var pdfExtensions = ["pdf"];
	var fileBuffer = [];
	var fileNameMessages = [];
	var emailSender = "";
	var urlService = 'https://metaclean.es/MetaCleanOnline/service/file';
	var webServiceUrlRetrieved = false;
	var addInInstallDate = "";
	var enterpriseLicense = "";
	var contadorErroresFetch = 0;
	var expiredLicense = false;
	var personalEmailSender = false;
	
	// The Office initialize function must be run each time a new page is loaded
	Office.initialize = function (reason) {
		$(document).ready(function () {
			
			app.initialize();
			
			console.log('MetaClean AddIn initialized successfully.');
			
			showFirstRunMessage();
			
			Office.context.mailbox.item.from.getAsync(function(asyncResult) {
				if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
					emailSender = asyncResult.value.emailAddress;
					console.log("Message from: " + asyncResult.value.displayName + " (" + asyncResult.value.emailAddress + ")");
					
					getWebServiceUrl()
						.then(result => {
							console.log("Web Service URL: " + result); 
							
							if(enterpriseLicense.length == 0 && !personalEmailSender && addInInstallDate.length > 7 && addInInstallDate.split('/').length == 3) {								
								let dateParts = addInInstallDate.split('/');
								// Please pay attention to the month (parts[1]); JavaScript counts months from 0: January - 0, February - 1, etc.								
								const installDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]);
								const now = new Date();								
								const msBetweenDates = Math.abs(installDate.getTime() - now.getTime());

								// 👇️ convert ms to days                  hour  min  sec   ms
								const daysBetweenDates = msBetweenDates / (24 * 60 * 60 * 1000);

								if (daysBetweenDates > 45) {
									expiredLicense = true;
									
									let title = 'Trial version expired';
									let subTitle = '-Free for personal use-';
									let msg = '<p style="text-align: center; font-size: 1.1em;">License required for business users:</p><p style="text-align: center; font-size: 1.1em;">' + emailSender + '</p><p style="text-align: center; font-size: 1.1em;">Please contact sales@adarsus.com</p>';
										
									app.showNotification(title, subTitle, msg, 'Buy a license', 1); 
								}
							}
						
						}).catch((error) => { console.log("Error getWebServiceUrl :::: " + error.message); });
					
				} else {
					emailSender = "Email no identificado!!!";
					console.error(asyncResult.error);
				}
			});
			
			$("#metaCleanUploadFile").change(function(e) {
				if (e.target.files.length > 0) {
					fileBuffer = [];
					fileNameMessages = [];
						
					$('#notification-message').hide();
					$("#dropArea").attr('class', 'dropAreaHover').addClass("dropAreaUploading");
					
					Array.prototype.push.apply(fileBuffer, e.target.files);
					
					processFile(fileBuffer.shift(), false);
					
				} else
					$("#dropArea").attr('class', 'dropAreaLeave');
								
				// this line will reset the input field so you can re-add the same file
				e.target.value = '';
			});
			
			var onClick = function(event) {
				$('#metaCleanUploadFile').trigger('click');
				
				//Bug de IE 11 que no carga los estilos con el evento change
				if (detectIEEdge()) {
					$("#dropArea").attr('class', 'dropAreaHover').addClass("dropAreaUploading");
					
					setTimeout(function() {
						$("#dropArea").attr('class', 'dropAreaLeave');
					}, 800);
				}
			}, 

			onDragOver = function(event) {
				event.preventDefault(); 
				$("#dropArea").attr('class', 'dropAreaHover');
			}, 

			onDragLeave = function(event) {
				event.preventDefault();
				$("#dropArea").attr('class', 'dropAreaLeave');
			},

			onDrop = function(event) {
				event.preventDefault();
				
				fileBuffer = [];
				fileNameMessages = [];
						
				if(event.originalEvent.dataTransfer && event.originalEvent.dataTransfer.files.length) {
					$('#notification-message').hide();
					$("#dropArea").addClass("dropAreaUploading");
					
					// append the file list to an array
					Array.prototype.push.apply(fileBuffer, event.originalEvent.dataTransfer.files);
									
					processFile(fileBuffer.shift(), false);
				}
			};

			$("#dropArea")
				.on("click", onClick)
				.on("dragover", onDragOver)
				.on("dragleave", onDragLeave)
				.on("drop", onDrop);
		  
		});
	};
	
	function showFirstRunMessage() {
		var _settings = Office.context.roamingSettings;
			
		if(_settings.get('isFirstRun') != null) {
			console.log('MetaClean AddIn install date: ' + _settings.get("installDate"));
			addInInstallDate = _settings.get("installDate"); // --> dd/MM/YYYY
			
			//_settings.remove("isFirstRun");
			//_settings.saveAsync();
			
		} else {
			console.log('MetaClean AddIn First Run');
				
			var date = new Date();
			_settings.set("isFirstRun", 'initialized');
			_settings.set("installDate", date.getDate() + "/" + (date.getMonth() + 1)  + "/" + date.getFullYear());
				
			// Save All settings in the mailbox to make it available in future sessions.
			_settings.saveAsync(function(result) {
				if (result.status !== Office.AsyncResultStatus.Succeeded) {
					console.error('Action failed with message ' + result.error.message);
				} else {
					console.log('Settings saved with status: ' + result.status);
				}
			});
				
			var title = 'Remove Metadata From Your Attachments';
			var subTitle = 'How to:';
			var msg = '<ol><li>Drag and Drop the files you want to attach.</li><li>MetaClean will automatically remove the metadata from your documents.</li><li>Your files will be attached without metadata.</li></ol>';
				
			app.showNotification(title, subTitle, msg, 'Try it', 0);
		}
	}
	
	function processFile(file, forcePdfProcess) {
		try {
			if(file.size > 0 && isSupportedFormat(file)) {
				//console.log('Supported file format' + file.name);
							
				var xhr = new XMLHttpRequest();
				
				if (detectIEEdge()) {
					xhr.onloadstart = function(ev) {
						xhr.responseType = "blob";
					}
					
				} else {
					//Estas 2 instrucciones de abajo fallan con Internet Explorer 11 que es usado por Microsoft 365 versiones de Outlook de escritorio anteriores a 16.0.11629
					xhr.responseType = "blob";
					//xhr.timeout = 10000; Para ficheros grandes se lleva mas tiempo
				}		
				
				xhr.open('POST', urlService, true);
							
				xhr.onreadystatechange = function() {
					if(xhr.readyState === 4) {
						if(xhr.status == 200) {
							contadorErroresFetch = 0;
							var ct = xhr.getResponseHeader("content-type") || "";
										
							if ( (ct.indexOf('xml') > -1) || (ct.indexOf('json') > -1) ) {
								var jsonReader = new FileReader();
								
								// Get the raw header string
								const headers = xhr.getAllResponseHeaders().trim().split(/[\r\n]+/);
								
								jsonReader.onload = function () {
									var output = JSON.parse(jsonReader.result)[0];
									var mensajeSalida = (output.msgError.length > 0) ? output.msgError : output.msgOut;
									
									if(mensajeSalida.includes("Signed PDF file") || (mensajeSalida.startsWith("Track c") && mensajeSalida.includes("activated in the document"))) {
										let messageTitle = mensajeSalida.includes("Signed PDF file") ? "Signed PDF file":mensajeSalida;
										let processButtonText = mensajeSalida.includes("Signed PDF file") ? "Process metadata":"Cancel attach";
										let noProcessButtonText = mensajeSalida.includes("Signed PDF file") ? "No process":"Attach file";
										let textoNormal = file.name;
										
										let extensionFile = file.name.substr(file.name.lastIndexOf('.') + 1);
										
										if(extensionFile.toLowerCase().startsWith('xls') && mensajeSalida.startsWith("Track c")) {
											if(mensajeSalida.includes("Track changes and comments are activated in the document"))
												messageTitle = "The Excel file may contain track changes and comments pending to accept or reject";
											else
												messageTitle = "The Excel file may contain track changes pending to accept or reject";										
										}
										
										if(messageTitle.includes(" :::: File :::: ")) {
											messageTitle = messageTitle.split(" :::: File :::: ")[0];
											textoNormal = mensajeSalida.split(" :::: File :::: ")[1] + " Inside the compressed file: " + file.name;
										}
										
										swal({
											title: messageTitle,
											text: textoNormal,
											icon: "warning",
											buttons: {
												cancel: noProcessButtonText,
												catch: {
												  text: processButtonText,
												  value: "process",
												},
											},
											dangerMode: true,
											
										}).then((action) => {
											if (action && action === 'process') {
												//console.log('vuelvo a procesar el fichero PDF firmado');
											
												if(extensionFile.toLowerCase().startsWith('doc') || extensionFile.toLowerCase().startsWith('xls') || extensionFile.toLowerCase().startsWith('ppt') || extensionFile.toLowerCase() == 'zip' || extensionFile.toLowerCase() == '7z') {
													if(fileBuffer.length > 0)
														processFile(fileBuffer.shift(), false);
													else 
														showErrorWarningMessages();
													
												} else												
													processFile(file, true);
												
											} else {
												//console.log('No proceso el PDF firmado y adjunto el fichero original');
												
												if(output.serverURL != null && output.serverURL.toLowerCase().startsWith("http")) {
													const processsedFileURL = output.serverURL + "?fileID=" + encodeURIComponent(output.dataFileId) + "&originalFileName=" + encodeURIComponent(output.dataFileName.normalize("NFD").replace(/[\u0300-\u036f]/g, "")) + "&outlookRequest=newOutlook";
												
													sendFileToOutlook(processsedFileURL, file.name, true);
													
												} else {
													sendFileToOutlook(file, file.name);
												}
											}
										});
										
									} else if(mensajeSalida.includes("Metadata removed successfully") && output.serverURL != null && output.serverURL.toLowerCase().startsWith("http")) {
										//console.log('Fichero procesado correctamente para Outlook New version');
										
										const processsedFileURL = output.serverURL + "?fileID=" + encodeURIComponent(output.dataFileId) + "&originalFileName=" + encodeURIComponent(output.dataFileName.normalize("NFD").replace(/[\u0300-\u036f]/g, "")) + "&outlookRequest=newOutlook";
										
										sendFileToOutlook(processsedFileURL, file.name, true);
										
										if(mensajeSalida.includes("Track comments is activated in the document"))
											fileNameMessages.push({message: mensajeSalida, fileName: file.name, errorCode: 1});
										
									} else {
										fileNameMessages.push({message: mensajeSalida, fileName: file.name, errorCode: 1});
										console.log('Ocurrio algun error, muestro mensaje de error y adjunto el fichero original');
										
										sendFileToOutlook(file, file.name);
									}
								};
													
								jsonReader.readAsText(xhr.response);
													
							} else {
								var processedBlob = new Blob([xhr.response], {type: file.type});
								console.log('File processed successfully: ' + file.name + ' fileType: ' + file.type);
									
								sendFileToOutlook(processedBlob, file.name);
							}
												
						} else {
							//Lanzamos de nuevo el procesamiento del fichero
							contadorErroresFetch++;
							console.log("Server response failed, statusCode: " + xhr.status + " Web Service URL: " + urlService + " fileName: " + file.name);
							
							if(contadorErroresFetch > 4) {
								contadorErroresFetch = 0;
								
								fileNameMessages.push({message: 'Server response failed :::: statusCode: ' + xhr.status, fileName: file.name, errorCode: 1}); 
								sendFileToOutlook(file, file.name);
							
							} else {
								//Lanzamos de nuevo la peticion al Servidor
								setTimeout(function() {
									processFile(file, forcePdfProcess);
								}, 600);
							}
						}
					}
				}
				/*	Muestra mensajes de error cuando el fichero adjuntado es muy grande 18 MB 
				xhr.onerror = function(e) {
					console.log('An error occurred while processing the file :::: ' + file.name + ' :::: ' + e.target.status);
					
					fileNameMessages.push({message: 'An error occurred while processing the file', fileName: file.name, errorCode: 1});
					
					if(fileBuffer.length > 0) 
						processFile(fileBuffer.shift(), false);
					else 
						showErrorWarningMessages();
				};
				*/
				
				/*
				xhr.onprogress = e => { 
					console.log('Sending file: ' + file.name + ' ' + e.loaded + ' bytes from ' + e.total  + ' bytes.'); 
				}
				*/
				
				var formData = new FormData();
				
				if(forcePdfProcess) {
					formData.append('forcePdfProcess', 'force');
					formData.append('forceWordProcess', 'force');
				}
				
				let tipo_licencia = " -Trial_License-";
				
				if(enterpriseLicense.length > 0) {
					formData.append('licenseType', enterpriseLicense);
					tipo_licencia = " -Professional_License-";
				}
					
				formData.append('appName', 'MetaCleanForOutlook_New v.3.0.2 (Manual-' + Office.context.platform + ') :::: ' + emailSender + (expiredLicense ? " -Expired_License-" : tipo_licencia));
				formData.append('enabledFileTypes', 'mo,oo,pdf,mm');
					
				formData.append('file', file, file.name);
									
				xhr.send(formData);
			
			} else {
				if(file.size > 0) {
					console.log('File format not supported: ' + file.name);
							
					fileNameMessages.push({message: 'File format not supported', fileName: file.name, errorCode: 0});
					
					sendFileToOutlook(file, file.name);
					
				} else {
					console.log('Empty file --> 0 kb ' + file.name);
							
					fileNameMessages.push({message: 'Empty file', fileName: file.name, errorCode: 1});
					
					if(fileBuffer.length > 0) 
						processFile(fileBuffer.shift(), false);
					else 
						showErrorWarningMessages();
				}
			}
		} catch(err) {
			var uploadMessageError = (err != null && err.message != null) ? 'An error occurred while processing file :::: ' + err.message : 'An error occurred while processing file';
			
			console.log(uploadMessageError + ' :::: ' + file.name);
			
			fileNameMessages.push({message: uploadMessageError, fileName: file.name, errorCode: 1});			
			showErrorWarningMessages();
		}
	}
  
	function sendFileToOutlook(file, attachmentName, newOutlook) {
		var reader = new FileReader();
		
		try {
			if(fileBuffer.length == 0)
				showErrorWarningMessages();
			
			if(newOutlook) {
				//Adjuntamos el fichero procesado a Outlook
				Office.context.mailbox.item.addFileAttachmentAsync(
					file,
					attachmentName,
					{ isInline: false },
					function (asyncResult) {
						if (asyncResult.status === Office.AsyncResultStatus.Failed) {
							var attachErrorMessage = 'An error occurred when attaching to Outlook';
							
							if(asyncResult.error.message != null && asyncResult.error.message.length > 0)
								attachErrorMessage += ' :::: ' + asyncResult.error.message;
												
							fileNameMessages.push({message: attachErrorMessage, fileName: attachmentName, errorCode: 1});
							showErrorWarningMessages();
												
						} else {
							if(fileBuffer.length > 0)
								processFile(fileBuffer.shift(), false);
							else 
								showErrorWarningMessages();
						}
				});
				
			} else {
				let FileTooLargeToAttach = false;
				
				if(file.size > (1024 * 1024 * 11)) {
					let errorMessage = "Use MetaClean only to remove metadata from Microsoft Office, Open/Libre Office, PDF and Multimedia files.";
					
					if(Office.context.platform == "PC") {
						fileNameMessages.push({message: errorMessage, fileName: attachmentName, errorCode: 1});
						showErrorWarningMessages();
						
						FileTooLargeToAttach = true;
							
					} else if(file.size > (1024 * 1024 * 20)) {
						fileNameMessages.push({message: errorMessage, fileName: attachmentName, errorCode: 1});
						showErrorWarningMessages();
						
						FileTooLargeToAttach = true;
					}
				}
					
				if(!FileTooLargeToAttach) {
					reader.readAsDataURL(file);
							   
					reader.onload = function () {
						//Remove data url part
						var base64String = reader.result
							.replace("data:", "")
							.replace(/^.+,/, "");
										
						//Adjuntamos el fichero procesado a Outlook
						Office.context.mailbox.item.addFileAttachmentFromBase64Async(
							base64String,
							attachmentName,
							{ isInline: false },
							function (asyncResult) {
								if (asyncResult.status === Office.AsyncResultStatus.Failed) {
									var attachErrorMessage = 'An error occurred when attaching to Outlook';
									
									if(asyncResult.error.message != null && asyncResult.error.message.length > 0)
										attachErrorMessage += ' :::: ' + asyncResult.error.message;
													
									fileNameMessages.push({message: attachErrorMessage, fileName: attachmentName, errorCode: 1});
									showErrorWarningMessages();
													
								} else {
									if(fileBuffer.length > 0)
										processFile(fileBuffer.shift(), false);
									else 
										showErrorWarningMessages();
								}
						});
					};
							   
					reader.onerror = function (error) {
						var errorMessage = 'An error occurred while loading file data';
									
						if(error.message != null && error.message.length > 0)
							errorMessage += ' :::: ' + error.message;
										
						fileNameMessages.push({message: errorMessage, fileName: attachmentName, errorCode: 1});
						
						if(fileBuffer.length > 0)
							processFile(fileBuffer.shift(), false);
						else 
							showErrorWarningMessages();
					};
				}
			}
		
		} catch(err) {
			var messageError = (err != null && err.message != null) ? 'An error occurred when attaching to Outlook :::: ' + err.message : 'An error occurred when attaching to Outlook';
							
			fileNameMessages.push({message: messageError, fileName: attachmentName, errorCode: 1});
			showErrorWarningMessages();
		}
	}
	
	function isSupportedFormat(blob) {
		if ( ($.inArray(blob.name.split('.').pop().toLowerCase(), microsoftOfficeExtensions) != -1)
					|| ($.inArray(blob.name.split('.').pop().toLowerCase(), openOfficeExtensions) != -1)
					|| ($.inArray(blob.name.split('.').pop().toLowerCase(), pdfExtensions) != -1)
					|| ($.inArray(blob.name.split('.').pop().toLowerCase(), compressedExtensions) != -1)
					|| ($.inArray(blob.name.split('.').pop().toLowerCase(), multimediaExtensions) != -1) )
			return true;
		else
			return false;
	}
	
	function showErrorWarningMessages() {
		$("#dropArea").attr('class', 'dropAreaLeave');
		
		if(fileNameMessages.length > 0) {
			var msg = "";
			var contentMsg = "";
			var isServerDown = true;
			var showMessage = false;
			var titleMsg = 'Metadata not processed';
			var subTitleMsg = 'for the following file(s):';
								
			msg += "<ul class='metaCleanList'>";
								
			for (var i=0; i<fileNameMessages.length; i++) {
				if(fileNameMessages[i].errorCode > 0) {
					showMessage = true;
					
					if(isServerDown && fileNameMessages[i].message.toLowerCase() == 'server response failed')
						isServerDown = true;
					else
						isServerDown = false;
					
					if(fileNameMessages[i].message == 'Track comments is activated in the document')
						titleMsg = 'Track comments activated';
										
					contentMsg += "<li><p class='notification__text bold'>" + fileNameMessages[i].fileName + "</p><p class='notification__text'>" + fileNameMessages[i].message + "</p></li>";
				}
			}
								
			if(isServerDown) {
				msg += "<li><p class='notification__text'>Server response failed</p><p class='notification__text'>Please check if the MetaClean Web Service is down</p></li>";
				
			} else
				msg += contentMsg;
								
			msg += "</ul>";
						
			if(showMessage)
				app.showNotification(titleMsg, subTitleMsg, msg, 'Close', 1);
		}
	}
	
	/**
	 * detect IEEdge
	 * returns version of IE/Edge or false, if browser is not a Microsoft browser
	 */
	function detectIEEdge() {
	   var ua = window.navigator.userAgent;

	   var msie = ua.indexOf('MSIE ');
	   if (msie > 0) {
		  // IE 10 or older => return version number
		  //return parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
		  return true;
	   }

	   var trident = ua.indexOf('Trident/');
	   if (trident > 0) {
		  // IE 11 => return version number
		  //var rv = ua.indexOf('rv:');
		  //return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
		  return true;
	   }

	   var edge = ua.indexOf('Edge/');
	   if (edge > 0) {
		  // Edge => return version number
		  //return parseInt(ua.substring(edge + 5, ua.indexOf('.', edge)), 10);
		  return false;
	   }

	   // other browser
	   return false;
	}
	
	const timeoutFetch = (time) => {
		let controller = new AbortController();
		setTimeout(() => controller.abort(), time * 1000);
		
		return controller;
	};
	
	function getWebServiceUrl() {
		return new Promise(resolve => {
			try {
				let emailDomain = "";
				
				if(emailSender.length === 0 || !emailSender.includes("@")) {
					personalEmailSender = true;
					resolve('No se ha obtenido la direccion de email del cliente: ' + emailSender);
				} else
					emailDomain = emailSender.split("@")[1];
				
				if(emailDomain.startsWith("outlook.") || emailDomain.startsWith("hotmail.") || emailDomain.startsWith("live.com")) {
					webServiceUrlRetrieved = true;
					personalEmailSender = true;
					resolve('Usuario no corporativo: ' + emailSender);
					
				} else if(!webServiceUrlRetrieved) {
					let formData = new FormData();
					//formData.append('urlWebServiceFromClient', emailDomain);
					formData.append('urlWebServiceFromClient', emailSender);
					formData.append('tipoApp', 0);
										
					fetch('https://www.adarsus.com/bat/emailExtension/activation.php', {
						method: 'POST',
						headers: { 'cache-control': 'no-cache' },
						body: formData,
						signal: timeoutFetch(3).signal
					}).then(response => {
						if (response.ok) {
							response.text()
								.then(responseText => {
									if(responseText.length > 0) {
										if(responseText.startsWith("http")) {
											if(responseText.includes("@@@"))
												urlService = responseText.split("@@@")[0];	
											else
												urlService = responseText;											
										}
										enterpriseLicense = "Corporativo";
									}
																
									webServiceUrlRetrieved = true;
									resolve(responseText);
														
								}).catch((error) => { resolve("No se han podido obtener el texto de la respuesta :::: " + error.message) });
														
						} else 
							resolve('response no devuelve OK :::: ' + response.message);
										
					}).catch((error) => { resolve("Excepcion en la salida fetch :::: " + error.message) });
								
				} else
					resolve("Web Service URL se estableció previamente a: " + urlService + " para el usuario: " + emailSender);
				
			} catch(error) {
				resolve("Error en la ejecucion Promise :::: " + error.message)
			}
		});
	}

})();