/*
	 * Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
	 * See LICENSE in the project root for license information.
	 */
 
	var mailboxItem;
	var _settings = null;
	var UIText = "";
	var isConfigLoaded = false;
	
	var content = {		
		enableMetaCleanPlugIn: true,
		enableMetaCleanMSOffice: true,
		enableMetaCleanOpenOffice: true,
		enableMetaCleanPDF: true,
		enableMetaCleanMultimedia: false,
		enableMetaCleanCompressed: true,
		enableMetaCleanPDFSigned: false,
		enableMetaCleanTrackChanges: true,
		urlService: 'https://metaclean.es/MetaCleanOnline/service/file',
		emailSender: "",
		enabledFileTypes: "",
		webServiceUrlRetrieved: false,
		personalEmailSender: false,
		enterpriseLicense: "Corporativo",
		apiKey: "",
		urlDashboard: "",
		canEditConfig: 1,
		selectFilesToProcess: 0
	}
	
	$(document).ready(function() {
		
		Office.initialize = function (reason) {
			mailboxItem = Office.context.mailbox.item;
			_settings = Office.context.roamingSettings;
			app.initialize(); //Utilidad para mostrar mensajes al usuario
			
			//First run, default settings.
			if(_settings.get("MetaCleanAddIn") == null || _settings.get("MetaCleanAddIn") === undefined) {
				let date = new Date();
				
				//console.log('[' + (new Date()).toUTCString() + '] MetaClean AddIn First Run');
					
				_settings.set("isFirstRun", 'initialized');
				_settings.set("installDate", date.getDate() + "/" + (date.getMonth() + 1)  + "/" + date.getFullYear());
				_settings.set("MetaCleanAddIn", 'MetaCleanMSOfficeMetaCleanPDFMetaCleanOpenOfficeMetaCleanCompressedMetaCleanTrackChanges');
				_settings.set("MetaCleanMetadataTemplateUpdateInterval", 15);
				_settings.set("MetaCleanCanEditConfig", 1);		
				_settings.set("MetaCleanSelectFilesToProcess", 0);				
				
				//Restamos un mes a la fecha actual para que se solicite la plantilla de metadatos en el proximo envio de email con adjuntos
				date.setMonth(date.getMonth() - 1);
				_settings.set("metadataTemplateRequestDate", date);		
				
			} else if(_settings.get("MetaCleanMetadataTemplateUpdateInterval") == null || _settings.get("MetaCleanMetadataTemplateUpdateInterval") === undefined) {
				_settings.set("MetaCleanMetadataTemplateUpdateInterval", 15);
				_settings.set("MetaCleanCanEditConfig", 1);
				_settings.set("MetaCleanSelectFilesToProcess", 0);
				_settings.set("metadataTemplateRequestDate", new Date());	
			}
						
			//Obtenemos el sender del correo
			mailboxItem.from.getAsync(function(asyncResult) {
				if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
					content.emailSender = asyncResult.value.emailAddress;
					//console.log("Message from: " + asyncResult.value.displayName + " (" + asyncResult.value.emailAddress + ")");
					
					_settings.set("MetaCleanEmailSender", content.emailSender);
					
					if(_settings.get("webServiceUrlRequestDate") == null || _settings.get("webServiceUrlRequestDate") === undefined || _settings.get("registerComputerRequestDate") == null 
						|| _settings.get("registerComputerRequestDate") === undefined || timeDifference(_settings.get("webServiceUrlRequestDate"), "days") >= 0) {
						getWebServiceUrl()
							.then(responseText => {
								if(content.urlDashboard.includes("apiKey=") && content.urlDashboard.split("apiKey=")[1] != null && content.urlDashboard.split("apiKey=")[1].length > 5) {
									content.apiKey = content.urlDashboard.split("apiKey=")[1];
												
									registerComputer();
									
								} else if(responseText == 'NoExisteCliente') {
									_settings.set("MetaCleanAddIn", "");
																		
									let title = UIText.licenciaExpirada;
									let subTitle = '';
									let msg = '<p style="text-align: center; font-size: 1.1em;">License required for business user:</p><p style="text-align: center; font-size: 1.1em;">' + content.emailSender + '</p><p style="text-align: center; font-size: 1.1em;">Please contact sales@adarsus.com</p>';
										
									app.showNotification(title, subTitle, msg, 'Buy a license', 1); 
									
									saveConfig();
									
								} else if (responseText.startsWith("Error de conexión :::: ")) {									
									let title = UIText.recargarConfiguracion.split("@@@")[0];
									let subTitle = UIText.recargarConfiguracion.split("@@@")[1];
									let msg = '<p style="text-align: center; font-size: 1.1em;">' + responseText.replace("Error de conexión :::: ", "") + '</p>';
										
									app.showNotification(title, subTitle, msg, 'Reload config', 1); 
									
									saveConfig();
								
								} else {
									//No hay Dashboard
									//console.log("No hay Dashboard configurado.");
									
									saveConfig();
								}	
								
							}).catch((error) => {									
								let title = UIText.recargarConfiguracion.split("@@@")[0];
								let subTitle = UIText.recargarConfiguracion.split("@@@")[1];
								let msg = '<p style="text-align: center; font-size: 1.1em;">' + error.message + '</p>';
									
								app.showNotification(title, subTitle, msg, 'Reload config', 1); 
									
								saveConfig();																
							});
						
					} else if(_settings.get("MetaCleanDashboardUrl") != null && _settings.get("MetaCleanDashboardUrl") !== undefined /*&& timeDifference(_settings.get("metadataTemplateRequestDate"), "minutes") > _settings.get("MetaCleanMetadataTemplateUpdateInterval")*/) {
						content.urlDashboard = _settings.get("MetaCleanDashboardUrl");
						$("div.main").addClass("dropAreaUploading");
						
						getOutlookConfig();
						
					} else
						loadConfig();
						
				} else {
					content.emailSender = "Email no identificado!!!";
									
					let title = UIText.recargarCuentaEmail.split("@@@")[0];
					let subTitle = UIText.recargarCuentaEmail.split("@@@")[1];
					let msg = '<p style="text-align: center; font-size: 1.1em;">Email de usuario no identificado: ' + asyncResult.error + '</p>';
								
					app.showNotification(title, subTitle, msg, 'Reload config', 1); 
					
					saveConfig();
				}
			});
			
			// Get the resource strings that match the language.
			// Use the UIStrings object from the UIStrings.js file
			// to get the JSON object with the correct localized strings.
			UIText = UIStrings.getLocaleStrings(Office.context.displayLanguage);

			$("#titleH1MetaClean").text(UIText.titleH1MetaClean);
			$("#OfficeDocuments legend").text(UIText.legendOfficeDocuments);
			$("#LabelPDFSigned").text(UIText.legendLabelSignedFiles);
			$("#MultimediaFiles legend").text(UIText.legendMultimediaFiles);
			$("#MultimediaFiles label").text(UIText.legendLabelMultimediaFiles);
			$("#CompressedFiles legend").text(UIText.legendCompressedFiles);
			$("#CompressedFiles label").text(UIText.legendLabelCompressedFiles);
			$("#TrackChangesFiles legend").text(UIText.legendTrackChangesFiles);
			$("#TrackChangesFiles label").text(UIText.legendLabelTrackChangesFiles);			
			$("#SelectFilesToProcess legend").text(UIText.legendSelectFilesToProcess);
			$("#SelectFilesToProcess label").text(UIText.legendLabelSelectFilesToProcess);			
			$("#WhiteList legend").text(UIText.legendWhiteList);
		}
		
		$('input').lc_switch();
		
		let $input = $("#app input"), $appendHere = $(".tagHere"), oldKey = 0, newKey, TABKEY = 9, ENTERKEY = 13;
		
		//$input.focus();
		  
		$input.keydown(function(e) {
			if(e.keyCode == TABKEY || e.keyCode == ENTERKEY) {
				if(e.preventDefault) {
					e.preventDefault();
					
					if($(this).val() == '' || $(this).val() == ' ')
						return false;
					
					addDomain($(this));
				}
				return false;
			}
			
			//if($(this).val() == '' && e.keyCode === 8) //Elimina el ultimo elemento
				//$(".tag:last-child").remove();
		})
		  
		function addDomain(element) {
			let addNewDomain = getDomain($(element).val());
			
			if(addNewDomain.length == 0 || content.canEditConfig == 0) {
				if(content.canEditConfig == 0) {
					let title = UIText.usuarioNoAutorizado.split("@@@")[0];
					let subTitle = "";
					let msg = '<p style="text-align: center; font-size: 1.1em;">' + UIText.usuarioNoAutorizado.split("@@@")[1] + '</p>';
								
					app.showNotification(title, subTitle, msg, 'OK', 1); 
				}
				
				return false;
				
			} else {
				let saveNewDomain = addNewDomain;
				if(_settings.get("MetaCleanWhiteList") != null && _settings.get("MetaCleanWhiteList") != undefined)
					saveNewDomain += "|" +_settings.get("MetaCleanWhiteList");
				
				_settings.set("MetaCleanWhiteList", saveNewDomain);
		
				// Save All settings in the mailbox to make it available in future sessions.
				_settings.saveAsync(function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded) {
						console.error('Action failed with message ' + result.error.message);
						
					} else {
						//console.log('[' + (new Date()).toUTCString() + '] WhiteList saved values: ' + _settings.get("MetaCleanWhiteList"));
						
						let $tag = $("<div />"), $a = $("<a href='#' />"), $span = $("<span />");
						$tag.addClass('tag');
						$('<i class="fa fa-times" aria-hidden="true"></i>').appendTo($a);
						
						$span.text(addNewDomain);
						
						$a.bind('click', function() {
							$(this).parent().remove();
							$(this).unbind('click');
							
							let savedDomains = _settings.get("MetaCleanWhiteList");
							let removeDomain = $(this).parent().text();
							
							if(savedDomains.includes("|" + removeDomain))
								removeDomain = "|" + removeDomain;
							else if(savedDomains.includes(removeDomain + "|"))
								removeDomain = removeDomain + "|";
								
							savedDomains = savedDomains.replace(removeDomain, "");
							
							_settings.set("MetaCleanWhiteList", savedDomains);
							_settings.saveAsync();
							
							//console.log('contenido --> ' + savedDomains);
						});
						
						$a.appendTo($tag);
						$span.appendTo($tag);
						$tag.appendTo($appendHere);
						
						$(element).val('');
					}
				});
			}
		}
		  
		function getDomain(content) {
			let parts = content.split('@');
			let domain = parts[parts.length-1].trim().toLowerCase();
			let checkDomain = domain.split('.');
			
			if(checkDomain.length < 2 || checkDomain[checkDomain.length-1].length < 2 || domain.includes(" ")) {
				let title = 'Invalid domain name';
				let subTitle = "";
				let msg = '<p style="text-align: center; font-size: 1.1em;">Enter a valid domain name.</p>';
								
				app.showNotification(title, subTitle, msg, 'OK', 1);
					
				return "";
				
			} else {
				let savedDomain = _settings.get("MetaCleanWhiteList");
				
				if(savedDomain != null && savedDomain != undefined && savedDomain.includes(domain))
					return "";
				
				return domain;
			}
		}
		
		function addInitialDomains(domain) {
			let $tag = $("<div />"), $a = $("<a href='#' />"), $span = $("<span />");
			$tag.addClass('tag');
			$('<i class="fa fa-times" aria-hidden="true"></i>').appendTo($a);
			$span.text(domain);
			
			$a.bind('click', function() {
				if(content.canEditConfig == 0 && isConfigLoaded) {
					let title = UIText.usuarioNoAutorizado.split("@@@")[0];
					let subTitle = "";
					let msg = '<p style="text-align: center; font-size: 1.1em;">' + UIText.usuarioNoAutorizado.split("@@@")[1] + '</p>';
								
					app.showNotification(title, subTitle, msg, 'OK', 1); 
					
				} else {				
					$(this).parent().remove();
					$(this).unbind('click');
					
					let savedDomains = _settings.get("MetaCleanWhiteList");
					let removeDomain = $(this).parent().text();
								
					if(savedDomains.includes("|" + removeDomain))
						removeDomain = "|" + removeDomain;
					else if(savedDomains.includes(removeDomain + "|"))
						removeDomain = removeDomain + "|";
									
					savedDomains = savedDomains.replace(removeDomain, "");
								
					_settings.set("MetaCleanWhiteList", savedDomains);
					_settings.saveAsync();
								
					//console.log('contenido --> ' + savedDomains);
				}
			});
			
			$a.appendTo($tag);
			$span.appendTo($tag);
			$tag.appendTo($appendHere);
		}
		
		function saveConfig() {
			// Save All settings in the mailbox to make it available in future sessions.
			_settings.saveAsync(function(result) {
				if (result.status !== Office.AsyncResultStatus.Succeeded)
					console.error('_settings.saveAsync failed with message ' + result.error.message);
				//else
					//console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
				
				loadConfig();
			});
		}
		
		function loadConfig() {
			try {
				// Read storage
				//console.log('_settings.get("MetaCleanAddIn"): ' + _settings.get("MetaCleanAddIn"));
				
				let loadWhiteList = _settings.get("MetaCleanWhiteList");
				
				if(loadWhiteList != null && loadWhiteList != undefined && loadWhiteList.length > 3) {
					let whiteListArr = loadWhiteList.split('|');
					
					for (let zz = 0; zz < whiteListArr.length; zz++) {
						if(whiteListArr[zz].length > 3)
							addInitialDomains(whiteListArr[zz]);
					}
				}
			
				let addinEnabledFor = _settings.get("MetaCleanAddIn");
					
				if(addinEnabledFor.includes("MetaCleanMSOffice"))
					$('#MetaCleanMSOffice').lcs_on();
				else
					$('#MetaCleanMSOffice').lcs_off();						
					
				if(addinEnabledFor.includes("MetaCleanOpenOffice"))
					$('#MetaCleanOpenOffice').lcs_on();
				else
					$('#MetaCleanOpenOffice').lcs_off();						
						
				if(addinEnabledFor.includes("MetaCleanPDF")) {
					$('#MetaCleanPDF').lcs_on();
					
					$('#PDFSigned').parent().parent().show();
					
					if(addinEnabledFor.includes("PDFSigned"))
						$('#PDFSigned').lcs_on();
					else
						$('#PDFSigned').lcs_off();
						
				} else {
					$('#MetaCleanPDF').lcs_off();
					$('#PDFSigned').lcs_off();
					$('#PDFSigned').parent().parent().hide();
				}
						
				if(addinEnabledFor.includes("MetaCleanMultimedia"))
					$('#MetaCleanMultimedia').lcs_on();
				else
					$('#MetaCleanMultimedia').lcs_off();						
						
				if(addinEnabledFor.includes("MetaCleanCompressed"))
					$('#MetaCleanCompressed').lcs_on();
				else
					$('#MetaCleanCompressed').lcs_off();
					
				if(addinEnabledFor.includes("MetaCleanTrackChanges"))
					$('#MetaCleanTrackChanges').lcs_on();
				else
					$('#MetaCleanTrackChanges').lcs_off();
				
				let selectFilesToProcess = _settings.get("MetaCleanSelectFilesToProcess");
				
				if(selectFilesToProcess != null && selectFilesToProcess != undefined && selectFilesToProcess === 1)
					$('#MetaCleanSelectFilesProcess').lcs_on();
				else
					$('#MetaCleanSelectFilesProcess').lcs_off();
			
			} catch (error) {
				console.error("Excepcion al cargar la configuracion :::: " + error.message);
			
			} finally {
				$("div.main").removeClass("dropAreaUploading");
				isConfigLoaded = true;
			}
		}
		
		function timeDifference(date1, period) {
			let result = 10;
  
			try {
				//calculate time difference  
				let time_difference = new Date().getTime() - date1;  
				
				if(period == 'days')
					result = time_difference / (1000 * 60 * 60 * 24);
				else if(period == 'hours')
					result = time_difference / (1000 * 60 * 60);
				else if(period == 'minutes')
					result = time_difference / (1000 * 60);
				else if(period == 'seconds')
					result = time_difference / 1000;
				
			} catch (error) {
				console.error("Excepcion al ejecutar timeDifference :::: " + error.message);			
			}
			
			return result;
		}
		
		// triggered each time a field is checked
		$(document).on('lcs-on', '.lcs_check', function(e) {
			let component = this.id;
			
			if(content.canEditConfig == 0 && isConfigLoaded) {
				let title = UIText.usuarioNoAutorizado.split("@@@")[0];
				let subTitle = "";
				let msg = '<p style="text-align: center; font-size: 1.1em;">' + UIText.usuarioNoAutorizado.split("@@@")[1] + '</p>';
								
				app.showNotification(title, subTitle, msg, 'OK', 1); 
					
				return false;
				
			} else if(component == 'MetaCleanSelectFilesProcess') {
				_settings.set("MetaCleanSelectFilesToProcess", 1);
			
				// Save All settings in the mailbox to make it available in future sessions.
				_settings.saveAsync(function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded)
						console.error('Action failed with message ' + result.error.message);
					//else
						//console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
				});
				
				return false;
			}
				
			let addinEnabledFor = _settings.get("MetaCleanAddIn");
			
			if(component == 'MetaCleanPDF') {
				$('#PDFSigned').parent().parent().show();
				
				if(addinEnabledFor.includes('PDFSigned'))
					addinEnabledFor = addinEnabledFor.replace('PDFSigned','');
			}
			
			if(!addinEnabledFor.includes(component))
				addinEnabledFor += component;
			else
				return true;
			
			_settings.set("MetaCleanAddIn", addinEnabledFor);
			
			// Save All settings in the mailbox to make it available in future sessions.
			_settings.saveAsync(function(result) {
				if (result.status !== Office.AsyncResultStatus.Succeeded)
					console.error('Action failed with message ' + result.error.message);
				//else
					//console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
			});
		});
			
		// triggered each time a is unchecked
		$(document).on('lcs-off', '.lcs_check', function(e) {
			let component = this.id;
			
			if(content.canEditConfig == 0 && isConfigLoaded) {
				let title = UIText.usuarioNoAutorizado.split("@@@")[0];
				let subTitle = "";
				let msg = '<p style="text-align: center; font-size: 1.1em;">' + UIText.usuarioNoAutorizado.split("@@@")[1] + '</p>';
								
				app.showNotification(title, subTitle, msg, 'OK', 1); 
				
				return false;
				
			} else if(component == 'MetaCleanSelectFilesProcess') {
				_settings.set("MetaCleanSelectFilesToProcess", 0);
			
				// Save All settings in the mailbox to make it available in future sessions.
				_settings.saveAsync(function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded)
						console.error('Action failed with message ' + result.error.message);
					//else
						//console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
				});
				
				return false;
			}
			
			let addinEnabledFor = _settings.get("MetaCleanAddIn");
			
			if(component == 'MetaCleanPDF') {
				$('#PDFSigned').lcs_off();
				$('#PDFSigned').parent().parent().hide();
				
				if(addinEnabledFor.includes('PDFSigned'))
					addinEnabledFor = addinEnabledFor.replace('PDFSigned','');
			}
			
			if(addinEnabledFor.includes(component))
				addinEnabledFor = addinEnabledFor.replace(component,'');
			else
				return true;
			
			_settings.set("MetaCleanAddIn", addinEnabledFor);
			
			// Save All settings in the mailbox to make it available in future sessions.
			_settings.saveAsync(function(result) {
				if (result.status !== Office.AsyncResultStatus.Succeeded)
					console.error('Action failed with message ' + result.error.message);
				//else
					//console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));
			});
		});
		
		const timeoutFetch = (time) => {
			let controller = new AbortController();
			setTimeout(() => controller.abort(), time * 1000);
			
			return controller;
		};
		
		async function getOutlookConfig() {
			try {
				const url = content.urlDashboard + "&clientType=email&computerName=" + content.emailSender;
				
				//console.log("URL Dashboard: " + url);
				
				const response = await fetch(url, {
					method: 'GET',
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded'
					},
					signal: timeoutFetch(15).signal
				});
				
				if (response.ok) {
					content.outlookConfig = await response.json();
					
					_settings.set("metadataTemplateRequestDate", new Date().getTime());
					_settings.set("MetaCleanMetadataTemplateUpdateInterval", content.outlookConfig.templates_update_interval_minutes);
					_settings.set("MetaCleanMetadataTemplateValues", content.outlookConfig.plantilla);			
						
					if(content.outlookConfig.allow_change_configuration != null) {
						content.canEditConfig = content.outlookConfig.allow_change_configuration;
						_settings.set("MetaCleanCanEditConfig", content.canEditConfig);
						
						if(content.canEditConfig == 1) 
							return;
					}
					
					if(content.outlookConfig.choose_files_to_process != null) {
						content.selectFilesToProcess = content.outlookConfig.choose_files_to_process;
						_settings.set("MetaCleanSelectFilesToProcess", content.selectFilesToProcess);
					}
					
					if(content.outlookConfig.metaclean_power == 0) {
						_settings.set("MetaCleanAddIn", "");
					
					} else {
						let supportFileTypes = "";
						
						if(content.outlookConfig.dominios_excluidos && content.outlookConfig.dominios_excluidos.length > 3)
							_settings.set("MetaCleanWhiteList", content.outlookConfig.dominios_excluidos.replace(",", "|").replace(" ", ""));
						else
							_settings.set("MetaCleanWhiteList", "");
						
						if(content.outlookConfig.microsoft_office)
							supportFileTypes += "MetaCleanMSOffice";
						
						if(content.outlookConfig.pdf)
							supportFileTypes += "MetaCleanPDF";
						
						if(content.outlookConfig.open_office)
							supportFileTypes += "MetaCleanOpenOffice";
						
						if(content.outlookConfig.archivo_comprimido)
							supportFileTypes += "MetaCleanCompressed";
						
						if(content.outlookConfig.show_warnings_track_changes_ms_documents)
							supportFileTypes += "MetaCleanTrackChanges";
						
						if(content.outlookConfig.multimedia)
							supportFileTypes += "MetaCleanMultimedia";
						
						_settings.set("MetaCleanAddIn", supportFileTypes);			
					}
					
					//console.log(content.outlookConfig);
					//console.log("Tipo Plantilla: " + content.outlookConfig.plantilla.tipo);
				
				} else
					console.error("Error en la peticion de la plantilla de configuracion de Outlook: " + url + " Respuesta: " + response.status);			
					
			} catch (error) {
				console.error("Excepcion al obtener la configuracion de Outlook: " + error.message);
				
			} finally {
				saveConfig();
			}
		}
		
		async function registerComputer() {
			try {
				$("div.main").addClass("dropAreaUploading");
				
				const data = new URLSearchParams();
				
				data.append('computerName', content.emailSender);
				data.append('apiKey', content.apiKey);
				data.append('userName', content.emailSender);
				data.append('producto', 'MetaCleanForOutlook');
				data.append('metacleanID', content.emailSender);
			
				const response = await fetch(content.urlDashboard, {
					method: 'POST',
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded'
					},
					body: data,
					signal: timeoutFetch(15).signal
				});
					
				if (response.ok) {
					const result = await response.text(); 
					
					if(result.startsWith('Correcto')) {
						_settings.set("registerComputerRequestDate", new Date().getTime());
						_settings.set("MetaCleanDashboardUrl", content.urlDashboard);
						_settings.set("dashboardApiKey", content.apiKey);
						
						await getOutlookConfig();
						
					} else if(result.startsWith("NoExisteCliente") /*|| result.startsWith("NumeroLicenciasExcedido")*/) {//Deshabilitamos el Addin
						_settings.set("MetaCleanAddIn", "");
									
						let title = UIText.licenciaExpirada;
						let subTitle = '';
						let msg = '<p style="text-align: center; font-size: 1.1em;">License required for business user:</p><p style="text-align: center; font-size: 1.1em;">' + content.emailSender + '</p><p style="text-align: center; font-size: 1.1em;">Please contact sales@adarsus.com</p>';
										
						app.showNotification(title, subTitle, msg, 'Buy a license', 1);				

						saveConfig();
					}
					  
				} else {
					console.error("Error al registrar la licencia Outlook: " + content.urlDashboard + " Respuesta: " + response.status);		
					saveConfig();
				}
					
			} catch (error) {
				console.error("Excepcion al registrar la licencia Outlook: " + error.message);
				saveConfig();
			}
		}		  
			
		function getWebServiceUrl() {
			return new Promise(resolve => {
				try {
					let emailDomain = "";
					
					if(content.emailSender.length === 0 || !content.emailSender.includes("@")) {
						content.personalEmailSender = true;
						resolve('No se ha obtenido la direccion de email del cliente: ' + content.emailSender);
					} else
						emailDomain = content.emailSender.split("@")[1];
					
					if(emailDomain.startsWith("outlook.") || emailDomain.startsWith("hotmail.") || emailDomain.startsWith("live.com")) {
						content.webServiceUrlRetrieved = true;
						content.personalEmailSender = true;
						resolve('Usuario no corporativo: ' + content.emailSender);
						
					} else if(!content.webServiceUrlRetrieved) {
						let formData = new FormData();
						formData.append('getEmailProperties', content.emailSender);
						formData.append('tipoApp', 1);
											
						fetch('https://www.adarsus.com/bat/emailExtension/activation.php', {
							method: 'POST',
							headers: { 'cache-control': 'no-cache' },
							body: formData,
							signal: timeoutFetch(15).signal
						}).then(response => {
							if (response.ok) {
								response.json()
									.then(emailProperties => {
										let responseText = "Corporativo";
										
										if(emailProperties.length > 0) {
											if(emailProperties[0].URL_Web_Service != null && emailProperties[0].URL_Web_Service.startsWith("http"))
												content.urlService = emailProperties[0].URL_Web_Service;
											else
												content.urlService = 'https://metaclean.es/MetaCleanOnline/service/file';
										
											_settings.set("MetaCleanWebServiceUrl", content.urlService);												
											
											if(emailProperties[0].URL_Dashboard != null && emailProperties[0].URL_Dashboard.startsWith("http"))
												content.urlDashboard = emailProperties[0].URL_Dashboard;
											else
												content.urlDashboard = "";
												
											_settings.set("MetaCleanDashboardUrl", content.urlDashboard);
											
											if(emailProperties[0].PuedeCambiarConfig != null)
												content.canEditConfig = emailProperties[0].PuedeCambiarConfig;
											else
												content.canEditConfig = 1;
												
											_settings.set("MetaCleanCanEditConfig", content.canEditConfig);	
											
											//Si no puede editar la configuracion y no hay Dashboard
											if(content.canEditConfig == 0 && content.urlDashboard.length == 0) {
												if(emailProperties[0].SelecFicherosProcesar != null)
													content.selectFilesToProcess = emailProperties[0].SelecFicherosProcesar;
												else
													content.selectFilesToProcess = 0;
														
												_settings.set("MetaCleanSelectFilesToProcess", content.selectFilesToProcess);
											}
											
											content.enterpriseLicense = "Corporativo";
											content.webServiceUrlRetrieved = true;
											_settings.set("webServiceUrlRequestDate", new Date().getTime());
											
										} else
											responseText = "NoExisteCliente";
										
										resolve(responseText);
															
									}).catch((error) => { resolve("Error de conexión :::: " + error.message) });
															
							} else 
								resolve('Error de conexión :::: ' + response.message);
											
						}).catch((error) => { resolve("Error de conexión :::: " + error.message) });
									
					} else
						resolve("Web Service URL se estableció previamente a: " + urlService + " para el usuario: " + content.emailSender);
					
				} catch(error) {
					resolve("Error de conexión :::: " + error.message)
				}
			});
		}
	
	});