// Copyright (c) Microsoft. All rights reserved. Licensed under the MIT license. See LICENSE.txt in the project root for license information.

/* Common app functionality */

var app = (function () {
    "use strict";

    var app = {};

    // Common initialization function (to be called from each page)
    app.initialize = function () {
		$('body').append(
			'<div id="notification-message" class="frame">' +
					'<div class="notification -warning -open">' +
						'<div class="notification__content">' +
							'<img id="warning__Icon" alt="Warning MetaClean" width="70" src="images/iconWarning-100.png">' +
							'<h3 class="notification__title">Metadata not processed</h3>' + 
							'<p class="notification__subTitle">for the following file(s):</p>' + 
							'<p class="notification__text">' +
								'An error has occured while creating an error report.' +
							'</p>' +
						'</div>' +
						'<button class="notification__button">' +
							'Close' +
						'</button>' +
					'</div>' +
			'</div>');
		
		// Notification element
		var _notification = $( '#notification-message' );
		
		// Notification title
		var _nTitle = $( '.notification__title' );
		
		// Notification sub-title
		var _nSubTitle = $( '.notification__subTitle' );
			
		// Notification text
		var _nText = $( '.notification__text' );
		
		// Button text
		var _nButton = $( '.notification__button' );
		
		// Icon
		var _nIcon = $( '#warning__Icon' );
		
		// Notification button click
		$( '.notification__button' ).click( function( event ) {
			event.preventDefault();
			
			if($(this).html().includes("Buy"))
				window.open('https://www.adarsus.com/en/contact/', '_blank');
			
			_notification.hide(100);
		})
		
		app.showNotification = function (title, subtitle, text, buttonText, icon) {
			_nTitle.html(title);
			_nSubTitle.html(subtitle);
            _nText.html(text);
			_nButton.html(buttonText);
			_nIcon.attr('src', (icon == 0) ? 'images/iconInfo-100.png':'images/iconWarning-100.png');
			
            _notification.slideDown();
        };
		
    };

    return app;
})();