/*
	 * Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
	 * See LICENSE in the project root for license information.
	 */
 
	var mailboxItem;
	var _settings = null;
	
	var value = {
        AsyncResult: null,
        Dialog: null,
        MessageObjects: [],
		NFileProcessed: null,
		CancelSend: false,
		OWAPlatform: false,
		isErrorOnDialogOpen: false,
		SelectedFilesToProcess: null
    };
	
	Office.initialize = function (reason) {
        mailboxItem = Office.context.mailbox.item;
		_settings = Office.context.roamingSettings;
		
		//First run, default settings.
		if(_settings.get("MetaCleanAddIn") == null || _settings.get("MetaCleanAddIn") === undefined) {
			let date = new Date();
			
			//console.log('[' + (new Date()).toUTCString() + '] MetaClean AddIn First Run');
			
			_settings.set("isFirstRun", 'initialized');
			_settings.set("installDate", date.getDate() + "/" + (date.getMonth() + 1)  + "/" + date.getFullYear());
			_settings.set("MetaCleanAddIn", 'MetaCleanMSOfficeMetaCleanPDFMetaCleanOpenOfficeMetaCleanCompressedMetaCleanTrackChanges');				
			_settings.set("MetaCleanMetadataTemplateUpdateInterval", 15);
			_settings.set("MetaCleanCanEditConfig", 1);
			_settings.set("MetaCleanSelectFilesToProcess", 0);
				
			//Restamos un mes a la fecha actual para que se solicite la plantilla de metadatos en el proximo envio de email con adjuntos
			date.setMonth(date.getMonth() - 1);
			_settings.set("metadataTemplateRequestDate", date);	
				
			// Save All settings in the mailbox to make it available in future sessions.
			saveConfig();
			
		} else {
			if(_settings.get("MetaCleanMetadataTemplateUpdateInterval") == null || _settings.get("MetaCleanMetadataTemplateUpdateInterval") === undefined) {
				let date = new Date();
				
				_settings.set("MetaCleanMetadataTemplateUpdateInterval", 15);
				_settings.set("MetaCleanCanEditConfig", 1);
				_settings.set("MetaCleanSelectFilesToProcess", 0);
				
				//Restamos un mes a la fecha actual para que se solicite la plantilla de metadatos en el proximo envio de email con adjuntos
				date.setMonth(date.getMonth() - 1);
				_settings.set("metadataTemplateRequestDate", date);	
			}
			
			//Cargamos la configuracion almacenada
			let addinEnabledFor = _settings.get("MetaCleanAddIn");
			
			content.enableMetaCleanMSOffice = addinEnabledFor.includes("MetaCleanMSOffice");
			content.enableMetaCleanOpenOffice = addinEnabledFor.includes("MetaCleanOpenOffice");
			content.enableMetaCleanPDF = addinEnabledFor.includes("MetaCleanPDF");
			content.enableMetaCleanMultimedia = addinEnabledFor.includes("MetaCleanMultimedia");
			content.enableMetaCleanCompressed = addinEnabledFor.includes("MetaCleanCompressed");
			content.enableMetaCleanPDFSigned = addinEnabledFor.includes("PDFSigned");
			content.enableMetaCleanTrackChanges = addinEnabledFor.includes("MetaCleanTrackChanges");
			
			content.enableMetaCleanPlugIn = (content.enableMetaCleanMSOffice || content.enableMetaCleanOpenOffice || content.enableMetaCleanPDF || content.enableMetaCleanMultimedia || content.enableMetaCleanCompressed)?true:false;
			
			if(_settings.get("MetaCleanEmailSender") != null && _settings.get("MetaCleanEmailSender") !== undefined && _settings.get("MetaCleanEmailSender").includes("@"))
				content.emailSender = _settings.get("MetaCleanEmailSender");
			
			if(_settings.get("MetaCleanWebServiceUrl") != null && _settings.get("MetaCleanWebServiceUrl") !== undefined && _settings.get("MetaCleanWebServiceUrl").toLowerCase().startsWith("http"))
				content.urlService = _settings.get("MetaCleanWebServiceUrl");
			
			if(_settings.get("MetaCleanDashboardUrl") != null && _settings.get("MetaCleanDashboardUrl") !== undefined && _settings.get("MetaCleanDashboardUrl").toLowerCase().startsWith("http"))
				content.urlDashboard = _settings.get("MetaCleanDashboardUrl");
			
			if(_settings.get("MetaCleanMetadataTemplateUpdateInterval") != null && _settings.get("MetaCleanMetadataTemplateUpdateInterval") !== undefined && _settings.get("MetaCleanMetadataTemplateUpdateInterval") > 0)
				content.metadataTemplateUpdateMinutes = _settings.get("MetaCleanMetadataTemplateUpdateInterval");
				
			if(_settings.get("dashboardApiKey") != null && _settings.get("dashboardApiKey") !== undefined && _settings.get("dashboardApiKey").length > 10)
				content.apiKey = _settings.get("dashboardApiKey");
			
			if(_settings.get("MetaCleanMetadataTemplateValues") != null && _settings.get("MetaCleanMetadataTemplateValues") !== undefined)
				content.metadataTemplateValues = _settings.get("MetaCleanMetadataTemplateValues");
			
			if(_settings.get("MetaCleanSelectFilesToProcess") != null && _settings.get("MetaCleanSelectFilesToProcess") !== undefined)
				content.selectFilesToProcess = _settings.get("MetaCleanSelectFilesToProcess");

			//console.log('MetaClean O365 initialized! :::: ' + addinEnabledFor + " MetaCleanEmailSender: " + content.emailSender + " MetaCleanWebServiceUrl: " + content.urlService + " MetaCleanDashboardUrl: " + content.urlDashboard + " MetaCleanMetadataTemplateValues: " + content.metadataTemplateValues );
		}		
	}
	
	async function saveConfig() {
		// Save All settings in the mailbox to make it available in future sessions.
		_settings.saveAsync(function(result) {
			if (result.status !== Office.AsyncResultStatus.Succeeded)
				console.error('_settings.saveAsync failed with message ' + result.error.message);
			//else
				//console.log('[' + (new Date()).toUTCString() + '] Settings saved values: ' + _settings.get("MetaCleanAddIn"));				
		});
	}
    
	// Entry point for MetaClean Message Body Checker add-in before send is allowed.
	// <param name="event">ItemSend event is automatically passed by on-send code to the function specified in the manifest.</param>
	function removeMetadataFromAttachments(event) {
		mailboxItem.body.getAsync("html", { asyncContext: event }, processAttachments);
	}
	
	function processDialogEvent(arg) {
		//console.log('capturo evento CERRAR ventana');
		try {
			localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "close", settings: value.MessageObjects }));
			value.Dialog.close();
			
		} catch (e) {
            console.error("Error al cerrar el dialogo");
        }
		
		value.AsyncResult.asyncContext.completed({ allowEvent: false });
	}
	
	function processDialogMessage(arg) {
		if(arg !== undefined && arg !== null && arg != "") {
			let msg = JSON.parse(arg.message);
			//console.log('MENSAJE RECIBIDO DE LA VENTANA MODAL --> ' + msg.messageText + ' Iteracion --> ' + msg.iteration);
			
			value.NFileProcessed = (msg.iteration != null) ? msg.iteration : msg.messageText;
			
			if(msg.selectedFiles !== null && msg.selectedFiles !== undefined)
				value.SelectedFilesToProcess = msg.selectedFiles;
		}
	}
	
	/**
     * Updates the progress bar by incrementing it
     * @param {number} [increment]  The amount ot increment the progress bar by
     * @param {string} [text]       A new message to display
     * @returns {{Value: number, Cancelled: boolean}}   Returns a JSON object wiht the value
     *                                                 of the progress bar and whether the
     *                                                 user pressed cancel
     */
    function UpdateProgessBar(increment=1, text="", iter, mensaje="progress", extraText="") {
        try {
            let messageToDialog = { message: mensaje, settings: { Text: text, Caption: extraText, Number: increment, NFile: iter } };
			localStorage.setItem("MetaCleanProgress", JSON.stringify(messageToDialog));
			
        } catch (e) {
            console.error("Error in UpdateProgessBar ---> " + e.message);
            return "";
        }
    };
	
	function isOWA() {		
		/*
		Android	--> The platform is an Android device.
		iOS	--> The platform is an iOS device.
		Mac	--> The platform is Mac.
		OfficeOnline --> The platform is Office on the web (in a browser) y Outlook escritorio Windows nueva interfaz.
		PC --> The platform is PC (Windows) con Classic View.
		Universal --> The platform is WinRT.
		*/
		
		//console.log("Plataforma :::: " + Office.context.platform);
		
		if (Office.context.platform == "OfficeOnline")
			return true; //OWA
		else
			return false;
	}
	
	const timeoutFetch = (time) => {
		let controller = new AbortController();
		setTimeout(() => controller.abort(), time * 1000);
		
		return controller;
	};
	
    async function processAttachments(asyncResult) {
		let result = null;
		let continuar = true;
		
		/*
		const seriesId = Office.context.mailbox.item.seriesId;

		  if (seriesId === undefined) {
			console.log("This is a message that's not a meeting request.");
		  } else if (seriesId === null) {
			console.log("This is a single appointment, a parent series, or a meeting request for a series or single meeting.");
		  } else {
			console.log("This is an instance belonging to series with ID " + seriesId);
		  }
		*/
		
		try {
			//Si el appointment tiene ficheros adjuntos la funcion addAttachment da error y no se envia la cita, los adjuntos de los appointment no seran procesados			
			if(Office.context.mailbox.item.seriesId === undefined)
				result = await getAllAttchmentObjects();
			
		} catch(e) {
			console.error("Excepcion al obtener ficheros adjuntos :::: " + e.message);
		}
		
		//INICIAMOS PROCESOS background cuando haya ficheros adjuntos
		try {
			if(result != null && result.message === 'Success' && await needProcessAttachments(result)) {
				/* Retardo para hacer DEBUG 
				let contador = 0;
				do {
					console.log("Espero...");
					await delay(1000);
					contador++;
						
				} while (contador < 10);
				*/
				
				if(content.emailSender.length < 5 || !content.emailSender.includes("@"))
					await getEmailSender();
				
				if(_settings.get("webServiceUrlRequestDate") == null || _settings.get("webServiceUrlRequestDate") === undefined || timeDifference(_settings.get("webServiceUrlRequestDate"), "days") > 1) {
					//Llamada asincrona, se ejecutará getWebServiceUrl() y continuará con el siguiente bloque IF sin esperar a que termine la ejecucion completa de la funcion getWebServiceUrl()
					getWebServiceUrl()
						.then(salidaProceso => {
							if(content.urlDashboard != null && content.urlDashboard.includes("apiKey=") && content.urlDashboard.split("apiKey=")[1] != null && content.urlDashboard.split("apiKey=")[1].length > 5) {
								content.apiKey = content.urlDashboard.split("apiKey=")[1];
												
								registerComputer();//Para asegurar que se consume una licencia (en los casos donde se elimine el usuario del Dashboard volveria asi a registrar la licencia)
										
							} else if(responseText == 'NoExisteCliente') {
								_settings.set("MetaCleanAddIn", "");
								saveConfig();
								
								//console.log(responseText);
										
							} else if (responseText.startsWith("Error de conexión :::: ")) {
								console.error(responseText);
									
							} /* else {
								//No hay Dashboard
								console.log("No hay Dashboard configurado.");
							} */
									
						}).catch((error) => {
							console.error("Error en la ejecucion de getWebServiceUrl() :::: " + error.message);
						});
							
				} else if(content.urlDashboard.length > 0 && content.urlDashboard.toLowerCase().startsWith("http") && timeDifference(_settings.get("metadataTemplateRequestDate"), "minutes") > content.metadataTemplateUpdateMinutes) {
					await getOutlookConfig();
				}
				
			} else
				continuar = false;
			
		} catch(e) {
			console.error("Excepcion al cargar datos del Dashboard :::: " + e.message);
		}
					
		exitIF: if(continuar) {
			value.OWAPlatform = isOWA();
			value.AsyncResult = asyncResult;
			
			//Numero de ficheros que se van a procesar.
			let numFilesToBeProcessed = 0;
			
			//console.log("ficheros añadidos --> " + result.attachObjectArray.length + " content.selectFilesToProcess: " + content.selectFilesToProcess);
			
			if(content.selectFilesToProcess == 1) {
				try {
					//Obtener el numero de ficheros que se mostraran en la lista de ficheros a procesar.
					let numFilesToBeSelected = 0;
					let altoVentanaModal = 16;
					
					for (let i = 0; i < result.attachObjectArray.length; i++) {
						let extensionFile = (result.attachObjectArray[i].name.split('.').length > 0) ? result.attachObjectArray[i].name.split('.').pop().toLowerCase() : '';
						
						if(result.attachObjectArray[i].attachmentType === 'file' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile))
							numFilesToBeSelected++;
					}
					
					if(numFilesToBeSelected < 3)
						altoVentanaModal = 21;
					else if(numFilesToBeSelected === 3)
						altoVentanaModal = 25;
					else if(numFilesToBeSelected > 3)
						altoVentanaModal = 30;
					
					localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "selectFilesToProcess", settings: result.attachObjectArray, config: content }));
		
					// URL, Ancho, Alto
					openDialogWindow("https://www.adarsus.com/addin/O365/Dialog.html", (value.OWAPlatform?50:35), (value.OWAPlatform?altoVentanaModal:altoVentanaModal*0.99));
					
					value.NFileProcessed = null;
				
					do {
						//console.log("Espero controlModal --> " + value.NFileProcessed);
						await delay(300);
							
					} while (value.NFileProcessed == null);
					
					if(value.NFileProcessed === 'Cancelar_Envio' || (value.NFileProcessed === 'Enviar' && value.SelectedFilesToProcess != null && value.SelectedFilesToProcess.length == 0) ) {
						value.CancelSend = (value.NFileProcessed === 'Cancelar_Envio');
						
						if(value.Dialog != null) {
							localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "close", settings: value.MessageObjects }));
							value.Dialog.close();
						}
						
						break exitIF;
					}
					
				} catch (e) {
					console.error("Error in UpdateProgessBar ---> " + e.message);
				}
				
			} else {
				//Obtener el numero de ficheros que se van a procesar
				for (let i = 0; i < result.attachObjectArray.length; i++) {
					let extensionFile = (result.attachObjectArray[i].name.split('.').length > 0) ? result.attachObjectArray[i].name.split('.').pop().toLowerCase() : '';
						
					if(result.attachObjectArray[i].attachmentType === 'file' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile))
						numFilesToBeProcessed++;
				}
					
				UpdateProgessBar(0, "", 0, "progress");
				
				if(content.emailSender != null /*&& content.emailSender.endsWith("adarsus.com")*/) {
					// URL, Ancho, Alto
					//openDialogWindow("https://www.adarsus.com/addin/O365/Dialog_New.html", (value.OWAPlatform?40:26), (value.OWAPlatform?22:22));
					openDialogWindow("https://www.adarsus.com/addin/O365/Dialog_New.html", (value.OWAPlatform?40:26), (value.OWAPlatform?20:18));
					
				} else {
					// URL, Ancho, Alto
					openDialogWindow("https://www.adarsus.com/addin/O365/Dialog.html", (value.OWAPlatform?40:26), (value.OWAPlatform?14:14));				
				}
						
				//Si el proceso tarda mas de 60 segundos en terminar cancelamos el envio (Cuidado al cambiar este valor pues si es un fichero ZIP grande con muchos ficheros puede consumir mas de 60 segundos)
				setTimeout(() => {
					if(value.Dialog != null) {
						try {
							localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "close", settings: value.MessageObjects }));
							value.Dialog.close();
							
						} catch (e) {
							console.error("Error in Dialog.close() :::: " + e.message);
						}
					}
					
					//Cancelamos el envio
					asyncResult.asyncContext.completed({ allowEvent: false });
					
				}, 60000);
			}
			
			//Ocurre a veces que result.attachObjectArray.length tiene una longitud del doble de los ficheros que realmente hay adjuntos, por este motivo controlamos el porcentaje de la barra de progreso con esta nueva variable: contadorFicherosParaProcesar
			let contadorFicherosParaProcesar = 0;
			
			for (let i = 0; i < result.attachObjectArray.length; i++) {
				let extensionFile = (result.attachObjectArray[i].name.split('.').length > 0) ? result.attachObjectArray[i].name.split('.').pop().toLowerCase() : '';
			
				if(result.attachObjectArray[i].attachmentType === 'cloud' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile)) {
					console.log("Iteracion --> " + i + " NO Procesamos el fichero: " + result.attachObjectArray[i].name + " attachmentType: " + result.attachObjectArray[i].attachmentType);					
					
				} else if(content.selectFilesToProcess == 1 && value.SelectedFilesToProcess != null && value.SelectedFilesToProcess.length >= 0 && !value.SelectedFilesToProcess.includes(result.attachObjectArray[i].id)) {
					console.log("Iteracion --> " + i + " Fichero no seleccionado: " + result.attachObjectArray[i].name + " value.SelectedFilesToProcess.length: " + value.SelectedFilesToProcess.length);
				
				} else if(result.attachObjectArray[i].attachmentType === 'file' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile)) {
					contadorFicherosParaProcesar++;
					
					//console.log("Iteracion --> " + i + " Procesamos el fichero: " + result.attachObjectArray[i].name + " attachmentType: " + result.attachObjectArray[i].attachmentType + " Size: " + result.attachObjectArray[i].size);
					
					let porcentaje = (100/numFilesToBeProcessed) * contadorFicherosParaProcesar;
					
					//Para cuando está activa la opcion de seleccionar los ficheros a procesar
					if(content.selectFilesToProcess == 1 && value.SelectedFilesToProcess != null && value.SelectedFilesToProcess.length >= 0 && value.SelectedFilesToProcess.includes(result.attachObjectArray[i].id)) {
						porcentaje = (100/value.SelectedFilesToProcess.length) * (value.SelectedFilesToProcess.indexOf(result.attachObjectArray[i].id)+1);
						UpdateProgessBar(porcentaje, result.attachObjectArray[i].name, i, "progressSelectedFiles");
						
					} else			
						UpdateProgessBar(porcentaje, result.attachObjectArray[i].name, i, "progress");
				
					let fileContent = await getAttachmentContent(result.attachObjectArray[i]);
						
					if(fileContent.message === 'Success') {
						//Proceso los metadatos
						let processedFile = await processMetadata(fileContent.attachContent, fileContent.attachName);
						
						//Verificamos si hay error de conexion y relanzamos el proceso
						if(processedFile.responseCode === 500)
							processedFile = await processMetadata(fileContent.attachContent, fileContent.attachName);
							
						//Si el procesado de metadatos es correcto borro el fichero adjunto original
						if(processedFile.message === 'Success' || processedFile.message === "Metadata removed successfully" || (processedFile.message.startsWith("Track c") && processedFile.message.includes("activated in the document"))) {
							//console.log(`Metadata file removed successfully: ${fileContent.attachName}`);
							
							let removeResult = await removeAttachment(result.attachObjectArray[i].name, result.attachObjectArray[i].id);
							
							//Si el borrado del fichero adjunto es correcto adjunto el nuevo fichero procesado
							if(removeResult != null && removeResult.message != null && removeResult.message === 'Success') {
								let addResult = await addAttachment(processedFile.blobFile, fileContent.attachName);
											
								if(addResult.message != 'Success') {
									//let mensaje_error = "Error al adjuntar el fichero procesado: " + fileContent.attachName + " :::: " + addResult.message;
									value.MessageObjects.push({ message: addResult.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
									
								} else {
									if(content.enableMetaCleanTrackChanges && processedFile.message.startsWith("Track c") && processedFile.message.includes("activated in the document") && (extensionFile.startsWith("do") || extensionFile.startsWith("xl") || extensionFile.startsWith("pp") || extensionFile.startsWith("zip") || extensionFile.startsWith("7z"))) {
										value.MessageObjects.push({ message: processedFile.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });//Aun no esta desarrollada la funcionalidad para aceptar Cambios y borrar comentarios para el Add-in por eso ponemos siempre false.
										//value.MessageObjects.push({ message: processedFile.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: (extensionFile.endsWith("x") || extensionFile.endsWith("zip") || extensionFile.endsWith("7z")) });//Para las versiones antiguas de Word (.doc, .dot) NO damos la opcion de aceptar los cambios automaticamente
									}
										
									//console.log("Fichero procesado añadido correctamente: " + fileContent.attachName + " Iteracion: " + i);
									
									if (!value.OWAPlatform) //No es OWA
										await delay(500);
								}
											
							} else {
								console.error("Error al borrar el fichero adjunto: " + fileContent.attachName + " :::: " + (removeResult!=null?removeResult.message:""));
								value.MessageObjects.push({ message: "Error al borrar el fichero adjunto :::: " + (removeResult!=null?removeResult.message:""), fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
							}
								
						} else if(processedFile.message.includes("Signed PDF file")) {
							console.log(result.attachObjectArray[i].name + " :::: " + processedFile.message);
							
							//value.MessageObjects.push({ message: processedFile.message, fileName: result.attachObjectArray[i].name, pdfSigned: true, trackChangesEnabled: false });
						
						} else if(processedFile.message.includes("Your file appears not to be a valid OLE2")) {
							console.log(result.attachObjectArray[i].name + " :::: " + processedFile.message);							
							//let msgErrorOLE2 = extensionFile.includes("xls")? "Parece que el formato del fichero no corresponde con el formato estandar de ficheros Excel, por favor contacte con support@adarsus.com para comunicar este evento.":"Parece que el formato del fichero no corresponde con el formato estandar de ficheros " + extensionFile + ", por favor contacte con support@adarsus.com para comunicar este evento.";
							
							//value.MessageObjects.push({ message: msgErrorOLE2, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
												
						} else {
							//console.error("Error al procesar los metadatos del fichero: " + fileContent.attachName + " :::: " + processedFile.message);
							
							value.MessageObjects.push({ message: processedFile.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
						}
						
					} else {
						//console.error("Error al obtener el contenido del fichero: " + result.attachObjectArray[i].name + " :::: " + fileContent.message);
						
						value.MessageObjects.push({ message: "Error al obtener el contenido del fichero :::: " + fileContent.message, fileName: result.attachObjectArray[i].name, pdfSigned: false, trackChangesEnabled: false });
					}
					
					/* Da problemas, a veces la ventana modal no carga y provoca el Timeout configurado en la ventana modal --> 60 segundos. */
					do {
						//console.log("Espero... value.NFileProcessed --> " + value.NFileProcessed + " i --> " + i + " value.Dialog: " + value.Dialog  + " value.isErrorOnDialogOpen: " + value.isErrorOnDialogOpen);
						await delay(100);
						
					} while (!value.isErrorOnDialogOpen && (value.Dialog == null || value.NFileProcessed == null /*|| value.NFileProcessed < i*/));					
					
				} //else
					//console.log("Fichero no soportado --> " + result.attachObjectArray[i].name + " Extension: " + extensionFile);
			}
			
			//console.log("FINAL PROCESAMIENTO DE FICHEROS --> " + result.attachObjectArray.length);
			
			if(result.attachObjectArray.length > 0) {
				
				if(value.Dialog != null) {
					
					if(value.MessageObjects.length > 0) {//Si han ocurrido avisos entramos
						value.NFileProcessed = null;
						value.CancelSend = false;
						let controlModal = 0;
						
						//console.log("Han ocurrido errores --> " + value.MessageObjects.length);
						
						localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "warningMessages", settings: value.MessageObjects }));
		
						do {
							//Espero 30 segundos a que responda el usuario (controlModal estaba en 1000)
							if(controlModal > 100 && value.Dialog == null)
								value.NFileProcessed = 'Cancelar_Envio'; //'Enviar';
							
							//console.log("Espero controlModal --> " + value.NFileProcessed);
							await delay(300);
							
							controlModal++;
							
						} while (value.NFileProcessed == null);
					
						if(value.NFileProcessed != null) {
							
							if(value.NFileProcessed === 'Cancelar_Envio') {
								value.CancelSend = true;
								
							} else if(value.NFileProcessed === 'Enviar') {
								//console.log("Enviamos email son procesar los ficheros adjuntos!!!");
								value.CancelSend = false;
					
							} else if(value.NFileProcessed === 'Procesar_Ficheros') {//Esta opcion esta deshabilitada por el momento
								let nfilesToProcess = 0;
								let iteratorFileMessages = 0;
								
								value.NFileProcessed = null;
									
								for (let zz = 0; zz < value.MessageObjects.length; zz++) {
									if(value.MessageObjects[zz].trackChangesEnabled)
										nfilesToProcess++;
								}
								
								localStorage.setItem("MetaCleanProgress", JSON.stringify({ Text: "", Caption: "", Number: 0, NFile: 0 }));
								
								//Obtenemos la nueva referencia a los ficheros adjuntos
								result = await getAllAttchmentObjects();
								
								for (let i = 0; i < result.attachObjectArray.length; i++) {
									let extensionFile = (result.attachObjectArray[i].name.split('.').length > 0) ? result.attachObjectArray[i].name.split('.').pop().toLowerCase() : '';
								
									if(result.attachObjectArray[i].attachmentType === 'file' && result.attachObjectArray[i].size > 0 && extensionFile.length > 0 && content.isSupportedFormat(extensionFile)) {
										//console.log("Iteracion --> " + i + " fichero: " + result.attachObjectArray[i].name + " attachmentType: " + result.attachObjectArray[i].attachmentType + " Size: " + result.attachObjectArray[i].size);
										
										for (let xx = 0; xx < value.MessageObjects.length; xx++) {
											if(value.MessageObjects[xx].trackChangesEnabled && result.attachObjectArray[i].name === value.MessageObjects[xx].fileName) {
												//console.log("Iteracion --> " + xx + " Procesamos el fichero: " + value.MessageObjects[xx].fileName);
												
												let porcentaje = (100/nfilesToProcess) * (iteratorFileMessages+1);
												UpdateProgessBar(porcentaje, result.attachObjectArray[i].name, iteratorFileMessages, "progress");
												
												iteratorFileMessages++;
												
												let fileContent = await getAttachmentContent(result.attachObjectArray[i]);
												
												if(fileContent.message === 'Success') {
													//console.log("Contenido del fichero recibido correctamente --> " + fileContent.attachName);
													//Proceso los metadatos
													let processedFile = await processMetadata(fileContent.attachContent, fileContent.attachName);
													
													//Verificamos si hay error de conexion y relanzamos el proceso
													if(processedFile.responseCode === 500)
														processedFile = await processMetadata(fileContent.attachContent, fileContent.attachName);
													
													//Si el procesado de metadatos es correcto borro el fichero adjunto original
													if(processedFile.message === 'Success' || processedFile.message === "Metadata removed successfully") {
														//console.log(`Metadatos procesados successfully: ${fileContent.attachName}`);
														
														let removeResult = await removeAttachment(result.attachObjectArray[i].name, result.attachObjectArray[i].id);
														
														//Si el borrado del fichero adjunto es correcto adjunto el nuevo fichero procesado
														if(removeResult != null && removeResult.message != null && removeResult.message === 'Success') {
															//console.log(`Metadata file removed successfully: ${fileContent.attachName}`);
															let addResult = await addAttachment(processedFile.blobFile, fileContent.attachName);
																		
															if(addResult.message === 'Success') {
																//console.log(`Fichero adjuntado correctamente: ${fileContent.attachName}`);
																
																if (!value.OWAPlatform) //No es OWA
																	await delay(400);
															}
															
															break;
														}															
													}
												}
											}
										}
									}
								}
							}
						}
					}
					
					//Cancelamos el bucle recusivo de iterador de Dialog.html
					if(value.Dialog != null) {
						localStorage.setItem("MetaCleanProgress", JSON.stringify({ message: "close", settings: value.MessageObjects }));
						value.Dialog.close();
					}
				}
			}
			
		} //else {
			//console.log("No hay ficheros adjuntos");
		//}
		
		//console.log("End of process!!!");
		let checkBody = false;
 
		/* 
		var listOfBlockedWords = new Array("blockedword", "aaa", "blockedword2");
        var wordExpression = listOfBlockedWords.join('|');
		
		// \b to perform a "whole words only" search using a regular expression in the form of \bword\b.
        // i to perform case-insensitive search.
        var regexCheck = new RegExp('\\b(' + wordExpression + ')\\b', 'i');
        checkBody = regexCheck.test(asyncResult.value);
		*/
				
        if (checkBody || value.CancelSend) {
			// Call event.completed() after all work is done.
			// Block send.
            asyncResult.asyncContext.completed({ allowEvent: false });
			
        } else {
			// Call event.completed() after all work is done.
            // Allow send.
            asyncResult.asyncContext.completed({ allowEvent: true });
			
			//Para que no se envie el email
			//asyncResult.asyncContext.completed({ allowEvent: (content.emailSender.includes("demo@adarsus.com")) ? false: true });
        }
    }
	
	function showNotification(messageText) {
		let details = {
			type: Office.MailboxEnums.ItemNotificationMessageType.ProgressIndicator,
			message: messageText,
			persistent: false
		};
		
		if(messageText === "remove")
			mailboxItem.notificationMessages.removeAsync('progress');
		else
			mailboxItem.notificationMessages.replaceAsync('progress', details);
	}
	
	function pixelToPercentage(widthInPixel, heightInPixel) {
		let width = Math.floor(100 * widthInPixel / screen.width);
		let height = Math.floor(100 * heightInPixel / screen.height);
		
		return { width: width, height: height };
	}
		
	async function openDialogWindow(url, ancho, alto) {
		if(value.OWAPlatform && screen.height < 1000) {
			ancho += 13;
			alto += 7;
			
		} else if(!value.OWAPlatform) {//Este remidensionamiento en pixeles solo funciona con las versiones de escritorio
			/*
			let alto = (Office.context.platform == "Mac")?200:200;
			let dim = pixelToPercentage( (url.indexOf('Warning.html') > -1)?400:alto, 750);
			
			ancho = dim.width;
			alto = dim.height;
			*/
			url += "?extra_param=MetaCleanDesktopVersion&vh="+screen.height+"&clientType="+Office.context.platform;
			
			if(screen.height < 800)
				alto += 12;
		}
		
		//let ffff = pixelToPercentage(850, 500);
		//console.log("screen.height " + screen.height + " screen.width: " + screen.width + " ancho: " + ffff.width + " alto: " + ffff.height + " VH: " + document.getElementsByTagName('body')[0].clientHeight);
				
		Office.context.ui.displayDialogAsync(url, { height: alto, width: ancho, displayInIframe: true },
			function (modalDialog) {
				if(modalDialog.status === Office.AsyncResultStatus.Failed) {
					value.isErrorOnDialogOpen = true;
					/*
					if(modalDialog.error.code === 12007) {
						//https://learn.microsoft.com/en-us/office/dev/add-ins/develop/dialog-best-practices#open-another-dialog-immediately-after-closing-one
						//openDialogWindow(url, ancho, alto); // Recursive call
					}
					*/
					console.error("Error al abrir la ventana Modal --> " + modalDialog.error.code + " :::: " + modalDialog.error.message);
					
				} else {
					value.isErrorOnDialogOpen = false;
					value.Dialog = modalDialog.value;
										
					value.Dialog.addEventHandler(Office.EventType.DialogEventReceived, processDialogEvent);
					value.Dialog.addEventHandler(Office.EventType.DialogMessageReceived, processDialogMessage);
				}
			}
		);
	}
			
	async function needProcessAttachments(result) {
		let procesarFicherosAdjuntosEmail = false;
		
		try {
			if (result.attachObjectArray.length === 0 || !content.enableMetaCleanPlugIn)
				return procesarFicherosAdjuntosEmail;
				
			for (let i = 0; i < result.attachObjectArray.length; i++) {
				let extensionFile = (result.attachObjectArray[i].name.split('.').length > 1) ? result.attachObjectArray[i].name.split('.').pop().toLowerCase() : '';
					
				if(result.attachObjectArray[i].attachmentType === 'file' && result.attachObjectArray[i].size > 0 && extensionFile.length > 1 && content.isSupportedFormat(extensionFile)) {
					//console.log('Analizo el fichero ---> ' + result.attachObjectArray[i].name);
					procesarFicherosAdjuntosEmail =  true;
					break;
				} 
			}
			
			if(procesarFicherosAdjuntosEmail) {
				//Comprobamos WhiteList
				let whiteList = _settings.get("MetaCleanWhiteList");
			
				if(whiteList != null && whiteList != undefined && whiteList.length > 3) {
					let trustedTo = await isTrustedTo(whiteList);
					
					if(trustedTo.trustedRecipients) {
						let trustedCc = await isTrustedCc(whiteList);
					
						if(trustedCc.trustedRecipients) {
							let trustedBcc = await isTrustedBcc(whiteList);
					
							if(trustedBcc.trustedRecipients) {
								//console.log("Todos los destinatarios son de CONFIANZA !!!");
								procesarFicherosAdjuntosEmail = false;
							}
						}
					}
				}
			}
			
		} catch (error) {
			console.error("Excepcion en needProcessAttachments(): " + (error.message != null ? error.message: "---"));
		}
			
		return procesarFicherosAdjuntosEmail;
	}
	
	function isTrustedTo(whiteList) {
		return new Promise(resolve => {
			mailboxItem.to.getAsync(function(asyncResult) {
				if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
					let msgTo = asyncResult.value;
					
					try {
						for (let i = 0; i < msgTo.length; i++) {
							let toEmail = msgTo[i].emailAddress.split('@').pop();
							
							//console.log("Para --> (" + msgTo[i].emailAddress + ") whiteList --> " + whiteList + " toEmail --> " + toEmail);
							
							if(!whiteList.includes(toEmail)) {
								//console.log("Dominio no confiable !!! " + toEmail);
								resolve({ message: 'Success', trustedRecipients: false });
								break;
							}
						}						
					} catch(error) {
						console.error("Excepcion al obtener los destinatarios TO :::: " + (error.message != null ? error.message : "---") + " :::: " + msgTo);
						
						resolve({ message: 'Success', trustedRecipients: false });
					}
					
					resolve({ message: 'Success', trustedRecipients: true });
					
				} else {
					resolve({ message: asyncResult.error.message, trustedRecipients: false });
				}
			});
		});
	}
	
	function isTrustedCc(whiteList) {
		return new Promise(resolve => {
			mailboxItem.cc.getAsync(function(asyncResult) {
				if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
					let msgTo = asyncResult.value;
					
					try {
						for (let i = 0; i < msgTo.length; i++) {
							let toEmail = msgTo[i].emailAddress.split('@').pop();
							
							//console.log("Copia --> (" + msgTo[i].emailAddress + ") whiteList --> " + whiteList + " toEmail --> " + toEmail);
							
							if(!whiteList.includes(toEmail)) {
								//console.log("Dominio no confiable !!! " + toEmail);
								resolve({ message: 'Success', trustedRecipients: false });
								break;
							}
						}
					} catch(error) {
						console.error("Excepcion al obtener los destinatarios CC :::: " + (error.message != null ? error.message : "---") + " :::: " + msgTo);
						
						resolve({ message: 'Success', trustedRecipients: false });
					}
					
					resolve({ message: 'Success', trustedRecipients: true });
					
				} else {
					resolve({ message: asyncResult.error.message, trustedRecipients: false });
				}
			});
		});
	}
	
	function isTrustedBcc(whiteList) {
		return new Promise(resolve => {
			mailboxItem.bcc.getAsync(function(asyncResult) {
				if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
					let msgTo = asyncResult.value;
					
					try {
						for (let i = 0; i < msgTo.length; i++) {
							let toEmail = msgTo[i].emailAddress.split('@').pop();
							
							//console.log("Copia Oculta --> (" + msgTo[i].emailAddress + ") whiteList --> " + whiteList + " toEmail --> " + toEmail);
							
							if(!whiteList.includes(toEmail)) {
								//console.log("Dominio no confiable !!! " + toEmail);
								resolve({ message: 'Success', trustedRecipients: false });
								break;
							}
						}
					} catch(error) {
						console.error("Excepcion al obtener los destinatarios BCC :::: " + (error.message != null ? error.message : "---") + " :::: " + msgTo);
						
						resolve({ message: 'Success', trustedRecipients: false });
					}
					
					resolve({ message: 'Success', trustedRecipients: true });
					
				} else {
					resolve({ message: asyncResult.error.message, trustedRecipients: false });
				}
			});
		});
	}
	
	function getAllAttchmentObjects() {
		return new Promise(resolve => {
			let attachmentsArray = [];
			
            mailboxItem.getAttachmentsAsync(function (result) {
				if (result.status !== Office.AsyncResultStatus.Succeeded) {
					//console.log(result.error.message);
					resolve({ message: result.error.message, attachObjectArray: attachmentsArray });
						
				} else {
					resolve({ message: 'Success', attachObjectArray: result.value });
				}
            });
		});
	}
	
	function getAttachmentContent(attachment) {
		return new Promise(resolve => {
			mailboxItem.getAttachmentContentAsync(
				attachment.id,
				{ asyncContext : { nombreFichero: attachment.name, attachID: attachment.id} },
				function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded) {
						//console.log(`Error al descargar el fichero: ${result.asyncContext.nombreFichero} :::: ${result.error.message}`);
						
						resolve({ message: result.error.message});
						
					} else if(result.value.format === Office.MailboxEnums.AttachmentContentFormat.Base64) {
						//console.log(`Attachment content loaded successfully: ${result.asyncContext.nombreFichero}`);
						
						resolve({ message: 'Success', attachID: result.asyncContext.attachID, attachName: result.asyncContext.nombreFichero, attachContent: result.value.content });
						
					} else {
						//console.log(`Error al descargar el fichero: ${result.asyncContext.nombreFichero} :::: FileType :::: ${result.value.format}`);
						
						resolve({ message: `Error al descargar el fichero: ${result.asyncContext.nombreFichero} :::: FileType :::: ${result.value.format}`});
					}
				}
			);
		});
	}
	
	function processMetadata(fileContent, attachmentName) {
		return new Promise(resolve => {
			bstr = atob(fileContent), 
            n = bstr.length, 
            u8arr = new Uint8Array(n);
            
			while(n--) {
				u8arr[n] = bstr.charCodeAt(n);
			}
			
			let formData = new FormData();
			let tipo_licencia = (content.enterpriseLicense != null && content.enterpriseLicense.length > 0) ? " -Professional_License-" : " -Trial_License-";
							
			if(content.enableMetaCleanPDFSigned) {
				formData.append('forcePdfProcess', 'force');
				//formData.append('forceWordProcess', 'force');
			}
			
			formData.append('appName', 'MetaCleanForOutlook_New v.4.1.0 (' + Office.context.platform + ') :::: ' + content.emailSender + " :::: " + tipo_licencia);
			formData.append('enabledFileTypes', content.getSupportedExtensions());
			
			if(content.emailSender != null && content.emailSender.includes("@"))
				formData.append('eMailSender', content.emailSender);
			
			//Cliente con Dashboard contratado
			if(content.urlDashboard.length > 0 && content.urlDashboard.toLowerCase().startsWith("http") && content.metadataTemplateValues != null && content.metadataTemplateValues)
				formData.append('metadataPolicy', JSON.stringify(content.metadataTemplateValues));				
			else if(content.enterpriseLicense != null && content.enterpriseLicense.length > 0)
				formData.append('licenseType', content.enterpriseLicense);
			
			//EL ULTIMO CAMPO A AÑADIR DEBE SER ESTE
			formData.append('file', new File([u8arr], attachmentName));
						
			fetch(content.urlService, {
				method: 'POST',
				body: formData,
				signal: timeoutFetch(60).signal
										
			}).then(function(response) {
				if(response.ok) {
					let ct = response.headers.get("content-type") || "";
											
					if ( (ct.indexOf('xml') > -1) || (ct.indexOf('json') > -1) ) {
						response.json().then(data => {
							let output = data[0];
							let mensajeSalida = (output.msgError.length > 0) ? output.msgError : output.msgOut;
							let processsedFileURL = "";
							
							if( (mensajeSalida === "Metadata removed successfully" || (mensajeSalida.startsWith("Track c") && mensajeSalida.includes("activated in the document"))) 
								&& output.serverURL != null && output.serverURL.toLowerCase().startsWith("http")) {
								
								//Usamos la funcion: Normalize para eliminar los acentos de los nombres de los ficheros.
								const urlToFile = output.serverURL + "?fileID=" + encodeURIComponent(output.dataFileId) + "&originalFileName=" + encodeURIComponent(output.dataFileName.normalize("NFD").replace(/[\u0300-\u036f]/g, "")) + "&outlookRequest=newOutlook";
								processsedFileURL = new String(urlToFile);
								
								//console.log("urlToFile: " + urlToFile + " output.dataFileName: " + output.dataFileName);
							}
							
							resolve({
								message: mensajeSalida,
								blobFile: processsedFileURL,
								responseCode: response.status,
								fileName: attachmentName
							});
						})
													
					} else {
						response.blob().then(miBlob => {
							resolve({
								message: 'Success',
								blobFile: miBlob,
								responseCode: response.status,
								fileName: attachmentName
							});
						})
					}
												
				} else {
					resolve({
						message: 'Server response failed' + (response.message != null ? ' :::: ' + response.message : ''),
						blobFile: "",
						responseCode: response.status != null ? response.status:"",
						fileName: attachmentName
					});
				}
										
			}).catch(function(error) {
				let messageError = 'MetaClean O365 response failed. ' + ( (error.message != null && error.message === 'Failed to fetch') ? 'Click on the "send" button to send the mail.' : error.message);
				
				//console.log('Error Fetch :::: ' + attachmentName + ' :::: ' + messageError);
				
				resolve({
					message: messageError,
					blobFile: "",
					responseCode: 500,
					fileName: attachmentName
				});
			});
		
		});
	}	
	
	function removeAttachment(attachmentName, attachmentID) {
		return new Promise(resolve => {
			mailboxItem.removeAttachmentAsync(
				attachmentID,
				{ asyncContext : { nombreFichero: attachmentName} },
				function(result) {
					if (result.status !== Office.AsyncResultStatus.Succeeded) {
						//console.log(`Error al borrar el fichero: ${result.asyncContext.nombreFichero} :::: ${result.error.message}`);
								
						resolve({ message: result.error.message });
								
					} else {
						//console.log(`Attachment removed successfully: ${result.asyncContext.nombreFichero}`);
								
						resolve({ message: 'Success' });
					}
				}
			);
		});
	}
	
	function addAttachment(blob, attachmentName) {
		return new Promise(resolve => {
            //base64String = "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAAAsSAAALEgHS3X78AAACRUlEQVRYw82XzXHbMBCFP2F8tzsQc8Ixyh0zoiuIXIGdCsxUYKqC0B04FdiuwMoM7mGOOIXqQGoAymXhgSX+itJM9kIRFLAP+3YXD5Pdbscx5oxaAIW8Ztr6l2PWmQwF4IyaieP53qdfAqQ8CwBn1JU4vpWhrbxXQA5MZfynANmcDIAzKgcy4FKGXsVJFf3nLgKyBQptfT4KQMRz2N0fcbxqmRMDWXflx0VPnrdArq0vekQ1Dv0UeHZGNebHhwjU8AzwKM43RyZnbAf58Q6ghudeWd0Aus0+5EcMIIRi3beua0D3Nm39BEAx3i7HTK4DEBJn5YxKOnaRA5+ErpMBWMpzDvx1RuXCcxOISlufAjfC7zgAsqsvUvMAD0ApPaEtGi9AIlUzKgJo60tt/SyKRkzLrAXERluf7W1gOICWaMyB386oooOWsIHvXbSoHuUSFovtHqicUVnH3EJoeT0aQEf5/XBGlc6otIOWBXAtPeZkAIJ9Bt6cUU9tZautX2nrk3MACHYr1ZKProKRtDw4o8pzAPjWo+NtpXTTvoteDDg8noDAcwbcRedAkGdFXyk2GEDcegVAFp2gyVDHjRQ4o6q2smoqtR5Hd+qMqtoALCWUUymr1m43QMZfOaMK4C0SrMsDANJ2E5FNcbdbjHC+ENl+H0myJFbLtaq4Rt8dyPBYRQV1E40nMv9rl7xrOw3DGb+Whcqu3i/OM6CUOWvgRlufNmnLYy4m77uJI7AXtdNcTDrU71LEyv7v01/N/ovL6bmu5/8A1tNWZldH0W4AAAAASUVORK5CYII=";
            
			if(blob instanceof String) {
				try {
					mailboxItem.addFileAttachmentAsync(
						blob.valueOf(),
						attachmentName,
						{ isInline: false },
						function(result) {
							if (result.status === Office.AsyncResultStatus.Succeeded) {
								//console.log(`Attachment added successfully`);
									
								resolve({ message: 'Success'});
								  
							} else {
								//console.error(`addFileAttachmentAsync: ${result.error}`);
								resolve({ message: result.error.message });
							}
						});
				} catch (e) {
					let mensajeError = (e.message != null && e.message.length > 0) ? e.message : '---';
					resolve({ message: mensajeError });
				}
					
			} else {
				let reader = new FileReader();
				reader.readAsDataURL(blob);
				
				reader.onloadend = function() {
					try {
						mailboxItem.addFileAttachmentFromBase64Async(
							reader.result.split(',')[1],
							attachmentName,
							{ isInline: false },
							function(result) {
								if (result.status === Office.AsyncResultStatus.Succeeded) {
									//console.log(`Attachment added successfully`);
									
									resolve({ message: 'Success'});
								  
								} else {
									//console.error(`addFileAttachmentFromBase64Async: ${result.error}`);
									resolve({ message: result.error.message });
								}
						});
					} catch (e) {
						let mensajeError = (e.message != null && e.message.length > 0) ? e.message : '---';
						resolve({ message: mensajeError });
					}
				}
			}
		});
	}
	
	function delay(time) {
		return new Promise(resolve => setTimeout(resolve, time));
	}
		
	var content = {
		getSupportedExtensions() {
			let tmp = (content.enableMetaCleanMSOffice?"mo,":"") + (content.enableMetaCleanOpenOffice?"oo,":"") + (content.enableMetaCleanPDF?"pdf,":"") + (content.enableMetaCleanMultimedia?"mm":"");
			tmp = tmp.endsWith(",")?tmp.slice(0, -1):tmp;
			
			return tmp;
		},
		isSupportedFormat(extensionFile) {
			if ( (content.enableMetaCleanMSOffice && content.microsoftOfficeExtensions.includes(extensionFile)) || (content.enableMetaCleanOpenOffice && content.openOfficeExtensions.includes(extensionFile)) || (content.enableMetaCleanPDF && content.pdfExtensions.includes(extensionFile)) 
				|| (content.enableMetaCleanCompressed && content.compressedExtensions.includes(extensionFile) && (content.enableMetaCleanMSOffice || content.enableMetaCleanOpenOffice || content.enableMetaCleanPDF || content.enableMetaCleanMultimedia)) 
			|| (content.enableMetaCleanMultimedia && content.multimediaExtensions.includes(extensionFile)) )
				return true;
			else
				return false;
		},
		extractEmails(text) {
			let results = text.match(/([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9_-]+)/gi);
			
			if(results != null && results.length > 0)
				return results[0];
			else
				return "";
		},
		microsoftOfficeExtensions: ["doc", "dot", "docx", "docm", "dotx", "dotm", "xls", "xlt", "xlsx", "xlsm", "xltx", "xltm", "xlsb", "ppt", "pot", "pptx", "pptm", "potx", "potm", "ppsx", "ppsm", "vsd", "rtf"],
		multimediaExtensions: [
			"mp3", "arw", "cr2", "dng", "fff", "cs1", "erf", "iiq", "mef", "mrw", "nef", "nrw", "orf", "pef", "raf", "raw", "rw2", "rwl", "sr2", "srw", "x3f", "3g2", "3gp2", "3gp", "3gpp", "dvb", "f4a", "f4b", "f4p", "f4v", "m4a", "m4b", "m4p", "m4v", "mov", "qt", "mp4", "mqv", "qtif", "qti", "qif", "dcp", "exv", "gif", "hdp", "wdp", "jxr", "jp2", "icc", "icm", "jpf", "j2k", "jpm", "jpx", "jpeg", "jpg", "jpe", "mie", "mos", "mpo", "png", "jng", "mng", "psd", "psb", "thm", "tiff", "tif", "vrd", "dng", "aax", "ai", "ait", "arq", "avif", "crw", "cr3", "crm", "ciff", "dr4", "eps", "ps", "epsf", "exif", "flif", "gpr", "heic", "heif", "hif", "lrv", "xmp" 
		],
		openOfficeExtensions: ["odt", "ods", "odp"],
		compressedExtensions: ["zip", "7z"],
		pdfExtensions: ["pdf"],
		fileBuffer: [],
		composeNotice: null,
		fileNameMessages: [],
		enableMetaCleanPlugIn: true,
		enableMetaCleanMSOffice: true,
		enableMetaCleanOpenOffice: true,
		enableMetaCleanPDF: true,
		enableMetaCleanMultimedia: false,
		enableMetaCleanCompressed: true,
		enableMetaCleanPDFSigned: false,
		enableMetaCleanTrackChanges: true,
		urlService: 'https://metaclean.es/MetaCleanOnline/service/file',
		emailSender: "",
		enabledFileTypes: "",
		webServiceUrlRetrieved: false,
		personalEmailSender: false,
		enterpriseLicense: "Corporativo",
		apiKey: "",
		urlDashboard: "",
		canEditConfig: 1,
		selectFilesToProcess: 0,
		metadataTemplateUpdateMinutes: 15,
		metadataTemplateValues: ""
	}
	
	function getWebServiceUrl() {
		return new Promise(resolve => {
			try {
				let emailDomain = "";
				
				if(content.emailSender.length === 0 || !content.emailSender.includes("@")) {
					content.personalEmailSender = true;
					resolve('No se ha obtenido la direccion de email del cliente: ' + content.emailSender);
					
				} else
					emailDomain = content.emailSender.split("@")[1];
				
				if(emailDomain.startsWith("outlook.") || emailDomain.startsWith("hotmail.") || emailDomain.startsWith("live.com")) {
					content.webServiceUrlRetrieved = true;
					content.personalEmailSender = true;
					resolve('Usuario no corporativo: ' + content.emailSender);
					
				} else if(!content.webServiceUrlRetrieved) {
					let formData = new FormData();
					formData.append('getEmailProperties', content.emailSender);
					formData.append('tipoApp', 1);
										
					fetch('https://www.adarsus.com/bat/emailExtension/activation.php', {
						method: 'POST',
						headers: { 'cache-control': 'no-cache' },
						body: formData,
						signal: timeoutFetch(5).signal
					}).then(response => {
						if (response.ok) {
							response.json()
								.then(emailProperties => {
									let responseText = "Corporativo";
										
									if(emailProperties.length > 0) {
										if(emailProperties[0].URL_Web_Service != null && emailProperties[0].URL_Web_Service.startsWith("http"))
											content.urlService = emailProperties[0].URL_Web_Service;
										else
											content.urlService = 'https://metaclean.es/MetaCleanOnline/service/file';
																								
										_settings.set("MetaCleanWebServiceUrl", content.urlService);
											
										if(emailProperties[0].URL_Dashboard != null && emailProperties[0].URL_Dashboard.startsWith("http"))
											content.urlDashboard = emailProperties[0].URL_Dashboard;
										else
											content.urlDashboard = "";
										
										_settings.set("MetaCleanDashboardUrl", content.urlDashboard);
											
										if(emailProperties[0].PuedeCambiarConfig != null)
											content.canEditConfig = emailProperties[0].PuedeCambiarConfig;
										else
											content.canEditConfig = 1;
												
										_settings.set("MetaCleanCanEditConfig", content.canEditConfig);
										
										//Si no puede editar la configuracion y no hay Dashboard
										if(content.canEditConfig == 0 && content.urlDashboard.length == 0) {
											if(emailProperties[0].SelecFicherosProcesar != null)
												content.selectFilesToProcess = emailProperties[0].SelecFicherosProcesar;
											else
												content.selectFilesToProcess = 0;
													
											_settings.set("MetaCleanSelectFilesToProcess", content.selectFilesToProcess);
										}
																						
										content.enterpriseLicense = "Corporativo";
										content.webServiceUrlRetrieved = true;										
										_settings.set("webServiceUrlRequestDate", new Date().getTime());
									
									} else
										responseText = "NoExisteCliente";
																	
									resolve(responseText);
															
								}).catch((error) => { resolve("Error de conexión :::: " + error.message) });
														
						} else 
							resolve('response no devuelve OK :::: ' + response.message);
										
					}).catch((error) => { resolve("Excepcion en la salida fetch :::: " + error.message) });
								
				} else
					resolve("Web Service URL se estableció previamente a: " + urlService + " para el usuario: " + content.emailSender);
				
			} catch(error) {
				resolve("Error en la ejecucion getWebServiceUrl :::: " + error.message)
			}
		});
	}
	
	function timeDifference(date1, period) {
		let result = 100;
		
		try {
			//calculate time difference  
			let time_difference = new Date().getTime() - date1;  			

			if(period == 'days')
				result = time_difference / (1000 * 60 * 60 * 24);
			else if(period == 'hours')
				result = time_difference / (1000 * 60 * 60);
			else if(period == 'minutes')
				result = time_difference / (1000 * 60);
			else if(period == 'seconds')
				result = time_difference / 1000;

		} catch(error) {
			console.error("Error en la ejecucion timeDifference :::: " + error.message);
		}
		
		//console.log("timeDifference: " + result + " " + period);
		
		return result;
	}
	
	function getEmailSender() {
		return new Promise(resolve => {
			try {
				//Obtenemos el email del sender
				mailboxItem.from.getAsync(function(asyncResult) {
					if (asyncResult.status === Office.AsyncResultStatus.Succeeded) {
						content.emailSender = asyncResult.value.emailAddress;					
						_settings.set("MetaCleanEmailSender", content.emailSender);
							
						saveConfig();
							
						//console.log("Message from: " + asyncResult.value.displayName + " (" + asyncResult.value.emailAddress + ")");
							
						resolve({ message: content.emailSender });
								
					} else {
						//console.error("Email no identificado :::: " + asyncResult.error);					
						content.emailSender = "Email no identificado";
						
						resolve({ message: content.emailSender });
					}
				});
					
			} catch(error) {
				resolve({ message: "Error en la ejecucion getEmailSender :::: " + error.message });
			}
		});
	}
	
	async function getOutlookConfig() {
		try {
			const url = content.urlDashboard + "&clientType=email&computerName=" + content.emailSender;
				
			//console.log("URL Dashboard: " + url);
				
			const response = await fetch(url, {
				method: 'GET',
				headers: {
					'Content-Type': 'application/x-www-form-urlencoded'
				},
				signal: timeoutFetch(5).signal
			});
				
			if (response.ok) {
				content.outlookConfig = await response.json();
				
				_settings.set("metadataTemplateRequestDate", new Date().getTime());
				_settings.set("MetaCleanMetadataTemplateUpdateInterval", content.outlookConfig.templates_update_interval_minutes);				
				_settings.set("MetaCleanMetadataTemplateValues", content.outlookConfig.plantilla);
				content.metadataTemplateValues = content.outlookConfig.plantilla;
				content.metadataTemplateUpdateMinutes = content.outlookConfig.templates_update_interval_minutes;
				
				if(content.outlookConfig.allow_change_configuration != null) {
					content.canEditConfig = content.outlookConfig.allow_change_configuration;
					_settings.set("MetaCleanCanEditConfig", content.canEditConfig);
					
					if(content.canEditConfig == 1)
						return;
				}
				
				if(content.outlookConfig.choose_files_to_process != null) {
					content.selectFilesToProcess = content.outlookConfig.choose_files_to_process;
					_settings.set("MetaCleanSelectFilesToProcess", content.selectFilesToProcess);
				}
					
				if(content.outlookConfig.metaclean_power == 0) {
					_settings.set("MetaCleanAddIn", "");
					
				} else {
					let supportFileTypes = "";
						
					if(content.outlookConfig.dominios_excluidos && content.outlookConfig.dominios_excluidos.length > 3)
						_settings.set("MetaCleanWhiteList", content.outlookConfig.dominios_excluidos.replace(",", "|").replace(" ", ""));
					else
						_settings.set("MetaCleanWhiteList", "");
						
					if(content.outlookConfig.microsoft_office)
						supportFileTypes += "MetaCleanMSOffice";
						
					if(content.outlookConfig.pdf)
						supportFileTypes += "MetaCleanPDF";
						
					if(content.outlookConfig.open_office)
						supportFileTypes += "MetaCleanOpenOffice";
						
					if(content.outlookConfig.archivo_comprimido)
						supportFileTypes += "MetaCleanCompressed";
						
					if(content.outlookConfig.show_warnings_track_changes_ms_documents)
						supportFileTypes += "MetaCleanTrackChanges";
						
					if(content.outlookConfig.multimedia)
						supportFileTypes += "MetaCleanMultimedia";
						
					_settings.set("MetaCleanAddIn", supportFileTypes);
				}
								
				content.enableMetaCleanMSOffice = content.outlookConfig.microsoft_office;
				content.enableMetaCleanOpenOffice = content.outlookConfig.open_office;
				content.enableMetaCleanPDF = content.outlookConfig.pdf;
				content.enableMetaCleanMultimedia = content.outlookConfig.multimedia;
				content.enableMetaCleanCompressed = content.outlookConfig.archivo_comprimido;
				content.enableMetaCleanPDFSigned = content.outlookConfig.pdf;
				content.enableMetaCleanTrackChanges = content.outlookConfig.show_warnings_track_changes_ms_documents;				
			
				content.enableMetaCleanPlugIn = (content.enableMetaCleanMSOffice || content.enableMetaCleanOpenOffice || content.enableMetaCleanPDF || content.enableMetaCleanMultimedia || content.enableMetaCleanCompressed)?true:false;
					
				saveConfig();
				
				//console.log(content.outlookConfig);
				//console.log("Tipo Plantilla: " + content.outlookConfig.plantilla.tipo);
				
			} else
				console.error("Error en la peticion de la plantilla de configuracion de Outlook: " + url + " Respuesta: " + response.status);			
					
		} catch (error) {
			console.error("Excepcion al obtener la configuracion de Outlook: " + error.message);
		}
	}
		
	async function registerComputer() {
		try {				
			const data = new URLSearchParams();
				
			data.append('computerName', content.emailSender);
			data.append('apiKey', content.apiKey);
			data.append('userName', content.emailSender);
			data.append('producto', 'MetaCleanForOutlook');
			data.append('metacleanID', content.emailSender);
			
			const response = await fetch(content.urlDashboard, {
				method: 'POST',
				headers: {
					'Content-Type': 'application/x-www-form-urlencoded'
				},
				body: data,
				signal: timeoutFetch(5).signal
			});
					
			if (response.ok) {
				const result = await response.text(); 
					
				if(result.startsWith('Correcto')) {
					_settings.set("registerComputerRequestDate", new Date().getTime());
					_settings.set("MetaCleanDashboardUrl", content.urlDashboard);
					_settings.set("dashboardApiKey", content.apiKey);
						
					await getOutlookConfig();
						
				} else if(result.startsWith("NoExisteCliente") /*|| result.startsWith("NumeroLicenciasExcedido")*/) {
					//Deshabilitamos el Addin
					_settings.set("MetaCleanAddIn", "");
								
					//console.error("No se ha registrado la licencia: " + result);
					saveConfig();
				}
					  
			} else {
				console.error("Error al registrar la licencia Outlook: " + content.urlDashboard + " Respuesta: " + response.status);
			}
					
		} catch (error) {
			console.error("Excepcion al registrar la licencia Outlook: " + error.message);
		}
	};