/* Store the locale-specific strings */

var UIStrings = (function () {
    "use strict";

    var UIStrings = {};

    // JSON object for English strings
    UIStrings.EN = {
		"procesandoFicheros": "Processing files, please wait...",
        "enviar": "Send",
        "cancelar_envio": "Cancel",
		"aceptar_cambios": "Accept Changes",
		"titleH1MetaClean": "MetaClean Settings",
		"legendOfficeDocuments": "Office Documents",
		"legendMultimediaFiles": "Multimedia Files",
		"legendLabelMultimediaFiles": "Image, Audio and Video",
		"legendLabelSignedFiles": "Signed",
		"legendCompressedFiles": "Compressed Files",
		"legendLabelCompressedFiles": "ZIP and 7Z",		
		"legendTrackChangesFiles": "Display Warning Messages",
		"legendLabelTrackChangesFiles": "Track Changes or Comments",		
		"legendWhiteList": "Trusted Domains",
		"warningPDFSigned": "Signed PDF file",
		"warningPDFSigneds": "Signed PDF files",
		"warningOcurredFull": "The following warnings have been issued",
		"warningOcurred": "Warnings issued",
		"licenciaExpirada": "Expired professional license",
		"recargarConfiguracion": "Connection error@@@Please reload the configuration.",
		"usuarioNoAutorizado": "Change not allowed@@@You are not authorized to make changes to the configuration.",
		"selectFilesToClean": "Select the files to be processed",
		"legendSelectFilesToProcess": "Metadata Processing",
		"legendLabelSelectFilesToProcess": "Select Files Manually",
		"sendEmailButtonTitle": "Processes the metadata of the selected files and sends the email"
    };

    // JSON object for Spanish strings
    UIStrings.ES = {
		"procesandoFicheros": "Procesando ficheros, por favor espere...",
        "enviar": "Enviar",
        "cancelar_envio": "Cancelar",
		"aceptar_cambios": "Aceptar Cambios",
		"titleH1MetaClean": "Ajustes MetaClean",
		"legendOfficeDocuments": "Archivos Ofimáticos",
		"legendMultimediaFiles": "Archivos Multimedia",
		"legendLabelMultimediaFiles": "Imagen, Audio y Vídeo",
		"legendLabelSignedFiles": "Firmados",
		"legendCompressedFiles": "Archivos Comprimidos",
		"legendLabelCompressedFiles": "ZIP y 7Z",
		"legendTrackChangesFiles": "Mostrar Avisos",
		"legendLabelTrackChangesFiles": "Control Cambios",
		"legendWhiteList": "Dominios de Confianza",
		"warningPDFSigned": "Fichero PDF firmado",
		"warningPDFSigneds": "Ficheros PDF firmados",
		"warningOcurredFull": "Se han producido las siguientes advertencias",
		"warningOcurred": "Avisos producidos",
		"licenciaExpirada": "Licencia profesional expirada",
		"recargarConfiguracion": "Error de conexión@@@Recargue la configuración por favor.",
		"usuarioNoAutorizado": "Cambio no permitido@@@No está autorizado a realizar cambios en la configuración.",
		"selectFilesToClean": "Seleccione los archivos a procesar",
		"legendSelectFilesToProcess": "Procesamiento de Metadatos",
		"legendLabelSelectFilesToProcess": "Seleccionar Ficheros Manualmente",
		"sendEmailButtonTitle": "Procesa los metadatos de los ficheros seleccionados y envía email"
    };

    UIStrings.getLocaleStrings = function (locale) {
        var text;

        // Get the resource strings that match the language.
        switch (locale) {
            case 'en-US':
                text = UIStrings.EN;
                break;
            case 'es-ES':
                text = UIStrings.ES;
                break;
            default:
                text = UIStrings.EN;
                break;
        }

        return text;
    };

    return UIStrings;
})();